/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.sim.software;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.AbstractMemoryElement;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.ModeLabelAccess;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.amalthea.validations.sim.software.SimSoftwareMemoryAccessHelper;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="Sim-Software-ModeLabelAccessFeasibility", checks={"Checks if a modeLabel access can be performed from certain runnable"})
public class SimSoftwareModeLabelAccessFeasibility
extends AmaltheaValidation {
    public static final String MESSAGE = "ModeLabel's memory location is not accessible from each core, onto which this activity item is deployed";

    public EClassifier getEClassifier() {
        return ePackage.getModeLabelAccess();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof ModeLabelAccess) {
            ModeLabelAccess modeLabelAccess = (ModeLabelAccess)eObject;
            if (modeLabelAccess.getData() == null) {
                return;
            }
            ModeLabel abstractMemoryElement = modeLabelAccess.getData();
            if (!SimSoftwareMemoryAccessHelper.validate((ActivityGraphItem)modeLabelAccess, (AbstractMemoryElement)abstractMemoryElement)) {
                this.addIssue(results, (EObject)modeLabelAccess, (EStructuralFeature)ePackage.getModeLabelAccess_Data(), MESSAGE);
            }
        }
    }
}

