/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor.actions;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.editor.util.AmaltheaEditorUtil;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.app4mc.validation.ui.ProfileDialog;
import org.eclipse.app4mc.validation.ui.ProfileDialogSettings;
import org.eclipse.app4mc.validation.ui.ValidationUIPlugin;
import org.eclipse.app4mc.validation.ui.util.ValidationExecutorWithMonitor;
import org.eclipse.app4mc.validation.ui.util.ValidationMarkerHelper;
import org.eclipse.app4mc.validation.util.ValidationExecutor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateAction
extends Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateAction.class);
    private IEditorPart editorPart;

    public ValidateAction() {
        super("Validate", 1);
        Bundle bundle = FrameworkUtil.getBundle(ProfileDialogSettings.class);
        if (bundle != null) {
            this.setImageDescriptor(ResourceLocator.imageDescriptorFromBundle((String)bundle.getSymbolicName(), (String)"/icons/full/obj16/test.png").orElse(null));
        }
        this.setToolTipText("Validate model");
    }

    public void setActiveEditor(IEditorPart editor) {
        this.editorPart = editor;
    }

    public void run() {
        IEclipseContext windowCtx = (IEclipseContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IEclipseContext.class);
        ProfileDialogSettings settings = (ProfileDialogSettings)ContextInjectionFactory.make(ProfileDialogSettings.class, (IEclipseContext)windowCtx);
        IDialogSettings store = ValidationUIPlugin.getDefault().getDialogSettings();
        settings.loadFrom(store);
        ProfileDialog dialog = new ProfileDialog(Display.getDefault().getActiveShell(), settings);
        if (dialog.open() == 0 && settings.getDialogResults() != null) {
            Resource resource;
            List<EObject> rootObjects;
            HashSet selectedProfiles = new HashSet(settings.getDialogResults());
            if (selectedProfiles.isEmpty()) {
                return;
            }
            settings.saveTo(store);
            if (LOGGER.isInfoEnabled()) {
                StringBuilder builder = new StringBuilder("Selected profiles:");
                for (Class sc : selectedProfiles) {
                    builder.append("\n\t- ");
                    builder.append(sc.getName());
                }
                LOGGER.info(builder.toString());
                LOGGER.info("Available processors: {}", (Object)Runtime.getRuntime().availableProcessors());
            }
            if ((rootObjects = this.computeRootObjects(resource = AmaltheaEditorUtil.getResource(this.editorPart.getEditorInput()), settings.getScope())).isEmpty()) {
                return;
            }
            final ValidationExecutorWithMonitor executor = new ValidationExecutorWithMonitor(selectedProfiles);
            Job job = new Job("Model Validation"){

                protected IStatus run(IProgressMonitor monitor) {
                    return executor.validateWithMonitor(rootObjects, monitor);
                }
            };
            if (LOGGER.isDebugEnabled()) {
                job.addJobChangeListener((IJobChangeListener)this.logValidationResults((ValidationExecutor)executor));
            }
            job.addJobChangeListener((IJobChangeListener)this.updateMarkersWhenDone((ValidationExecutor)executor, rootObjects));
            job.addJobChangeListener((IJobChangeListener)this.showMessageDialogWhenDone((ValidationExecutor)executor));
            job.schedule();
        }
    }

    private List<EObject> computeRootObjects(Resource resource, String scope) {
        List<Amalthea> models;
        ArrayList<EObject> rootObjects = new ArrayList<EObject>();
        if (resource == null) {
            return rootObjects;
        }
        if ("File".equals(scope)) {
            Amalthea model = AmaltheaEditorUtil.getModel(resource);
            if (model != null) {
                rootObjects.add((EObject)model);
            }
        } else if ("Folder".equals(scope) && (models = AmaltheaEditorUtil.getModels(resource.getResourceSet())) != null) {
            rootObjects.addAll(models);
        }
        return rootObjects;
    }

    private JobChangeAdapter logValidationResults(final ValidationExecutor executor) {
        return new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK() && LOGGER.isDebugEnabled()) {
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream(byteStream, true);
                    executor.dumpResultMap(printStream);
                    LOGGER.debug(byteStream.toString());
                }
            }
        };
    }

    private JobChangeAdapter showMessageDialogWhenDone(final ValidationExecutor executor) {
        return new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK() && EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
                    int errors = 0;
                    int warnings = 0;
                    for (ValidationDiagnostic diag : executor.getResults()) {
                        switch (diag.getSeverityLevel()) {
                            case ERROR: {
                                ++errors;
                                break;
                            }
                            case WARNING: {
                                ++warnings;
                                break;
                            }
                        }
                    }
                    String message = errors == 0 && warnings == 0 ? "No errors or warnings." : "Found " + errors + " errors and " + warnings + " warnings." + "\r\r See problems view for further details.";
                    String displayString = "Validation finished !\r\r" + message;
                    Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"AMALTHEA Model Validation", (String)displayString));
                }
            }
        };
    }

    private JobChangeAdapter updateMarkersWhenDone(final ValidationExecutor executor, final List<EObject> objects) {
        return new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK() && EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
                    BasicDiagnostic diagnostics = new BasicDiagnostic();
                    for (ValidationDiagnostic diag : executor.getResults()) {
                        diagnostics.add((Diagnostic)diag);
                    }
                    HashSet<IFile> files = new HashSet<IFile>();
                    for (EObject eObject : objects) {
                        IFile file = AmaltheaEditorUtil.getIFile(eObject);
                        if (file == null) continue;
                        files.add(file);
                    }
                    ValidationMarkerHelper markerHelper = new ValidationMarkerHelper();
                    for (IFile file : files) {
                        markerHelper.deleteMarkers((Object)file);
                    }
                    try {
                        markerHelper.createMarkers((Diagnostic)diagnostics);
                    }
                    catch (CoreException e) {
                        LOGGER.error("Error on updating problem markers", (Throwable)e);
                    }
                }
            }
        };
    }
}

