/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.visualization.util.svg;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SvgUtil {
    private SvgUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String initiallyApplyScale(String svg, int scale) {
        Pattern pattern1 = Pattern.compile("<svg (.*?)>", 32);
        Matcher matcher1 = pattern1.matcher(svg);
        if (matcher1.find()) {
            String svgAttributes = matcher1.group(1);
            String width = SvgUtil.stringBetween(svgAttributes, "width=\"", "\"");
            String height = SvgUtil.stringBetween(svgAttributes, "height=\"", "\"");
            if (width == null || height == null) {
                return svg;
            }
            int newWidthValue = Integer.valueOf(width.replaceAll("[^0-9]", "")) * scale / 100;
            int newHeightValue = Integer.valueOf(height.replaceAll("[^0-9]", "")) * scale / 100;
            String newWidthUnit = width.replaceAll("[0-9.]", "");
            String newHeightUnit = height.replaceAll("[0-9.]", "");
            String newStyle = "style=\"width:" + newWidthValue + newWidthUnit + ";height:" + newHeightValue + newHeightUnit + ";\"";
            String newSvgAttributes = null;
            Pattern pattern2 = Pattern.compile("style=\"(.*?)\"");
            Matcher matcher2 = pattern2.matcher(svgAttributes);
            newSvgAttributes = matcher2.find() ? matcher2.replaceFirst(newStyle) : String.valueOf(svgAttributes) + " " + newStyle;
            return matcher1.replaceFirst("<svg " + newSvgAttributes + ">");
        }
        return svg;
    }

    private static String stringBetween(String str, String left, String right) {
        int start = str.indexOf(left);
        if (start == -1) {
            return null;
        }
        int end = str.indexOf(right, start + left.length());
        if (end == -1) {
            return null;
        }
        return str.substring(start + left.length(), end);
    }

    public static String buildUpdateScaleCommand(int newScale) {
        if (newScale < 10 || newScale > 200) {
            return "";
        }
        return String.format("var svg = document.getElementsByTagName('svg')[0];var w_value = svg.width.baseVal.valueInSpecifiedUnits;var w_unit = svg.width.baseVal.valueAsString.replace(/\\d+/g, '');var h_value = svg.height.baseVal.valueInSpecifiedUnits;var h_unit = svg.height.baseVal.valueAsString.replace(/\\d+/g, '');svg.style.width = (w_value * %d / 100) + w_unit;svg.style.height = (h_value * %d / 100) + h_unit;", newScale, newScale);
    }
}

