/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.javafx;

import javafx.animation.Animation;
import javafx.animation.ParallelTransition;
import javafx.animation.RotateTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.TranslateTransition;
import javafx.embed.swt.FXCanvas;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.util.Duration;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.component.annotations.Component;

@Component(property={"name=SWModel Statistics Visualization", "description=Some simple statistics on the SWModel"})
public class SoftwareModelVisualization
implements Visualization {
    @PostConstruct
    public void createVisualization(SWModel model, Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        FXCanvas canvas = new FXCanvas(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)canvas);
        BorderPane layout = new BorderPane();
        layout.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)}));
        Scene scene = new Scene((Parent)layout);
        canvas.setScene(scene);
        Label output = new Label();
        layout.setCenter((Node)output);
        RotateTransition rotateTransition = new RotateTransition(Duration.seconds((double)1.0), (Node)output);
        rotateTransition.setByAngle(360.0);
        ScaleTransition scaleTransition = new ScaleTransition(Duration.seconds((double)1.0), (Node)output);
        scaleTransition.setFromX(1.0);
        scaleTransition.setFromY(1.0);
        scaleTransition.setToX(4.0);
        scaleTransition.setToY(4.0);
        output.setText("SWModel");
        ParallelTransition parallelTransition = new ParallelTransition(new Animation[]{rotateTransition, scaleTransition});
        parallelTransition.setOnFinished(e -> {
            TranslateTransition trans = new TranslateTransition(Duration.seconds((double)0.5), (Node)output);
            trans.setFromY(output.getBoundsInLocal().getMinY());
            trans.setToY(-1.0 * (scene.getHeight() / 2.0 - output.getHeight()) + 25.0);
            trans.setOnFinished(event -> {
                GridPane grid = new GridPane();
                grid.setHgap(10.0);
                ColumnConstraints leftCol = new ColumnConstraints();
                leftCol.setHgrow(Priority.NEVER);
                ColumnConstraints rightCol = new ColumnConstraints();
                rightCol.setHgrow(Priority.NEVER);
                rightCol.setHalignment(HPos.RIGHT);
                ColumnConstraints spacerCol = new ColumnConstraints();
                spacerCol.setHgrow(Priority.ALWAYS);
                grid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{leftCol, rightCol, spacerCol});
                Font defaultFont = Font.getDefault();
                Font boldFont = Font.font((String)defaultFont.getFamily(), (FontWeight)FontWeight.BOLD, (double)defaultFont.getSize());
                Text headlineText = new Text(output.getText());
                headlineText.setFont(Font.font((String)defaultFont.getFamily(), (double)(defaultFont.getSize() * 4.0)));
                grid.add((Node)headlineText, 0, 0);
                GridPane.setColumnSpan((Node)headlineText, (Integer)3);
                GridPane.setHalignment((Node)headlineText, (HPos)HPos.CENTER);
                GridPane.setValignment((Node)headlineText, (VPos)VPos.CENTER);
                grid.add((Node)new Text(), 0, 1);
                grid.add((Node)new Text(), 1, 1);
                grid.add((Node)new Text(), 2, 1);
                this.addLine(grid, defaultFont, boldFont, "Activations:", model.getActivations().size(), 2);
                this.addLine(grid, defaultFont, boldFont, "Channels:", model.getChannels().size(), 3);
                this.addLine(grid, defaultFont, boldFont, "Custom Entities:", model.getCustomEntities().size(), 4);
                this.addLine(grid, defaultFont, boldFont, "Custom Properties:", model.getCustomProperties().size(), 5);
                this.addLine(grid, defaultFont, boldFont, "Events:", model.getEvents().size(), 6);
                this.addLine(grid, defaultFont, boldFont, "ISRs:", model.getIsrs().size(), 7);
                this.addLine(grid, defaultFont, boldFont, "Labels:", model.getLabels().size(), 8);
                this.addLine(grid, defaultFont, boldFont, "Mode Labels:", model.getModeLabels().size(), 9);
                this.addLine(grid, defaultFont, boldFont, "Modes:", model.getModes().size(), 10);
                this.addLine(grid, defaultFont, boldFont, "Process Chains:", model.getProcessChains().size(), 11);
                this.addLine(grid, defaultFont, boldFont, "Process Prototypes:", model.getProcessPrototypes().size(), 12);
                this.addLine(grid, defaultFont, boldFont, "Runnables:", model.getRunnables().size(), 13);
                this.addLine(grid, defaultFont, boldFont, "Sections:", model.getSections().size(), 14);
                this.addLine(grid, defaultFont, boldFont, "Tasks:", model.getTasks().size(), 15);
                this.addLine(grid, defaultFont, boldFont, "Type Definitions:", model.getTypeDefinitions().size(), 16);
                layout.setCenter((Node)grid);
            });
            trans.play();
        });
        parallelTransition.play();
    }

    private void addLine(GridPane grid, Font defaultFont, Font boldFont, String label, int size, int row) {
        Text activationsText = new Text(label);
        activationsText.setFont(size > 0 ? boldFont : defaultFont);
        grid.add((Node)activationsText, 0, row);
        Text activationsNumber = new Text("" + size);
        activationsNumber.setFont(size > 0 ? boldFont : defaultFont);
        grid.add((Node)activationsNumber, 1, row);
    }

    @PreDestroy
    public void dispose() {
    }
}

