/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util.stimuli;

import java.math.BigInteger;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.util.RuntimeUtil;
import org.eclipse.app4mc.amalthea.model.util.stimuli.IEventModel;
import org.eclipse.emf.common.util.EMap;

public class EMPeriodicRelative
implements IEventModel {
    private Time upperBoundDistance;
    private Time lowerBoundDistance;

    @Override
    public long etaPlus(Time dt) {
        if (dt.getValue().compareTo(BigInteger.ZERO) == 0) {
            return 0L;
        }
        return (long)Math.ceil(dt.divide(this.lowerBoundDistance));
    }

    @Override
    public long etaMinus(Time dt) {
        if (dt.getValue().compareTo(BigInteger.ZERO) == 0) {
            return 0L;
        }
        return (long)Math.floor(dt.divide(this.upperBoundDistance));
    }

    @Override
    public Time deltaPlus(long n) {
        if (n < 2L) {
            return null;
        }
        return this.upperBoundDistance.multiply(n - 1L);
    }

    @Override
    public Time deltaMinus(long n) {
        if (n < 2L) {
            return null;
        }
        return this.lowerBoundDistance.multiply(n - 1L);
    }

    @Override
    public double getUtilization(Process process, RuntimeUtil.TimeType tt, EMap<ModeLabel, String> modes) {
        Time time = RuntimeUtil.getExecutionTimeForProcess(process, modes, tt);
        if (tt.equals((Object)RuntimeUtil.TimeType.BCET)) {
            return time.divide(this.upperBoundDistance);
        }
        if (tt.equals((Object)RuntimeUtil.TimeType.WCET)) {
            return time.divide(this.lowerBoundDistance);
        }
        if (tt.equals((Object)RuntimeUtil.TimeType.ACET)) {
            Time averageDistance = this.lowerBoundDistance.add(this.upperBoundDistance).multiply(0.5);
            return time.divide(averageDistance);
        }
        return -1.0;
    }

    public Time getUpperBoundDistance() {
        return this.upperBoundDistance;
    }

    public void setUpperBoundDistance(Time upperBoundDistance) {
        this.upperBoundDistance = upperBoundDistance;
    }

    public Time getLowerBoundDistance() {
        return this.lowerBoundDistance;
    }

    public void setLowerBoundDistance(Time lowerBoundDistance) {
        this.lowerBoundDistance = lowerBoundDistance;
    }
}

