/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipFile;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.editor.container.AmaltheaModelContainer;
import org.eclipse.app4mc.amalthea.model.io.AmaltheaFileHelper;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class AmaltheaEditorUtil {
    public static final String INVALID = "invalid";
    public static final String MODEL_FILE_EXTENSION = "amxmi";

    private AmaltheaEditorUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static IFile getIFile(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        return AmaltheaEditorUtil.getIFile(eObject.eResource());
    }

    public static IFile getIFile(Resource resource) {
        if (resource == null || resource.getResourceSet() == null) {
            return null;
        }
        URI uri = resource.getURI();
        uri = resource.getResourceSet().getURIConverter().normalize(uri);
        if (uri.segmentCount() < 2 || !"platform".equals(uri.scheme()) || !"resource".equals(uri.segment(0))) {
            return null;
        }
        StringBuilder platformResourcePath = new StringBuilder();
        int j = 1;
        int size = uri.segmentCount();
        while (j < size) {
            platformResourcePath.append('/');
            platformResourcePath.append(uri.segment(j));
            ++j;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
    }

    public static IFile getIFile(IEditorInput editorInput) {
        if (editorInput == null) {
            return null;
        }
        return (IFile)editorInput.getAdapter(IFile.class);
    }

    public static IContainer getIContainer(IEditorInput editorInput) {
        if (editorInput == null) {
            return null;
        }
        IResource iResource = (IResource)editorInput.getAdapter(IResource.class);
        if (iResource == null) {
            return null;
        }
        return iResource.getParent();
    }

    public static AmaltheaModelContainer getModelContainer(IEditorInput editorInput) {
        return AmaltheaEditorUtil.getModelContainer(AmaltheaEditorUtil.getIContainer(editorInput));
    }

    public static AmaltheaModelContainer getModelContainer(IFile iFile) {
        if (iFile == null || !iFile.exists() || iFile.getParent() == null) {
            return null;
        }
        return (AmaltheaModelContainer)iFile.getParent().getAdapter(AmaltheaModelContainer.class);
    }

    public static AmaltheaModelContainer getModelContainer(IContainer container) {
        if (container == null) {
            return null;
        }
        return (AmaltheaModelContainer)container.getAdapter(AmaltheaModelContainer.class);
    }

    public static Resource getResource(IEditorInput editorInput) {
        if (editorInput == null) {
            return null;
        }
        AmaltheaModelContainer container = AmaltheaEditorUtil.getModelContainer(editorInput);
        URI uri = EditUIUtil.getURI((IEditorInput)editorInput);
        if (container == null || container.getResourceSet() == null || uri == null) {
            return null;
        }
        return container.getResourceSet().getResource(uri, false);
    }

    public static Amalthea getModel(IEditorInput editorInput) {
        return AmaltheaEditorUtil.getModel(AmaltheaEditorUtil.getResource(editorInput));
    }

    /*
     * WARNING - void declaration
     */
    public static Amalthea getModel(Resource resource) {
        Amalthea amalthea;
        if (resource == null || resource.getContents().isEmpty()) {
            return null;
        }
        EObject eObject = (EObject)resource.getContents().get(0);
        EObject eObject2 = eObject;
        if (eObject2 instanceof Amalthea) {
            void amalthea2;
            Amalthea amalthea3 = (Amalthea)eObject2;
            Amalthea cfr_ignored_0 = (Amalthea)eObject2;
            amalthea = amalthea2;
        } else {
            amalthea = null;
        }
        return amalthea;
    }

    public static List<Amalthea> getModels(ResourceSet resourceSet) {
        ArrayList<Amalthea> models = new ArrayList<Amalthea>();
        if (resourceSet == null) {
            return models;
        }
        for (Resource resource : resourceSet.getResources()) {
            Amalthea amalthea = AmaltheaEditorUtil.getModel(resource);
            if (amalthea == null) continue;
            models.add(amalthea);
        }
        return models;
    }

    public static List<IFile> getValidModelFiles(IContainer container) {
        IResource[] members;
        ArrayList<IFile> files = new ArrayList<IFile>();
        if (container == null || !container.isAccessible()) {
            return files;
        }
        try {
            members = container.members();
        }
        catch (CoreException coreException) {
            return files;
        }
        return Arrays.stream(members).filter(IFile.class::isInstance).map(IFile.class::cast).filter(AmaltheaEditorUtil::hasModelExtension).filter(AmaltheaEditorUtil::isNamespaceValid).toList();
    }

    public static File getLocalFile(IResource resource) {
        IPath location;
        if (resource instanceof IFile && resource.exists() && (location = resource.getLocation()) != null) {
            return location.toFile();
        }
        return null;
    }

    public static boolean isLocalFile(IResource resource) {
        return resource instanceof IFile && resource.exists() && resource.getLocation() != null;
    }

    public static boolean hasModelExtension(IResource resource) {
        return resource instanceof IFile && MODEL_FILE_EXTENSION.equals(resource.getFileExtension());
    }

    public static boolean isRegularFile(IFile iFile) {
        return AmaltheaEditorUtil.isLocalFile((IResource)iFile) && !AmaltheaEditorUtil.isZipFile(AmaltheaEditorUtil.getLocalFile((IResource)iFile));
    }

    public static boolean isZipFile(IFile iFile) {
        return AmaltheaEditorUtil.isLocalFile((IResource)iFile) && AmaltheaEditorUtil.isZipFile(AmaltheaEditorUtil.getLocalFile((IResource)iFile));
    }

    private static boolean isZipFile(File file) {
        boolean result = false;
        if (file != null) {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (ZipFile f = new ZipFile(file);){
                    result = true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public static boolean isNamespaceValid(IFile iFile) {
        return AmaltheaEditorUtil.isLocalFile((IResource)iFile) && AmaltheaFileHelper.isNamespaceValid((File)AmaltheaEditorUtil.getLocalFile((IResource)iFile));
    }

    public static String getModelVersion(IFile iFile) {
        if (AmaltheaEditorUtil.isLocalFile((IResource)iFile)) {
            return AmaltheaFileHelper.getModelVersion((File)AmaltheaEditorUtil.getLocalFile((IResource)iFile));
        }
        return INVALID;
    }

    /*
     * WARNING - void declaration
     */
    public static IEditorInput getIEditorInput(EObject eObject) {
        if (eObject == null || eObject.eResource() == null || eObject.eResource().getURI() == null) {
            return null;
        }
        URI uri = eObject.eResource().getURI();
        if (uri.isPlatformResource()) {
            String path = uri.toPlatformString(true);
            IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
            IResource iResource = workspaceResource;
            if (iResource instanceof IFile) {
                void iFile;
                IFile iFile2 = (IFile)iResource;
                IFile cfr_ignored_0 = (IFile)iResource;
                return new FileEditorInput((IFile)iFile);
            }
        }
        return new URIEditorInput(uri);
    }

    public static boolean isInUse(IFile iFile) {
        AmaltheaModelContainer amContainer = AmaltheaEditorUtil.getModelContainer(iFile);
        return amContainer != null && amContainer.getInitialModelFiles().contains(iFile);
    }

    public static boolean isInUse(IContainer iContainer) {
        AmaltheaModelContainer modelContainer = AmaltheaEditorUtil.getModelContainer(iContainer);
        return modelContainer != null && modelContainer.isInUse();
    }
}

