/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.swt;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.ITaggable;
import org.eclipse.app4mc.amalthea.model.Tag;
import org.eclipse.app4mc.amalthea.model.provider.AmaltheaDefaultLabelProvider;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.osgi.service.component.annotations.Component;

@Component(property={"name=Tag Member Table", "description=Shows list of tagged objects"})
public class TagMemberVisualization
implements Visualization {
    @PostConstruct
    public void createVisualization(List<Tag> tags, Composite parent, IEventBroker broker) {
        Composite pane = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(pane);
        Label title = new Label(pane, 0);
        title.setLayoutData((Object)new GridData(768));
        title.setText("\nObjects tagged with " + this.label(tags));
        TableViewer tableViewer = new TableViewer(pane, 2568);
        tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        tableViewer.setLabelProvider((IBaseLabelProvider)new AmaltheaDefaultLabelProvider(){

            public String getText(Object element) {
                return TagMemberVisualization.this.name(element);
            }
        });
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setInput(this.taggedObjects(tags));
        tableViewer.setComparator(new ViewerComparator());
        tableViewer.addDoubleClickListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof ITaggable) {
                HashMap<String, List<Object>> data = new HashMap<String, List<Object>>();
                data.put("modelElements", List.of(firstElement));
                broker.send("org/eclipse/app4mc/amalthea/editor/SELECT", data);
            }
        });
    }

    private String label(List<Tag> tags) {
        return tags.stream().map(t -> "\"" + t.getQualifiedName() + "\"").sorted().collect(Collectors.joining(" OR "));
    }

    private List<ITaggable> taggedObjects(List<Tag> tags) {
        return tags.stream().flatMap(t -> t.getTaggedObjects().stream()).toList();
    }

    /*
     * WARNING - void declaration
     */
    private String name(Object object) {
        Object object2 = object;
        if (object2 instanceof INamed) {
            void namedObject;
            INamed iNamed = (INamed)object2;
            INamed cfr_ignored_0 = (INamed)object2;
            String name = namedObject.getName();
            return name == null || name.isEmpty() ? "?" : name;
        }
        return "<undefined>";
    }
}

