/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.emitter;

import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.layout.emitter.PageDeviceRender;
import org.eclipse.birt.report.engine.nLayout.area.ITextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.PageArea;

public abstract class PageEmitter
extends ContentEmitterAdapter {
    protected static Logger logger = Logger.getLogger(PageEmitter.class.getName());
    protected PageDeviceRender render;

    public abstract PageDeviceRender createRender(IEmitterServices var1) throws EngineException;

    @Override
    public String getOutputFormat() {
        return this.render.getOutputFormat();
    }

    @Override
    public void initialize(IEmitterServices service) throws EngineException {
        this.render = this.createRender(service);
    }

    @Override
    public void startPage(IPageContent page) {
        PageArea pageArea = (PageArea)page.getExtension(1);
        if (pageArea != null) {
            pageArea.accept(this.render);
        }
    }

    @Override
    public void start(IReportContent report) {
        this.render.start(report);
    }

    @Override
    public void end(IReportContent report) {
        this.render.end(report);
    }

    @Override
    public void startAutoText(IAutoTextContent autoText) {
        ITextArea totalPage = (ITextArea)autoText.getExtension(1);
        this.render.setTotalPage(totalPage);
    }
}

