/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb;

import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.BreadcrumbItemDetails;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.BreadcrumbItemDropDown;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.BreadcrumbViewer;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.IBreadcrumbLabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class BreadcrumbItem
extends Item {
    private IBreadcrumbLabelProvider fLabelProvider;
    private ITreeContentProvider fContentProvider;
    private final BreadcrumbViewer fParent;
    private Composite fContainer;
    private BreadcrumbItemDetails fDetailsBlock;
    private BreadcrumbItemDropDown fExpandBlock;
    private boolean fIsLast;

    public BreadcrumbItem(BreadcrumbViewer viewer, Composite parent) {
        super((Widget)parent, 0);
        this.fParent = viewer;
        this.fContainer = new Composite(parent, 0);
        this.fContainer.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        this.fContainer.setLayout((Layout)layout);
        this.fDetailsBlock = new BreadcrumbItemDetails(this, this.fContainer);
        this.fExpandBlock = new BreadcrumbItemDropDown(this, this.fContainer);
    }

    public BreadcrumbViewer getViewer() {
        return this.fParent;
    }

    public void setContentProvider(ITreeContentProvider contentProvider) {
        this.fContentProvider = contentProvider;
    }

    public void setLabelProvider(IBreadcrumbLabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
    }

    public void dispose() {
        this.fContainer.dispose();
        super.dispose();
    }

    void setShowText(boolean enabled) {
        this.fDetailsBlock.setTextVisible(enabled);
    }

    boolean isShowText() {
        return this.fDetailsBlock.isTextVisible();
    }

    int getWidth() {
        return this.fDetailsBlock.getWidth() + this.fExpandBlock.getWidth() + 2;
    }

    void setSelected(boolean selected) {
        this.fDetailsBlock.setSelected(selected);
    }

    void refresh() {
        if (this.getData() != null) {
            String text = this.fLabelProvider.getText(this.getData());
            Image image = this.fLabelProvider.getImage(this.getData());
            String toolTip = this.fLabelProvider.getTooltipText(this.getData());
            this.fDetailsBlock.setText(text);
            this.fDetailsBlock.setImage(image);
            this.fDetailsBlock.setToolTip(toolTip);
        }
        this.refreshArrow();
    }

    void refreshArrow() {
        this.fExpandBlock.setEnabled(this.fContentProvider.hasChildren(this.getData()));
    }

    void setIsLastItem(boolean isLast) {
        this.fIsLast = isLast;
        GridData data = (GridData)this.fContainer.getLayoutData();
        data.grabExcessHorizontalSpace = isLast;
    }

    void setDetailsVisible(boolean visible) {
        this.fDetailsBlock.setVisible(visible);
    }

    void openDropDownMenu() {
        this.fExpandBlock.showMenu();
    }

    boolean isMenuShown() {
        return this.fExpandBlock.isMenuShown();
    }

    Shell getDropDownShell() {
        return this.fExpandBlock.getDropDownShell();
    }

    ISelectionProvider getDropDownSelectionProvider() {
        return this.fExpandBlock.getDropDownSelectionProvider();
    }

    public Rectangle getBounds() {
        return this.fContainer.getBounds();
    }

    public void setText(String string) {
        super.setText(string);
        this.fDetailsBlock.setText(string);
        if (this.fIsLast) {
            this.fContainer.layout(true, true);
        }
    }

    public void setImage(Image image) {
        super.setImage(image);
        this.fDetailsBlock.setImage(image);
    }
}

