/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseWizardDialog;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.internal.ui.wizards.PublishTemplateWizard;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.jface.wizard.IWizard;

public class PublishTemplateViewAction
extends AbstractViewAction {
    private static String DISPLAY_TEXT = Messages.getString((String)"PublishTemplateViewAction.action.displaytext");
    private static String TEMPLATE_SUFFIX = Messages.getString((String)"DefaultNodeProvider.template.suffix");

    public PublishTemplateViewAction(Object selectedObject) {
        super(selectedObject, DISPLAY_TEXT);
    }

    public PublishTemplateViewAction(Object selectedObject, String text) {
        super(selectedObject, text);
    }

    public boolean isEnabled() {
        Object object = this.getSelection();
        if (object == null || !(object instanceof ReportDesignHandle)) {
            return false;
        }
        ReportDesignHandle report = (ReportDesignHandle)object;
        return report.getModuleHandle().getFileName().endsWith(TEMPLATE_SUFFIX) || ReportPlugin.getDefault().isReportDesignFile(report.getModuleHandle().getFileName());
    }

    public void run() {
        BaseWizardDialog dialog = new BaseWizardDialog(UIUtil.getDefaultShell(), (IWizard)new PublishTemplateWizard((ReportDesignHandle)this.getSelection()));
        dialog.setPageSize(500, 250);
        dialog.open();
    }
}

