/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.AreaStyle;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.w3c.dom.css.CSSValue;
import uk.co.spudsoft.birt.emitters.excel.BirtStyle;
import uk.co.spudsoft.birt.emitters.excel.FontManager;
import uk.co.spudsoft.birt.emitters.excel.StyleManagerUtils;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;

public class StyleManagerXUtils
extends StyleManagerUtils {
    private static StyleManagerUtils.Factory factory = new StyleManagerUtils.Factory(){

        @Override
        public StyleManagerUtils create(Logger log) {
            return new StyleManagerXUtils(log);
        }
    };

    public static StyleManagerUtils.Factory getFactory() {
        return factory;
    }

    public StyleManagerXUtils(Logger log) {
        super(log);
    }

    @Override
    public RichTextString createRichTextString(String value) {
        XSSFRichTextString result = new XSSFRichTextString(value);
        return result;
    }

    private BorderStyle poiBorderStyleFromBirt(String birtBorder, String width) {
        if ("none".equals(birtBorder)) {
            return BorderStyle.NONE;
        }
        double pxWidth = 3.0;
        if ("thin".equals(width)) {
            pxWidth = 1.0;
        } else if ("medium".equals(width)) {
            pxWidth = 3.0;
        } else if ("thick".equals(width)) {
            pxWidth = 4.0;
        } else {
            DimensionType dim = DimensionType.parserUnit((String)width);
            if (dim != null && "px".equals(dim.getUnits())) {
                pxWidth = dim.getMeasure();
            }
        }
        if ("solid".equals(birtBorder)) {
            if (pxWidth < 2.9) {
                return BorderStyle.THIN;
            }
            if (pxWidth < 3.1) {
                return BorderStyle.MEDIUM;
            }
            return BorderStyle.THICK;
        }
        if ("dashed".equals(birtBorder)) {
            if (pxWidth < 2.9) {
                return BorderStyle.DASHED;
            }
            return BorderStyle.MEDIUM_DASHED;
        }
        if ("dotted".equals(birtBorder)) {
            return BorderStyle.DOTTED;
        }
        if ("double".equals(birtBorder)) {
            return BorderStyle.DOUBLE;
        }
        this.log.debug("Border style \"", birtBorder, "\" is not recognised.");
        return BorderStyle.NONE;
    }

    @Override
    public void applyBorderStyle(Workbook workbook, CellStyle style, XSSFCellBorder.BorderSide side, CSSValue colour, CSSValue borderStyle, CSSValue width) {
        if (colour != null || borderStyle != null || width != null) {
            String widthString;
            String colourString = colour == null ? "rgb(0,0,0)" : colour.getCssText();
            String borderStyleString = borderStyle == null ? "solid" : borderStyle.getCssText();
            String string = widthString = width == null ? "medium" : width.getCssText();
            if (style instanceof XSSFCellStyle) {
                XSSFCellStyle xStyle = (XSSFCellStyle)style;
                BorderStyle xBorderStyle = this.poiBorderStyleFromBirt(borderStyleString, widthString);
                XSSFColor xBorderColour = this.getXColour(colourString);
                if (xBorderStyle != BorderStyle.NONE) {
                    switch (side) {
                        case TOP: {
                            xStyle.setBorderTop(xBorderStyle);
                            xStyle.setTopBorderColor(xBorderColour);
                            break;
                        }
                        case LEFT: {
                            xStyle.setBorderLeft(xBorderStyle);
                            xStyle.setLeftBorderColor(xBorderColour);
                            break;
                        }
                        case RIGHT: {
                            xStyle.setBorderRight(xBorderStyle);
                            xStyle.setRightBorderColor(xBorderColour);
                            break;
                        }
                        case BOTTOM: {
                            xStyle.setBorderBottom(xBorderStyle);
                            xStyle.setBottomBorderColor(xBorderColour);
                        }
                    }
                }
            }
        }
    }

    private XSSFColor getXColour(String colour) {
        int[] rgbInt = ColorUtil.getRGBs((String)colour);
        if (rgbInt == null) {
            return null;
        }
        byte[] rgbByte = new byte[]{-1, (byte)rgbInt[0], (byte)rgbInt[1], (byte)rgbInt[2]};
        DefaultIndexedColorMap colorMap = new DefaultIndexedColorMap();
        XSSFColor result = new XSSFColor(rgbByte, (IndexedColorMap)colorMap);
        return result;
    }

    @Override
    public void addColourToFont(Workbook workbook, Font font, String colour) {
        if (colour == null || IStyle.TRANSPARENT_VALUE.equals(colour)) {
            return;
        }
        if (font instanceof XSSFFont) {
            XSSFFont xFont = (XSSFFont)font;
            XSSFColor xColour = this.getXColour(colour);
            if (xColour != null) {
                xFont.setColor(xColour);
            }
        }
    }

    @Override
    public void addBackgroundColourToStyle(Workbook workbook, CellStyle style, String colour) {
        if (colour == null || IStyle.TRANSPARENT_VALUE.equals(colour)) {
            return;
        }
        if (style instanceof XSSFCellStyle) {
            XSSFCellStyle cellStyle = (XSSFCellStyle)style;
            XSSFColor xColour = this.getXColour(colour);
            if (xColour != null) {
                cellStyle.setFillForegroundColor(xColour);
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
        }
    }

    @Override
    public Font correctFontColorIfBackground(FontManager fm, Workbook wb, BirtStyle birtStyle, Font font) {
        CSSValue bgColour = birtStyle.getProperty(8);
        int[] bgRgb = this.parseColour(bgColour == null ? null : bgColour.getCssText(), "white");
        XSSFColor colour = ((XSSFFont)font).getXSSFColor();
        int[] fgRgb = this.rgbOnly(colour.getARGB());
        if (fgRgb[0] == 255 && fgRgb[1] == 255 && fgRgb[2] == 255) {
            fgRgb[2] = 0;
            fgRgb[1] = 0;
            fgRgb[0] = 0;
        } else if (fgRgb[0] == 0 && fgRgb[1] == 0 && fgRgb[2] == 0) {
            fgRgb[2] = 255;
            fgRgb[1] = 255;
            fgRgb[0] = 255;
        }
        if (bgRgb[0] == fgRgb[0] && bgRgb[1] == fgRgb[1] && bgRgb[2] == fgRgb[2]) {
            AreaStyle addedStyle = new AreaStyle(fm.getCssEngine());
            addedStyle.setColor(this.contrastColour(bgRgb));
            return fm.getFontWithExtraStyle(font, (IStyle)addedStyle);
        }
        return font;
    }

    @Override
    public int anchorDxFromMM(double widthMM, double colWidthMM) {
        return (int)(widthMM * 36000.0);
    }

    @Override
    public int anchorDyFromPoints(float height, float rowHeight) {
        return (int)(height * 12700.0f);
    }

    @Override
    public void prepareMarginDimensions(Sheet sheet, IPageContent page) {
        double headerHeight = 0.5;
        double footerHeight = 0.5;
        if (page.getHeaderHeight() != null && this.isAbsolute(page.getHeaderHeight())) {
            headerHeight = page.getHeaderHeight().convertTo("in");
            sheet.setMargin((short)4, headerHeight);
        }
        if (page.getFooterHeight() != null && this.isAbsolute(page.getFooterHeight())) {
            footerHeight = page.getFooterHeight().convertTo("in");
            sheet.setMargin((short)5, footerHeight);
        }
        if (page.getMarginBottom() != null && this.isAbsolute(page.getMarginBottom())) {
            sheet.setMargin((short)3, footerHeight + page.getMarginBottom().convertTo("in"));
        }
        if (page.getMarginLeft() != null && this.isAbsolute(page.getMarginLeft())) {
            sheet.setMargin((short)0, page.getMarginLeft().convertTo("in"));
        }
        if (page.getMarginRight() != null && this.isAbsolute(page.getMarginRight())) {
            sheet.setMargin((short)1, page.getMarginRight().convertTo("in"));
        }
        if (page.getMarginTop() != null && this.isAbsolute(page.getMarginTop())) {
            sheet.setMargin((short)2, headerHeight + page.getMarginTop().convertTo("in"));
        }
    }
}

