/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.ddl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.enablement.ibm.catalog.IDatabaseObject;
import org.eclipse.datatools.enablement.ibm.catalog.util.CatalogStatistics;
import org.eclipse.datatools.enablement.ibm.db2.ddl.DB2DdlBuilder;
import org.eclipse.datatools.enablement.ibm.db2.luw.ddl.ILUWModuleDdlBuilder;
import org.eclipse.datatools.enablement.ibm.db2.luw.ddl.LUWDdlGenerator;
import org.eclipse.datatools.enablement.ibm.db2.luw.ddl.LUWDdlMessages;
import org.eclipse.datatools.enablement.ibm.db2.luw.ddl.LUWDeltaDdlGenerator;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.BufferPoolType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.FederatedProcedure;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWArrayDataType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWAttributeDefinition;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWBufferPool;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWBufferPoolSizeException;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWColumn;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWContainerType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWCursorDataType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabaseContainer;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabasePackage;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabasePartition;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWGlobalVariable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWIndex;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWMaterializedQueryTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModule;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModuleArrayDataType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModuleCondition;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModuleCursorDataType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModuleDistinctType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModuleGlobalVariable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModuleObject;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWModuleRowDataType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWNickname;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPackage;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPartitionGroup;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPartitionKey;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWRowDataType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWServer;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWStorageTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWTableSpace;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWUserMapping;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWView;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWWrapper;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.ManagementType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.PLSQLPackage;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.PLSQLPackageBody;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.PageSizeType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.PartitionMethod;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.TableSpaceType;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Alias;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2IdentitySpecifier;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Index;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2IndexType;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Package;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Procedure;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2UserDefinedFunction;
import org.eclipse.datatools.enablement.ibm.db2.model.GenerateType;
import org.eclipse.datatools.enablement.ibm.db2.model.UnitType;
import org.eclipse.datatools.enablement.ibm.ddl.DdlGenerationUtility;
import org.eclipse.datatools.enablement.ibm.ddl.ExtendDdlBuilder;
import org.eclipse.datatools.enablement.ibm.util.EngineeringOptionID;
import org.eclipse.datatools.enablement.ibm.util.ModelHelper;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Group;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Role;
import org.eclipse.datatools.modelbase.sql.accesscontrol.RoleAuthorization;
import org.eclipse.datatools.modelbase.sql.accesscontrol.User;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.ReferenceConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.BinaryStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DateDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.Field;
import org.eclipse.datatools.modelbase.sql.datatypes.PrimitiveType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataTypesPackage;
import org.eclipse.datatools.modelbase.sql.datatypes.StructuredUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.TimeDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.expressions.QueryExpression;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpression;
import org.eclipse.datatools.modelbase.sql.routines.Function;
import org.eclipse.datatools.modelbase.sql.routines.Method;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.ReferentialActionType;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;
import org.eclipse.datatools.modelbase.sql.schema.TypedElement;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.CheckType;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWDdlBuilder
extends DB2DdlBuilder {
    protected static final String OPTIMIZATION = "OPTIMIZATION";
    protected static final String QUERY = "QUERY";
    protected static final String ENABLE = "ENABLE";
    protected static final String ENFORCED = "ENFORCED";
    protected static final String XSROBJECT = "XSROBJECT";
    protected static final String PARTITION_KEY = "PARTITIONING KEY";
    protected static final String PARTITION_GROUP = "PARTITION GROUP";
    protected static final String BUFFER_POOL = "BUFFER POOL";
    protected static final String UNDER = "UNDER";
    protected static final String RESTRICT = "RESTRICT";
    protected static final String DIMENSION_BY = "ORGANIZE BY DIMENSIONS";
    protected static final String VALUE_COMPRESSION = "VALUE COMPRESSION";
    protected static final String USE_HASH = "USING HASHING";
    protected static final String INTEGRITY = "INTEGRITY";
    protected static final String ADMIN_CMD = "SYSPROC.ADMIN_CMD";
    protected static final String REORG = "REORG";
    protected static final String CALL = "CALL";
    protected static final String VARIABLE = "VARIABLE";
    protected static final String CONSTANT = "CONSTANT";
    protected static final String ARRAY = "ARRAY";
    protected static final String CURSOR = "CURSOR";
    protected static final String MODULE = "MODULE";
    protected static final String OFF = "OFF";
    protected static final String NOT_LOGGED = " NOT LOGGED";
    protected static final String IBM = "IBM";
    protected static final String SYS = "SYS";
    protected static final String HEX_LITERAL_PREFIX = "X";
    protected static final int GB = 0x40000000;
    protected static final String FILE = "FILE";
    protected static final String DEVICE = "DEVICE";
    protected static final String BUFFERPOOL = "BUFFERPOOL";
    protected static final String OVERHEAD = "OVERHEAD";
    protected static final String XFER_RATE = "TRANSFERRATE";
    protected static final String DROPPED_TABLE_RECOVERY = "DROPPED TABLE RECOVERY";
    protected static final String AUTORESIZE = "AUTORESIZE";
    protected static final String MAXSIZE = "MAXSIZE";
    protected static final String PERCENT = "PERCENT";
    protected static final String INCREASESIZE = "INCREASESIZE";
    protected static final String NONE = "NONE";
    protected static final String AUTOMATIC = "AUTOMATIC";
    protected static final String PREFETCHSIZE = "PREFETCHSIZE";
    protected static final String XFER_OWNERSHIP = "TRANSFER OWNERSHIP OF";
    protected static final String PRESERVE_PRIVILEGES = "PRESERVE PRIVILEGES";
    protected static final String RESIZE = "RESIZE";
    private LUWDdlGenerator generator;

    public LUWDdlBuilder() {
    }

    public LUWDdlBuilder(LUWDdlGenerator generator) {
        this.generator = generator;
    }

    public String createSchema(Schema schema, boolean quoteIdentifiers, boolean qualifyNames) {
        String text = "CREATE SCHEMA " + this.getName(schema, quoteIdentifiers, qualifyNames);
        AuthorizationIdentifier auth = schema.getOwner();
        if (auth != null) {
            text = String.valueOf(text) + " AUTHORIZATION " + this.getName(auth, quoteIdentifiers);
        }
        return text;
    }

    public String createTablespace(LUWTableSpace tablespace, boolean quoteIdentifiers) {
        Double overhead;
        LUWBufferPool bufferpool;
        int prefetchsize;
        int extentsize;
        if (tablespace.getContainers().isEmpty() && this.isTablespaceContainersRequried(tablespace)) {
            this.getEngineeringCallBack().writeMessage(MessageFormat.format(LUWDdlMessages.FE_TABLESPACE_NO_CONTAINER, tablespace.getName()));
            return null;
        }
        String tablespaceName = tablespace.getName();
        if (quoteIdentifiers) {
            tablespaceName = this.getDoubleQuotedString(tablespaceName);
        }
        String text = "CREATE ";
        TableSpaceType type = tablespace.getTablespaceType();
        if (type == TableSpaceType.REGULAR_LITERAL) {
            text = String.valueOf(text) + "REGULAR";
        } else if (type == TableSpaceType.USER_TEMP_LITERAL) {
            text = String.valueOf(text) + "USER TEMPORARY";
        } else if (type == TableSpaceType.SYSTEM_TEMP_LITERAL) {
            text = String.valueOf(text) + "SYSTEM TEMPORARY";
        } else if (type == TableSpaceType.LARGE_LITERAL) {
            text = String.valueOf(text) + "LARGE";
        }
        text = String.valueOf(text) + " TABLESPACE " + tablespaceName;
        LUWPartitionGroup pg = tablespace.getGroup();
        if (pg != null) {
            String pgName = pg.getName();
            if (quoteIdentifiers) {
                pgName = this.getDoubleQuotedString(pgName);
            }
            text = String.valueOf(text) + NEWLINE + "\t" + "IN" + " " + "DATABASE" + " " + PARTITION_GROUP + " " + pgName;
        }
        text = String.valueOf(text) + NEWLINE + "\t" + "PAGESIZE ";
        PageSizeType pageSize = null;
        pageSize = tablespace.getBufferPool() != null ? tablespace.getBufferPool().getPageSize() : tablespace.getPageSize();
        if (pageSize == PageSizeType.FOUR_K_LITERAL) {
            text = String.valueOf(text) + "4 K";
        } else if (pageSize == PageSizeType.EIGHT_K_LITERAL) {
            text = String.valueOf(text) + "8 K";
        } else if (pageSize == PageSizeType.SIXTEEN_K_LITERAL) {
            text = String.valueOf(text) + "16 K";
        } else if (pageSize == PageSizeType.THIRTY_TWO_K_LITERAL) {
            text = String.valueOf(text) + "32 K";
        } else if (pageSize == PageSizeType.FOUR_KB_LITERAL) {
            text = String.valueOf(text) + "4096";
        } else if (pageSize == PageSizeType.EIGHT_KB_LITERAL) {
            text = String.valueOf(text) + "8192";
        } else if (pageSize == PageSizeType.SIXTEEN_KB_LITERAL) {
            text = String.valueOf(text) + "16384";
        } else if (pageSize == PageSizeType.THIRTY_TWO_KB_LITERAL) {
            text = String.valueOf(text) + "32768";
        }
        text = String.valueOf(text) + NEWLINE + "\t" + "MANAGED BY ";
        if (tablespace.getManagementType() == ManagementType.DATABASE_MANAGED_LITERAL) {
            text = String.valueOf(text) + "DATABASE";
            if (this.hasContainers(tablespace)) {
                text = String.valueOf(text) + this.getContainers(tablespace);
            }
        } else if (tablespace.getManagementType() == ManagementType.SYSTEM_MANAGED_LITERAL) {
            text = String.valueOf(text) + "SYSTEM";
            if (this.hasContainers(tablespace)) {
                text = String.valueOf(text) + this.getContainers(tablespace);
            }
        } else {
            text = String.valueOf(text) + "AUTOMATIC STORAGE";
        }
        if (tablespace.getManagementType() != ManagementType.SYSTEM_MANAGED_LITERAL) {
            long initsize = tablespace.getInitialSize();
            UnitType initunit = tablespace.getInitialSizeUnit();
            long incrsize = tablespace.getIncreaseSize();
            UnitType incrunit = tablespace.getIncreaseSizeUnit();
            int incrpct = tablespace.getIncreasePercent();
            long maxsize = tablespace.getMaximumSize();
            UnitType maxunit = tablespace.getMaximumSizeUnit();
            if (initsize != 0L || incrsize != 0L || incrpct != 0 || maxsize != 0L) {
                text = String.valueOf(text) + NEWLINE + "AUTORESIZE YES";
            }
            if (tablespace.getManagementType() == ManagementType.AUTOMATIC_STORAGE_LITERAL && initsize != 0L) {
                text = String.valueOf(text) + NEWLINE + "INITIALSIZE " + initsize;
                if (initunit != null) {
                    text = String.valueOf(text) + " " + initunit.getLiteral();
                }
            }
            if (incrsize != 0L) {
                text = String.valueOf(text) + NEWLINE + "INCREASESIZE " + incrsize;
                if (incrunit != null) {
                    text = String.valueOf(text) + " " + incrunit.getLiteral();
                }
            } else if (incrpct != 0) {
                text = String.valueOf(text) + NEWLINE + "INCREASESIZE " + incrpct + " PERCENT";
            }
            if (maxsize != 0L) {
                text = String.valueOf(text) + NEWLINE + "MAXSIZE " + maxsize;
                if (maxunit != null) {
                    text = String.valueOf(text) + " " + maxunit.getLiteral();
                }
            }
        }
        if ((extentsize = tablespace.getExtentSize()) > 0) {
            text = String.valueOf(text) + NEWLINE + "\t" + "EXTENTSIZE " + extentsize;
        }
        if ((prefetchsize = tablespace.getPreFetchSize()) > 0) {
            text = String.valueOf(text) + NEWLINE + "\t" + "PREFETCHSIZE " + prefetchsize;
        }
        if ((bufferpool = tablespace.getBufferPool()) != null) {
            String bufferpoolName = bufferpool.getName();
            if (quoteIdentifiers) {
                bufferpoolName = this.getDoubleQuotedString(bufferpoolName);
            }
            text = String.valueOf(text) + NEWLINE + "\t" + "BUFFERPOOL " + bufferpoolName;
        }
        if ((overhead = Double.valueOf(tablespace.getOverhead())) > 0.0) {
            text = String.valueOf(text) + NEWLINE + "\t" + "OVERHEAD " + overhead;
        }
        if (tablespace.getTransferRate() > 0.0) {
            text = String.valueOf(text) + NEWLINE + "\t" + "TRANSFERRATE " + tablespace.getTransferRate();
        }
        text = String.valueOf(text) + this.RecoverDroppedTableString(tablespace);
        return text;
    }

    public String dropTablespace(LUWTableSpace tablespace, boolean quoteIdentifiers) {
        String tablespaceName = tablespace.getName();
        if (quoteIdentifiers) {
            tablespaceName = this.getDoubleQuotedString(tablespaceName);
        }
        return "DROP TABLESPACE " + tablespaceName;
    }

    public String createBufferPool(LUWBufferPool bufferpool, boolean quoteIdentifiers) {
        int blocksize;
        EList pgs;
        String bufferpoolName = bufferpool.getName();
        if (quoteIdentifiers) {
            bufferpoolName = this.getDoubleQuotedString(bufferpoolName);
        }
        String text = "CREATE BUFFERPOOL " + bufferpoolName;
        if (bufferpool.getCreateType() == BufferPoolType.DEFERRED_LITERAL) {
            text = String.valueOf(text) + "\tDEFERRED";
        }
        if ((pgs = bufferpool.getPartitionGroup()).isEmpty()) {
            text = String.valueOf(text) + NEWLINE + "\t" + "ALL DBPARTITIONNUMS ";
        } else {
            StringBuilder pgtext = new StringBuilder();
            for (Object pgobj : pgs) {
                LUWPartitionGroup pg = (LUWPartitionGroup)pgobj;
                if (pgtext.length() > 0) {
                    pgtext.append(", ");
                }
                pgtext.append(pg.getName());
            }
            text = String.valueOf(text) + NEWLINE + "\t" + "DATABASE PARTITION GROUP " + pgtext.toString();
        }
        String sizeStr = this.getBufferPoolSize(bufferpool);
        if (sizeStr == null) {
            return null;
        }
        text = String.valueOf(text) + sizeStr;
        int numBlockPages = bufferpool.getNumBlockPages();
        text = String.valueOf(text) + NEWLINE + "\t" + "NUMBLOCKPAGES " + bufferpool.getNumBlockPages();
        if (numBlockPages > 0 && (blocksize = bufferpool.getBlockSize()) > 1) {
            text = String.valueOf(text) + " BLOCKSIZE " + blocksize;
        }
        text = String.valueOf(text) + NEWLINE + "\t" + "PAGESIZE ";
        PageSizeType pageSize = bufferpool.getPageSize();
        if (pageSize == PageSizeType.FOUR_K_LITERAL) {
            text = String.valueOf(text) + "4 K";
        } else if (pageSize == PageSizeType.EIGHT_K_LITERAL) {
            text = String.valueOf(text) + "8 K";
        } else if (pageSize == PageSizeType.SIXTEEN_K_LITERAL) {
            text = String.valueOf(text) + "16 K";
        } else if (pageSize == PageSizeType.THIRTY_TWO_K_LITERAL) {
            text = String.valueOf(text) + "32 K";
        }
        EList sizeexeptions = bufferpool.getSizeException();
        if (!sizeexeptions.isEmpty()) {
            StringBuilder parttext = new StringBuilder(String.valueOf(NEWLINE) + "EXCEPT ON DBPARTITIONNUMS (");
            boolean first = true;
            for (Object o : sizeexeptions) {
                LUWBufferPoolSizeException sizeex = (LUWBufferPoolSizeException)o;
                String size = " SIZE " + sizeex.getSize();
                EList partns = sizeex.getPartitions();
                for (Object partobj : partns) {
                    LUWDatabasePartition part = (LUWDatabasePartition)partobj;
                    if (!first) {
                        parttext.append(", ");
                    } else {
                        first = false;
                    }
                    parttext.append(part.getNumber());
                    parttext.append(size);
                }
            }
            parttext.append(")");
            text = String.valueOf(text) + parttext.toString();
        }
        if (bufferpool.isExtendedStorage() && this.supportsBufferpoolExtendedStorage()) {
            text = String.valueOf(text) + NEWLINE + "EXTENDED STORAGE";
        }
        return text;
    }

    protected boolean supportsBufferpoolExtendedStorage() {
        return true;
    }

    public String dropBufferPool(LUWBufferPool bufferpool, boolean quoteIdentifiers) {
        String bufferpoolName = bufferpool.getName();
        if (quoteIdentifiers) {
            bufferpoolName = this.getDoubleQuotedString(bufferpoolName);
        }
        return "DROP BUFFERPOOL " + bufferpoolName;
    }

    public String createSequence(Sequence sequence, boolean quoteIdentifiers, boolean qualifyNames) {
        String sequenceName = sequence.getName();
        String schemaName = sequence.getSchema().getName();
        if (quoteIdentifiers) {
            sequenceName = this.getDoubleQuotedString(sequenceName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            sequenceName = String.valueOf(schemaName) + "." + sequenceName;
        }
        String statement = "CREATE SEQUENCE " + sequenceName + " AS ";
        String dataType = this.getDataTypeString((TypedElement)sequence, sequence.getSchema(), quoteIdentifiers, qualifyNames);
        if (dataType == null) {
            this.getEngineeringCallBack().writeMessage(MessageFormat.format(LUWDdlMessages.FE_TABLESPACE_NO_CONTAINER, sequenceName));
            return null;
        }
        statement = String.valueOf(statement) + dataType;
        DB2IdentitySpecifier identity = (DB2IdentitySpecifier)sequence.getIdentity();
        statement = String.valueOf(statement) + " " + this.getIdentityString(identity);
        return statement;
    }

    public String createMQT(LUWMaterializedQueryTable table, boolean quoteIdentifiers, boolean qualifyNames) {
        String tableName = table.getName();
        String schemaName = table.getSchema().getName();
        if (quoteIdentifiers) {
            tableName = this.getDoubleQuotedString(tableName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            tableName = String.valueOf(schemaName) + "." + tableName;
        }
        String statement = "CREATE TABLE " + tableName + " (";
        Iterator it = table.getColumns().iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            statement = String.valueOf(statement) + column.getName();
            if (!it.hasNext()) continue;
            statement = String.valueOf(statement) + ", ";
        }
        statement = String.valueOf(statement) + ")" + NEWLINE + "AS (";
        QueryExpression expression = table.getQueryExpression();
        if (expression == null) {
            this.getEngineeringCallBack().writeMessage(MessageFormat.format(LUWDdlMessages.FE_MQT_HAS_NO_BODY, String.valueOf(schemaName) + "." + tableName));
            return null;
        }
        statement = String.valueOf(statement) + expression.getSQL() + ")" + NEWLINE;
        statement = table.isOptimizeQuery() ? String.valueOf(statement) + " ENABLE" : String.valueOf(statement) + " DISABLE";
        statement = String.valueOf(statement) + " QUERY OPTIMIZATION" + NEWLINE;
        if (this.generator == null || EngineeringOptionID.generateInTablespaceClause((EngineeringOption[])this.generator.getSelectedOptions())) {
            statement = String.valueOf(statement) + this.getTablespaceString(table, quoteIdentifiers);
        }
        statement = String.valueOf(statement) + this.getPartitionKey(table, quoteIdentifiers);
        statement = String.valueOf(statement) + this.getCompressionValue(table);
        return statement;
    }

    public String dropMQT(LUWMaterializedQueryTable table, boolean quoteIdentifiers, boolean qualifyNames) {
        String tableName = table.getName();
        String schemaName = table.getSchema().getName();
        if (quoteIdentifiers) {
            tableName = this.getDoubleQuotedString(tableName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            tableName = String.valueOf(schemaName) + "." + tableName;
        }
        return "DROP TABLE " + tableName;
    }

    public String dropPackage(LUWDatabasePackage dbpackage, boolean quoteIdentifiers, boolean qualifyNames) {
        String schemaName = dbpackage.getSchema().getName();
        String packageName = dbpackage.getName();
        String versionName = null;
        if (quoteIdentifiers) {
            schemaName = this.getDoubleQuotedString(schemaName);
            packageName = this.getDoubleQuotedString(packageName);
        }
        if (qualifyNames) {
            packageName = String.valueOf(schemaName) + "." + packageName;
        }
        if (dbpackage.getVersion() != null && dbpackage.getVersion().trim().length() > 0) {
            versionName = this.getDoubleQuotedString(dbpackage.getVersion().trim());
        }
        return "DROP PACKAGE " + packageName + (versionName != null ? " VERSION " + versionName : "");
    }

    public String createTable(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames) {
        String tableDefinition = super.createTable((Table)table, quoteIdentifiers, qualifyNames);
        LUWTable t = (LUWTable)table;
        tableDefinition = String.valueOf(tableDefinition) + this.getTableDimension(t, quoteIdentifiers);
        tableDefinition = String.valueOf(tableDefinition) + this.getDataCapture(t);
        if (this.generator == null || EngineeringOptionID.generateInTablespaceClause((EngineeringOption[])this.generator.getSelectedOptions())) {
            tableDefinition = String.valueOf(tableDefinition) + this.getTablespaceString(t, quoteIdentifiers);
        }
        tableDefinition = String.valueOf(tableDefinition) + this.getPartitionKey(t, quoteIdentifiers);
        tableDefinition = String.valueOf(tableDefinition) + this.getCompressionValue(t);
        return tableDefinition;
    }

    public String createView(LUWView view, boolean quoteIdentifiers, boolean qualifyNames) {
        QueryExpression expression = view.getQueryExpression();
        if (expression == null) {
            this.getEngineeringCallBack().writeMessage(MessageFormat.format(LUWDdlMessages.FE_VIEW_HAS_NO_BODY, this.getName((Table)view, false, true)));
            return null;
        }
        String sql = expression.getSQL();
        String viewDefinition = "CREATE ";
        if (view.isFederated()) {
            viewDefinition = String.valueOf(viewDefinition) + "FEDERATED ";
        }
        viewDefinition = String.valueOf(viewDefinition) + "VIEW " + this.getName((Table)view, quoteIdentifiers, qualifyNames) + " ";
        String columns = this.getViewColumnList((ViewTable)view, quoteIdentifiers);
        if (columns != null) {
            viewDefinition = String.valueOf(viewDefinition) + "(" + columns + ")" + " ";
        }
        viewDefinition = String.valueOf(viewDefinition) + "AS" + NEWLINE;
        viewDefinition = String.valueOf(viewDefinition) + sql;
        CheckType checkType = view.getCheckType();
        if (checkType == CheckType.CASCADED_LITERAL) {
            viewDefinition = String.valueOf(viewDefinition) + NEWLINE + "WITH" + " " + "CASCADED" + " " + "CHECK" + " " + "OPTION";
        } else if (checkType == CheckType.LOCAL_LITERAL) {
            viewDefinition = String.valueOf(viewDefinition) + NEWLINE + "WITH" + " " + "LOCAL" + " " + "CHECK" + " " + "OPTION";
        }
        return viewDefinition;
    }

    public String createIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        DB2Index ind;
        if (this.getIndexKeyColumns(index, quoteIdentifiers) == null) {
            this.getEngineeringCallBack().writeMessage(MessageFormat.format(LUWDdlMessages.FE_INDEX_MEMBERS_NOT_SPECIFIED, index.getName()));
            return null;
        }
        String indexDefinition = super.createIndex(index, quoteIdentifiers, qualifyNames);
        if (index instanceof LUWIndex) {
            indexDefinition = String.valueOf(indexDefinition) + this.getDataPartitionOptions((LUWIndex)index);
        }
        if ((ind = (DB2Index)index).getTable() instanceof LUWNickname) {
            indexDefinition = String.valueOf(indexDefinition) + " SPECIFICATION ONLY";
        } else {
            String included = this.getIndexIncludedColumns(ind, quoteIdentifiers);
            if (included != null) {
                indexDefinition = String.valueOf(indexDefinition) + NEWLINE + "INCLUDE (" + included + ")" + NEWLINE;
            }
            if (ind.isClustered()) {
                indexDefinition = String.valueOf(indexDefinition) + " CLUSTER ";
            }
            int i = ind.getFillFactor();
            indexDefinition = String.valueOf(indexDefinition) + " PCTFREE " + i;
            indexDefinition = String.valueOf(indexDefinition) + NEWLINE + "ALLOW REVERSE SCANS";
        }
        return indexDefinition;
    }

    protected String getDataPartitionOptions(LUWIndex index) {
        return "";
    }

    public String createNickname(LUWNickname nickname, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        Database database;
        ExtendDdlBuilder nicknameDdlBuilder;
        if (nickname != null && (nicknameDdlBuilder = DdlGenerationUtility.getNicknameDdlBuilder((String)(database = nickname.getSchema().getDatabase()).getVendor(), (String)database.getVersion())) != null && (ddl = nicknameDdlBuilder.buildCreateStatement((Object)nickname, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        return null;
    }

    public String dropNickname(LUWNickname nickname, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        Database database;
        ExtendDdlBuilder nicknameDdlBuilder;
        if (nickname != null && (nicknameDdlBuilder = DdlGenerationUtility.getNicknameDdlBuilder((String)(database = nickname.getSchema().getDatabase()).getVendor(), (String)database.getVersion())) != null && (ddl = nicknameDdlBuilder.buildDropStatement((Object)nickname, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        return null;
    }

    public String commentOn(LUWNickname nickname, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        Database database;
        ExtendDdlBuilder nicknameDdlBuilder;
        if (nickname != null && (nicknameDdlBuilder = DdlGenerationUtility.getNicknameDdlBuilder((String)(database = nickname.getSchema().getDatabase()).getVendor(), (String)database.getVersion())) != null && (ddl = nicknameDdlBuilder.buildCommentOnStatement((Object)nickname, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        return null;
    }

    public String createFederatedProcedure(FederatedProcedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        Database database;
        ExtendDdlBuilder federatedProcedureDdlBuilder;
        if (procedure != null && (federatedProcedureDdlBuilder = DdlGenerationUtility.getFederatedProcedureDdlBuilder((String)(database = procedure.getSchema().getDatabase()).getVendor(), (String)database.getVersion())) != null && (ddl = federatedProcedureDdlBuilder.buildCreateStatement((Object)procedure, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        return null;
    }

    public String dropFederatedProcedure(FederatedProcedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        Database database;
        ExtendDdlBuilder federatedProcedureDdlBuilder;
        if (procedure != null && (federatedProcedureDdlBuilder = DdlGenerationUtility.getFederatedProcedureDdlBuilder((String)(database = procedure.getSchema().getDatabase()).getVendor(), (String)database.getVersion())) != null && (ddl = federatedProcedureDdlBuilder.buildDropStatement((Object)procedure, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        return null;
    }

    public String commentOn(FederatedProcedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        Database database;
        ExtendDdlBuilder federatedProcedureDdlBuilder;
        if (procedure != null && (federatedProcedureDdlBuilder = DdlGenerationUtility.getFederatedProcedureDdlBuilder((String)(database = procedure.getSchema().getDatabase()).getVendor(), (String)database.getVersion())) != null && (ddl = federatedProcedureDdlBuilder.buildCommentOnStatement((Object)procedure, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        return null;
    }

    public String createRemoteServer(LUWServer remoteServer, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        LUWDatabase database;
        ExtendDdlBuilder remoteServerDdlBuilder;
        if (remoteServer != null && (remoteServerDdlBuilder = DdlGenerationUtility.getRemoteServerDdlBuilder((String)(database = remoteServer.getLUWDatabase()).getVendor(), (String)database.getVersion())) != null && (ddl = remoteServerDdlBuilder.buildCreateStatement((Object)remoteServer, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        return null;
    }

    public String dropRemoteServer(LUWServer remoteServer, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        LUWDatabase database;
        ExtendDdlBuilder remoteServerDdlBuilder;
        if (remoteServer != null && (remoteServerDdlBuilder = DdlGenerationUtility.getRemoteServerDdlBuilder((String)(database = remoteServer.getLUWDatabase()).getVendor(), (String)database.getVersion())) != null && (ddl = remoteServerDdlBuilder.buildDropStatement((Object)remoteServer, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        return null;
    }

    public String commentOn(LUWServer remoteServer, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        LUWDatabase database;
        ExtendDdlBuilder remoteServerDdlBuilder;
        if (remoteServer != null && (remoteServerDdlBuilder = DdlGenerationUtility.getRemoteServerDdlBuilder((String)(database = remoteServer.getLUWDatabase()).getVendor(), (String)database.getVersion())) != null && (ddl = remoteServerDdlBuilder.buildCommentOnStatement((Object)remoteServer, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        return null;
    }

    public String createWrapper(LUWWrapper wrapper, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        LUWDatabase database;
        ExtendDdlBuilder wrapperDdlBuilder;
        if (wrapper != null && (wrapperDdlBuilder = DdlGenerationUtility.getWrapperDdlBuilder((String)(database = wrapper.getLUWDatabase()).getVendor(), (String)database.getVersion())) != null && (ddl = wrapperDdlBuilder.buildCreateStatement((Object)wrapper, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        return null;
    }

    public String dropWrapper(LUWWrapper wrapper, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        LUWDatabase database;
        ExtendDdlBuilder wrapperDdlBuilder;
        if (wrapper != null && (wrapperDdlBuilder = DdlGenerationUtility.getWrapperDdlBuilder((String)(database = wrapper.getLUWDatabase()).getVendor(), (String)database.getVersion())) != null && (ddl = wrapperDdlBuilder.buildDropStatement((Object)wrapper, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        return null;
    }

    public String commentOn(LUWWrapper wrapper, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        LUWDatabase database;
        ExtendDdlBuilder wrapperDdlBuilder;
        if (wrapper != null && (wrapperDdlBuilder = DdlGenerationUtility.getWrapperDdlBuilder((String)(database = wrapper.getLUWDatabase()).getVendor(), (String)database.getVersion())) != null && (ddl = wrapperDdlBuilder.buildCommentOnStatement((Object)wrapper, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        return null;
    }

    public String createUserMapping(LUWUserMapping userMapping, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        LUWDatabase database;
        ExtendDdlBuilder userMappingDdlBuilder;
        LUWServer luwServer;
        if (userMapping != null && (luwServer = userMapping.getServer()) != null && (userMappingDdlBuilder = DdlGenerationUtility.getUserMappingDdlBuilder((String)(database = luwServer.getLUWDatabase()).getVendor(), (String)database.getVersion())) != null && (ddl = userMappingDdlBuilder.buildCreateStatement((Object)userMapping, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        return null;
    }

    public String dropUserMapping(LUWUserMapping userMapping, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        LUWDatabase database;
        ExtendDdlBuilder userMappingDdlBuilder;
        LUWServer luwServer;
        if (userMapping != null && (luwServer = userMapping.getServer()) != null && (userMappingDdlBuilder = DdlGenerationUtility.getUserMappingDdlBuilder((String)(database = luwServer.getLUWDatabase()).getVendor(), (String)database.getVersion())) != null && (ddl = userMappingDdlBuilder.buildDropStatement((Object)userMapping, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        return null;
    }

    public String commentOn(LUWUserMapping userMapping, boolean quoteIdentifiers, boolean qualifyNames) {
        String ddl;
        LUWDatabase database;
        ExtendDdlBuilder userMappingDdlBuilder;
        LUWServer luwServer;
        if (userMapping != null && (luwServer = userMapping.getServer()) != null && (userMappingDdlBuilder = DdlGenerationUtility.getUserMappingDdlBuilder((String)(database = luwServer.getLUWDatabase()).getVendor(), (String)database.getVersion())) != null && (ddl = userMappingDdlBuilder.buildCommentOnStatement((Object)userMapping, quoteIdentifiers, qualifyNames)) != null) {
            return ddl;
        }
        return null;
    }

    public String commentOn(LUWTableSpace tablespace, boolean quoteIdentifiers) {
        String comment = tablespace.getDescription();
        if (comment == null || comment.equals("")) {
            return null;
        }
        String tablespaceName = tablespace.getName();
        if (quoteIdentifiers) {
            tablespaceName = this.getDoubleQuotedString(tablespaceName);
        }
        return "COMMENT ON TABLESPACE " + tablespaceName + " IS" + NEWLINE + this.getSingleQuotedString(comment);
    }

    public String createPartitionGroup(LUWPartitionGroup pg, boolean quoteIdentifiers) {
        String pgName = pg.getName();
        if (pgName.startsWith(IBM) || pgName.startsWith(SYS)) {
            return null;
        }
        if (quoteIdentifiers) {
            pgName = this.getDoubleQuotedString(pgName);
        }
        String statement = "CREATE DATABASE PARTITION GROUP " + pgName + " ON ";
        String partitions = "";
        boolean isAllPartition = true;
        Iterator it = pg.getPartitions().iterator();
        while (it.hasNext()) {
            LUWDatabasePartition partition = (LUWDatabasePartition)it.next();
            int partitionNum = partition.getNumber();
            if (partitionNum < 0) break;
            partitions = String.valueOf(partitions) + partition.getNumber();
            if (it.hasNext()) {
                partitions = String.valueOf(partitions) + ", ";
            }
            isAllPartition = false;
        }
        statement = isAllPartition ? String.valueOf(statement) + "ALL DBPARTITIONNUMS" : String.valueOf(statement) + "DBPARTITIONNUMS (" + partitions + ")";
        return statement;
    }

    public String dropPartitionGroup(LUWPartitionGroup pg, boolean quoteIdentifiers) {
        String pgName = pg.getName();
        if (pgName.startsWith(IBM) || pgName.startsWith(SYS)) {
            return null;
        }
        if (quoteIdentifiers) {
            pgName = this.getDoubleQuotedString(pgName);
        }
        return "DROP DATABASE PARTITION GROUP " + pgName;
    }

    public String commentOn(LUWPartitionGroup pg, boolean quoteIdentifiers) {
        String comment = pg.getDescription();
        if (comment == null || comment.equals("")) {
            return null;
        }
        String pgName = pg.getName();
        if (quoteIdentifiers) {
            pgName = this.getDoubleQuotedString(pgName);
        }
        return "COMMENT ON DATABASE PARTITION GROUP " + pgName + " IS" + NEWLINE + this.getSingleQuotedString(comment);
    }

    public String createStructuredUserDefinedType(StructuredUserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        EList attrs = type.getAttributes();
        EObject root = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)type);
        Schema schema = type.getSchema();
        ModelHelper.getDatabase((Schema)schema);
        if (!(root instanceof Database)) {
            return null;
        }
        DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition((Database)root);
        String statement = "CREATE TYPE " + this.getName((UserDefinedType)type, quoteIdentifiers, qualifyNames);
        StructuredUserDefinedType superType = type.getSuper();
        if (superType != null) {
            statement = String.valueOf(statement) + " UNDER " + this.getName((UserDefinedType)superType, quoteIdentifiers, qualifyNames);
        }
        if (!attrs.isEmpty()) {
            statement = String.valueOf(statement) + " AS(";
            Iterator it = attrs.iterator();
            while (it.hasNext()) {
                LUWAttributeDefinition attr = (LUWAttributeDefinition)it.next();
                String typeName = this.getDataTypeString((TypedElement)attr, schema, quoteIdentifiers, qualifyNames);
                statement = String.valueOf(statement) + NEWLINE + "\t" + attr.getName() + " " + typeName;
                if (typeName.indexOf("CLOB") != -1 || typeName.indexOf("BLOB") != -1) {
                    statement = String.valueOf(statement) + this.getLOBLoggedClause(attr);
                    if (attr.isLOBCompacted()) {
                        statement = String.valueOf(statement) + " COMPACT";
                    }
                }
                if (!it.hasNext()) continue;
                statement = String.valueOf(statement) + ", ";
            }
            statement = String.valueOf(statement) + ")";
        }
        if (!type.isInstantiable()) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + "NOT INSTANTIABLE";
        }
        if (type.isFinal()) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + "FINAL";
        }
        statement = String.valueOf(statement) + NEWLINE + "\t" + "MODE DB2SQL";
        return statement;
    }

    public String commentOn(StructuredUserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        String comment = type.getDescription();
        if (comment == null || comment.length() == 0) {
            return null;
        }
        String name = this.getName((UserDefinedType)type, quoteIdentifiers, qualifyNames);
        return "COMMENT ON TYPE " + name + " " + "IS" + NEWLINE + this.getSingleQuotedString(comment);
    }

    public String createModule(LUWModule module, boolean quoteIdentifiers, boolean qualifyNames) {
        ILUWModuleDdlBuilder moduleBuilder = LUWDdlGenerator.getModuleDdlBuilder();
        if (moduleBuilder != null) {
            return moduleBuilder.buildCreateStatement(module, quoteIdentifiers, qualifyNames);
        }
        return null;
    }

    public String dropModule(LUWModule module, boolean quoteIdentifiers, boolean qualifyNames) {
        ILUWModuleDdlBuilder moduleBuilder = LUWDdlGenerator.getModuleDdlBuilder();
        if (moduleBuilder != null) {
            return moduleBuilder.buildDropStatement(module, quoteIdentifiers, qualifyNames);
        }
        return null;
    }

    public String commentOn(LUWModule module, boolean quoteIdentifiers, boolean qualifyNames) {
        ILUWModuleDdlBuilder moduleBuilder = LUWDdlGenerator.getModuleDdlBuilder();
        if (moduleBuilder != null) {
            return moduleBuilder.buildCommentStatement(module, quoteIdentifiers, qualifyNames);
        }
        return null;
    }

    public String createModuleCondition(LUWModuleCondition condtion, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.createModuleObject(condtion, quoteIdentifiers, qualifyNames);
    }

    public String dropModuleCondition(LUWModuleCondition condtion, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.dropModuleObject(condtion, quoteIdentifiers, qualifyNames);
    }

    public String createModuleGlobalVariable(LUWModuleGlobalVariable variable, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.createModuleObject(variable, quoteIdentifiers, qualifyNames);
    }

    public String dropModuleGlobalVariable(LUWModuleGlobalVariable condtion, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.dropModuleObject(condtion, quoteIdentifiers, qualifyNames);
    }

    public String createGlobalVariable(LUWGlobalVariable variable, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer text = new StringBuffer();
        text.append("CREATE").append(" ").append(VARIABLE).append(" ").append(this.getName(variable, quoteIdentifiers, qualifyNames)).append(" ").append(this.getDataTypeString(variable, (Schema)variable.getSchema(), quoteIdentifiers, qualifyNames));
        String expression = variable.getDefaultValue();
        if (expression != null && !"".equals(expression)) {
            if (variable.isIsConstant()) {
                text.append(NEWLINE).append("\t").append(CONSTANT);
            } else {
                text.append(NEWLINE).append("\t").append("DEFAULT");
            }
            text.append(" ").append("(").append(expression).append(")");
        }
        return text.toString();
    }

    public String dropGlobalVariable(LUWGlobalVariable variable, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer text = new StringBuffer();
        text.append("DROP").append(" ").append(VARIABLE).append(" ").append(this.getName(variable, quoteIdentifiers, qualifyNames));
        return text.toString();
    }

    public String createArrayDataType(LUWArrayDataType type, boolean quoteIdentifiers, boolean qualifyNames) {
        if (type instanceof LUWModuleArrayDataType) {
            return this.createModuleObject((LUWModuleArrayDataType)type, quoteIdentifiers, qualifyNames);
        }
        StringBuffer text = new StringBuffer();
        text.append("CREATE").append(" ").append("TYPE").append(" ").append(this.getName(type, quoteIdentifiers, qualifyNames)).append(" ").append("AS").append(" ").append(this.getDataTypeString((TypedElement)type.getElementType(), type.getSchema(), quoteIdentifiers, qualifyNames)).append(" ").append(ARRAY).append(" ").append("[").append(type.getMaxCardinality() > 0 ? Integer.valueOf(type.getMaxCardinality()) : "").append("]");
        return text.toString();
    }

    public String createRowDataType(LUWRowDataType type, boolean quoteIdentifiers, boolean qualifyNames) {
        if (type instanceof LUWModuleRowDataType) {
            return this.createModuleObject((LUWModuleRowDataType)type, quoteIdentifiers, qualifyNames);
        }
        StringBuffer text = new StringBuffer();
        text.append("CREATE").append(" ").append("TYPE").append(" ").append(this.getName(type, quoteIdentifiers, qualifyNames)).append(" ").append("AS").append(" ").append("ROW");
        EList fields = type.getFields();
        if (!fields.isEmpty()) {
            text.append("(");
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                Field field = (Field)it.next();
                String typeName = this.getDataTypeString((TypedElement)field, type.getSchema(), quoteIdentifiers, qualifyNames);
                text.append(NEWLINE).append("\t").append(field.getName()).append(" ").append(typeName);
                if (!it.hasNext()) continue;
                text.append(", ");
            }
            text.append(")");
        }
        return text.toString();
    }

    public String createCursorDataType(LUWCursorDataType type, boolean quoteIdentifiers, boolean qualifyNames) {
        if (type instanceof LUWModuleCursorDataType) {
            return this.createModuleObject((LUWModuleCursorDataType)type, quoteIdentifiers, qualifyNames);
        }
        StringBuffer text = new StringBuffer();
        text.append("CREATE").append(" ").append("TYPE").append(" ").append(this.getName(type, quoteIdentifiers, qualifyNames)).append(" ").append("AS").append(" ");
        LUWRowDataType rowType = type.getRowType();
        if (rowType != null) {
            text.append(this.getName(rowType, quoteIdentifiers, qualifyNames)).append(" ");
        }
        text.append(CURSOR);
        return text.toString();
    }

    public String createModuleDistinctType(LUWModuleDistinctType type, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.createModuleObject(type, quoteIdentifiers, qualifyNames);
    }

    public String dropUserDefinedType(UserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        if (type instanceof LUWModuleObject) {
            return this.dropModuleObject((LUWModuleObject)type, quoteIdentifiers, qualifyNames);
        }
        return super.dropUserDefinedType(type, quoteIdentifiers, qualifyNames);
    }

    public String commentOn(LUWModuleCondition condtion, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.commentOnModuleObject(condtion, quoteIdentifiers, qualifyNames);
    }

    public String dropPlsqlPackage(PLSQLPackage plPackage, boolean quoteIdentifiers, boolean qualifyNames) {
        ILUWModuleDdlBuilder moduleBuilder = LUWDdlGenerator.getModuleDdlBuilder();
        if (moduleBuilder != null) {
            return moduleBuilder.buildDropStatement(plPackage, quoteIdentifiers, qualifyNames);
        }
        return null;
    }

    public String createPlsqlPackage(PLSQLPackage plPackage, boolean quoteIdentifiers, boolean qualifyNames) {
        ILUWModuleDdlBuilder moduleBuilder = LUWDdlGenerator.getModuleDdlBuilder();
        if (moduleBuilder != null) {
            return moduleBuilder.buildCreateStatement(plPackage, quoteIdentifiers, qualifyNames);
        }
        return null;
    }

    public String dropPlsqlPackageBody(PLSQLPackageBody packageBody, boolean quoteIdentifiers, boolean qualifyNames) {
        ILUWModuleDdlBuilder moduleBuilder = LUWDdlGenerator.getModuleDdlBuilder();
        if (moduleBuilder != null) {
            return moduleBuilder.buildDropStatement((SQLObject)packageBody, quoteIdentifiers, qualifyNames);
        }
        return null;
    }

    public String createPlsqlPackageBody(PLSQLPackageBody packageBody, boolean quoteIdentifiers, boolean qualifyNames) {
        ILUWModuleDdlBuilder moduleBuilder = LUWDdlGenerator.getModuleDdlBuilder();
        if (moduleBuilder != null) {
            return moduleBuilder.buildCreateStatement((SQLObject)packageBody, quoteIdentifiers, qualifyNames);
        }
        return null;
    }

    public String createProcedure(DB2Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        if (procedure instanceof LUWModuleObject) {
            return this.createModuleObject((LUWModuleObject)procedure, quoteIdentifiers, qualifyNames);
        }
        return super.createProcedure(procedure, quoteIdentifiers, qualifyNames);
    }

    public String dropProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        if (procedure instanceof LUWModuleObject) {
            return this.dropModuleObject((LUWModuleObject)procedure, quoteIdentifiers, qualifyNames);
        }
        return super.dropProcedure(procedure, quoteIdentifiers, qualifyNames);
    }

    public String commentOn(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        if (procedure instanceof LUWModuleObject) {
            return this.commentOnModuleObject((LUWModuleObject)procedure, quoteIdentifiers, qualifyNames);
        }
        return super.commentOn(procedure, quoteIdentifiers, qualifyNames);
    }

    public String createUserDefinedFunction(DB2UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        if (function instanceof LUWModuleObject) {
            return this.createModuleObject((LUWModuleObject)function, quoteIdentifiers, qualifyNames);
        }
        return super.createUserDefinedFunction(function, quoteIdentifiers, qualifyNames);
    }

    public String dropFunction(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        if (function instanceof LUWModuleObject) {
            return this.dropModuleObject((LUWModuleObject)function, quoteIdentifiers, qualifyNames);
        }
        return super.dropFunction(function, quoteIdentifiers, qualifyNames);
    }

    public String commentOn(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        if (function instanceof LUWModuleObject) {
            return this.commentOnModuleObject((LUWModuleObject)function, quoteIdentifiers, qualifyNames);
        }
        return super.commentOn(function, quoteIdentifiers, qualifyNames);
    }

    public String commentOn(Role role, boolean quoteIdentifiers, boolean qualifyNames) {
        return null;
    }

    public String alterCommentOn(SQLObject sqlObject, boolean quoteIdentifiers, boolean qualifyNames) {
        String commentType;
        String comment = sqlObject.getDescription();
        if (comment == null || comment.length() == 0) {
            comment = "''";
        }
        return (commentType = this.getCommentType(sqlObject, quoteIdentifiers, qualifyNames)) == null ? "" : "COMMENT ON " + commentType + " " + "IS" + " " + this.getSingleQuotedString(comment);
    }

    public String commentOn(Sequence sequence, boolean quoteIdentifiers, boolean qualifyNames) {
        return null;
    }

    protected String getCommentType(SQLObject sqlObject, boolean quoteIdentifiers, boolean qualifyNames) {
        String comments = "";
        if (sqlObject instanceof LUWTable) {
            comments = String.valueOf(comments) + "TABLE " + this.getName((Table)sqlObject, quoteIdentifiers, qualifyNames);
        } else if (sqlObject instanceof LUWView) {
            comments = String.valueOf(comments) + "TABLE " + this.getName((Table)sqlObject, quoteIdentifiers, qualifyNames);
        } else if (sqlObject instanceof LUWMaterializedQueryTable) {
            comments = String.valueOf(comments) + "TABLE " + this.getName((Table)sqlObject, quoteIdentifiers, qualifyNames);
        } else if (sqlObject instanceof LUWTableSpace) {
            comments = String.valueOf(comments) + "TABLESPACE " + this.getName((LUWTableSpace)sqlObject, quoteIdentifiers);
        } else if (sqlObject instanceof DB2Alias) {
            comments = String.valueOf(comments) + "ALIAS " + this.getName((Table)((DB2Alias)sqlObject), quoteIdentifiers, qualifyNames);
        } else if (sqlObject instanceof Procedure) {
            comments = String.valueOf(comments) + "PROCEDURE " + this.getName((Routine)((Procedure)sqlObject), quoteIdentifiers, qualifyNames);
        } else if (sqlObject instanceof Function) {
            comments = String.valueOf(comments) + "FUNCTION " + this.getName((Routine)((Function)sqlObject), quoteIdentifiers, qualifyNames);
        } else if (sqlObject instanceof Trigger) {
            comments = String.valueOf(comments) + "TRIGGER " + this.getName((Trigger)sqlObject, quoteIdentifiers, qualifyNames);
        } else if (sqlObject instanceof TableConstraint) {
            comments = String.valueOf(comments) + "CONSTRAINT " + this.getTableConstraintName((TableConstraint)sqlObject, quoteIdentifiers, qualifyNames);
        } else if (sqlObject instanceof Index) {
            comments = String.valueOf(comments) + "INDEX " + this.getName((Index)sqlObject, quoteIdentifiers, qualifyNames);
        } else if (sqlObject instanceof DistinctUserDefinedType) {
            comments = String.valueOf(comments) + "DISTINCT TYPE " + this.getName((UserDefinedType)((DistinctUserDefinedType)sqlObject), quoteIdentifiers, qualifyNames);
        } else if (sqlObject instanceof StructuredUserDefinedType) {
            comments = String.valueOf(comments) + "TYPE " + this.getName((UserDefinedType)((StructuredUserDefinedType)sqlObject), quoteIdentifiers, qualifyNames);
        } else if (sqlObject instanceof Column) {
            comments = String.valueOf(comments) + "COLUMN " + this.getName((Column)sqlObject, quoteIdentifiers, qualifyNames);
        } else if (sqlObject instanceof LUWPartitionGroup) {
            comments = String.valueOf(comments) + "DATABASE PARTITION GROUP " + this.getName((LUWPartitionGroup)sqlObject, quoteIdentifiers);
        } else if (sqlObject instanceof Schema) {
            comments = String.valueOf(comments) + "SCHEMA " + this.getName((Schema)sqlObject, quoteIdentifiers, qualifyNames);
        }
        return comments;
    }

    public String alterObject(LUWTable element) {
        String statement = this.createTable((BaseTable)element, true, true);
        if (statement != null) {
            statement = "CALL SYSPROC.ALTOBJ(" + NEWLINE + "\t'APPLY_CONTINUE_ON_ERROR'," + NEWLINE + "\t'" + statement + "'," + NEWLINE + "\t-1, ?)";
        }
        return statement;
    }

    public String addUniqueConstraint(UniqueConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = super.addUniqueConstraint(constraint, quoteIdentifiers, qualifyNames);
        if (constraint.eContainer() instanceof LUWNickname) {
            if (statement == null) {
                return null;
            }
            statement = String.valueOf(statement) + " NOT ENFORCED";
        }
        return statement;
    }

    public String addCheckConstraint(CheckConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = super.addCheckConstraint(constraint, quoteIdentifiers, qualifyNames);
        if (constraint.eContainer() instanceof LUWNickname) {
            if (statement == null) {
                return null;
            }
            if (constraint.isEnforced()) {
                statement = String.valueOf(statement) + " NOT ENFORCED";
            }
        }
        return statement;
    }

    public String addForeignKey(ForeignKey foreignKey, boolean quoteIdentifiers, boolean qualifyNames) {
        UniqueConstraint uniqueConstraint = foreignKey.getUniqueConstraint();
        Index index = foreignKey.getUniqueIndex();
        BaseTable parentTable = null;
        String parentKey = null;
        if (uniqueConstraint != null) {
            parentTable = uniqueConstraint.getBaseTable();
            parentKey = this.getKeyColumns((ReferenceConstraint)uniqueConstraint, quoteIdentifiers);
            if (parentKey == null) {
                this.getEngineeringCallBack().writeMessage(MessageFormat.format(LUWDdlMessages.FE_REFERENCED_PARENT_KEY_DOES_NOT_EXIST, foreignKey.getName()));
                return null;
            }
        } else if (index != null) {
            parentTable = index.getTable();
            parentKey = this.getParentKeyColumns(index, quoteIdentifiers);
            if (parentKey == null) {
                this.getEngineeringCallBack().writeMessage(MessageFormat.format(LUWDdlMessages.FE_REFERENCED_PARENT_KEY_DOES_NOT_EXIST, foreignKey.getName()));
                return null;
            }
        }
        if (parentTable == null) {
            this.getEngineeringCallBack().writeMessage(MessageFormat.format(LUWDdlMessages.FE_REFERENCED_PARENT_TABLE_DOES_NOT_EXIST, foreignKey.getName()));
            return null;
        }
        String statement = "ALTER " + this.getOwnerType((TableConstraint)foreignKey) + " " + this.getName((Table)foreignKey.getBaseTable(), quoteIdentifiers, qualifyNames) + " " + "ADD" + " " + "CONSTRAINT" + " " + this.getName((TableConstraint)foreignKey, quoteIdentifiers) + " " + "FOREIGN KEY" + this.getKeyColumns((ReferenceConstraint)foreignKey, quoteIdentifiers);
        statement = String.valueOf(statement) + NEWLINE + "\t" + "REFERENCES" + " " + this.getName((Table)parentTable, quoteIdentifiers, qualifyNames) + parentKey;
        if (foreignKey.eContainer() instanceof LUWNickname) {
            statement = String.valueOf(statement) + " NOT ENFORCED";
        } else {
            ReferentialActionType action = foreignKey.getOnDelete();
            if (action != ReferentialActionType.NO_ACTION_LITERAL) {
                statement = String.valueOf(statement) + NEWLINE + "\t" + "ON" + " " + "DELETE" + " ";
            }
            statement = String.valueOf(statement) + this.getReferentialAction(action);
            action = foreignKey.getOnUpdate();
            if (action != ReferentialActionType.NO_ACTION_LITERAL) {
                statement = String.valueOf(statement) + NEWLINE + "\t" + "ON" + " " + "UPDATE" + " ";
            }
            statement = String.valueOf(statement) + this.getReferentialAction(action);
            if (foreignKey.isDeferrable()) {
                statement = String.valueOf(statement) + NEWLINE + "\t" + this.getDeferrableClause((Constraint)foreignKey);
            }
            statement = String.valueOf(statement) + this.getEnforcedOption((Constraint)foreignKey);
        }
        return statement;
    }

    public String[] grantOn(LUWTableSpace tablespace, boolean quoteIdentifiers) {
        String tablespaceName = tablespace.getName();
        if (quoteIdentifiers) {
            tablespaceName = this.getDoubleQuotedString(tablespaceName);
        }
        return this.getGrantString(tablespace, quoteIdentifiers, false);
    }

    public String[] revokeFrom(LUWTableSpace tablespace, boolean quoteIdentifiers) {
        String tablespaceName = tablespace.getName();
        if (quoteIdentifiers) {
            tablespaceName = this.getDoubleQuotedString(tablespaceName);
        }
        return this.getRevokeString(tablespace, quoteIdentifiers, false);
    }

    public String alterTableAlterProperties(Table table, int propertyType, boolean quoteIdentifiers, boolean qualifyNames) {
        if (!(table instanceof LUWTable)) {
            return null;
        }
        String proString = "";
        if ((propertyType & 0x80) == 128) {
            proString = String.valueOf(proString) + this.getDataCapture((LUWTable)table);
        }
        if ((propertyType & 0x2000) == 8192) {
            proString = String.valueOf(proString) + this.getAlterTableAlterValueCompressionString((LUWTable)table);
        }
        if ((propertyType & 0x100) == 256) {
            proString = String.valueOf(proString) + this.getAlterTableAlterVolatileString((LUWTable)table);
        }
        if ((propertyType & 0x200) == 512) {
            proString = String.valueOf(proString) + this.getAlterTableAlterRowCompressionString((LUWTable)table);
        }
        if (!proString.equals("")) {
            String statement = "ALTER TABLE " + this.getName(table, quoteIdentifiers, qualifyNames) + proString;
            return statement;
        }
        return null;
    }

    public String alterTableAlterPartitionKey(LUWStorageTable table, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "ALTER TABLE " + this.getName((Table)table, quoteIdentifiers, qualifyNames);
        LUWPartitionKey partitionKey = table.getPartitionKey();
        statement = partitionKey == null || partitionKey.getColumns().isEmpty() ? String.valueOf(statement) + " DROP PARTITIONING KEY" : String.valueOf(statement) + " ADD " + this.getPartitionKeyDefinition(partitionKey, quoteIdentifiers);
        return statement;
    }

    public String getGrantPrivilegeStatement(Privilege privilege, boolean quoteIdentifiers, boolean qualifyNames) {
        if (this.isDDLSupressable(privilege)) {
            if (this.getEngineeringCallBack() != null) {
                String message = this.getSystemGrantMessage("GRANT", privilege, quoteIdentifiers, qualifyNames);
                this.getEngineeringCallBack().writeMessage(message);
            }
            return null;
        }
        AuthorizationIdentifier authId = privilege.getGrantee();
        String granteeType = "";
        if (authId.getName().equals("PUBLIC")) {
            granteeType = "";
        } else if (authId instanceof User) {
            granteeType = "USER";
        } else if (authId instanceof Group && !authId.getName().equals("PUBLIC")) {
            granteeType = "GROUP";
        } else if (authId instanceof Role) {
            granteeType = "ROLE";
        }
        String prep = "ON";
        if (privilege.getObject() instanceof LUWTableSpace) {
            prep = "OF";
        }
        String ret = "GRANT " + privilege.getAction() + " " + prep + " " + this.getPrivilegedObjectTypeString(privilege) + " " + this.getPrivilegedObjectName(privilege, quoteIdentifiers, qualifyNames) + " " + "TO" + " " + granteeType + " " + this.getName(privilege.getGrantee(), quoteIdentifiers);
        if (privilege.isGrantable()) {
            ret = String.valueOf(ret) + " WITH GRANT OPTION";
        }
        return ret;
    }

    public String getRevokePrivilegeStatement(Privilege privilege, boolean quoteIdentifiers, boolean qualifyNames) {
        if (this.isDDLSupressable(privilege)) {
            if (this.getEngineeringCallBack() != null) {
                String message = this.getSystemGrantMessage("REVOKE", privilege, quoteIdentifiers, qualifyNames);
                this.getEngineeringCallBack().writeMessage(message);
            }
            return null;
        }
        AuthorizationIdentifier authId = privilege.getGrantee();
        String granteeType = "";
        if (authId instanceof User) {
            granteeType = "USER";
        } else if (authId instanceof Group && !authId.getName().equals("PUBLIC")) {
            granteeType = "GROUP";
        } else if (authId instanceof Role) {
            granteeType = "ROLE";
        }
        String prep = "ON";
        if (privilege.getObject() instanceof LUWTableSpace) {
            prep = "OF";
        }
        String ret = "REVOKE " + privilege.getAction() + " " + prep + " " + this.getPrivilegedObjectTypeString(privilege) + " " + this.getPrivilegedObjectName(privilege, quoteIdentifiers, qualifyNames) + " " + "FROM" + " " + granteeType + " " + this.getName(privilege.getGrantee(), quoteIdentifiers);
        if (privilege.getObject() instanceof Routine) {
            ret = String.valueOf(ret) + " RESTRICT";
        }
        return ret;
    }

    public String[] updateStatistics(Table table, boolean quoteIdentifiers, boolean qualifyNames) {
        if (!(table instanceof IDatabaseObject)) {
            return null;
        }
        Collection stats = ((IDatabaseObject)table).getStatistics();
        if (stats.isEmpty()) {
            return null;
        }
        String whereClause = "WHERE TABNAME ='" + table.getName() + "'";
        if (qualifyNames) {
            whereClause = String.valueOf(whereClause) + " AND TABSCHEMA='" + table.getSchema().getName() + "'";
        }
        Collection statements = this.getAssignmentClause(stats, "SYSSTAT.TABLES", whereClause);
        return statements.toArray(new String[statements.size()]);
    }

    public String[] updateStatistics(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        if (!(column instanceof IDatabaseObject)) {
            return null;
        }
        Collection stats = ((IDatabaseObject)column).getStatistics();
        if (stats.isEmpty()) {
            return null;
        }
        String whereClause = "WHERE TABNAME ='" + column.getTable().getName() + "'" + " AND COLNAME = '" + column.getName() + "'";
        if (qualifyNames) {
            whereClause = String.valueOf(whereClause) + " AND TABSCHEMA='" + column.getTable().getSchema().getName() + "'";
        }
        Collection statements = this.getAssignmentClause(stats, "SYSSTAT.COLUMNS", whereClause);
        statements.addAll(this.getAssignmentClause(stats, "SYSSTAT.COLDIST", whereClause));
        return statements.toArray(new String[statements.size()]);
    }

    public String[] updateStatistics(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        if (!(index instanceof IDatabaseObject)) {
            return null;
        }
        Collection stats = ((IDatabaseObject)index).getStatistics();
        if (stats.isEmpty()) {
            return null;
        }
        String whereClause = "WHERE TABNAME ='" + index.getTable().getName() + "'" + " AND INDNAME = '" + index.getName() + "'";
        if (qualifyNames) {
            whereClause = String.valueOf(whereClause) + " AND TABSCHEMA='" + index.getTable().getSchema().getName() + "'";
        }
        Collection statements = this.getAssignmentClause(stats, "SYSSTAT.INDEXES", whereClause);
        return statements.toArray(new String[statements.size()]);
    }

    public String[] updateStatistics(Routine routine, boolean quoteIdentifiers, boolean qualifyNames) {
        if (!(routine instanceof IDatabaseObject)) {
            return null;
        }
        Collection stats = ((IDatabaseObject)routine).getStatistics();
        if (stats.isEmpty()) {
            return null;
        }
        String whereClause = "WHERE ROUTINENAME ='" + routine.getName() + "'";
        if (qualifyNames) {
            whereClause = String.valueOf(whereClause) + " AND ROUTINESCHEMA='" + routine.getSchema().getName() + "'";
        }
        Collection statements = this.getAssignmentClause(stats, "SYSSTAT.ROUTINES", whereClause);
        return statements.toArray(new String[statements.size()]);
    }

    public String setIntegrityForTableBeforeAlter(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        Table table = column.getTable();
        if (table instanceof BaseTable) {
            String statement = "SET INTEGRITY FOR " + this.getName(table, quoteIdentifiers, qualifyNames) + " OFF";
            return statement;
        }
        return null;
    }

    public String setIntegrityForTableAfterAlter(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        Table table = column.getTable();
        if (table instanceof BaseTable) {
            String statement = "SET INTEGRITY FOR " + this.getName(table, quoteIdentifiers, qualifyNames) + " IMMEDIATE CHECKED FORCE GENERATED";
            return statement;
        }
        return null;
    }

    private Collection getAssignmentClause(Collection stats, String syscatalog, String whereClause) {
        Vector<String> statVector = new Vector<String>();
        String statStr = "";
        for (CatalogStatistics stat : stats) {
            if (!stat.getSyscatalog().equals(syscatalog)) continue;
            if (stat.getType() == 6) {
                String statClause = this.getStatWhereClause(stat.getCollection(), syscatalog, whereClause);
                Collection statstrs = this.getAssignmentClause(stat.getCollection(), syscatalog, statClause);
                statVector.addAll(statstrs);
                continue;
            }
            if (statStr.length() > 0) {
                statStr = String.valueOf(statStr) + "," + NEWLINE + "\t" + "\t";
            }
            statStr = String.valueOf(statStr) + stat.getId() + "=" + stat.toString();
        }
        if (!statStr.equals("")) {
            statStr = "UPDATE " + syscatalog + " " + NEWLINE + "\t" + "SET" + " " + statStr + NEWLINE + "\t" + whereClause;
        }
        statVector.add(statStr);
        return statVector;
    }

    private String getStatWhereClause(Collection stats, String syscatalog, String whereClause) {
        String str = whereClause;
        if (syscatalog.equals("SYSSTAT.COLDIST")) {
            for (CatalogStatistics stat : stats) {
                String id = stat.getId();
                if (id.equals("TYPE")) {
                    str = String.valueOf(str) + NEWLINE + "\t" + "AND " + stat.getId() + "='" + stat.toString() + "'";
                    continue;
                }
                if (!id.equals("SEQNO")) continue;
                str = String.valueOf(str) + NEWLINE + "\t" + "AND " + stat.getId() + "=" + stat.toString();
            }
        }
        return str;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getIndexIncludedColumns(DB2Index index, boolean quoteIdentifiers) {
        Iterator it = index.getIncludedMembers().iterator();
        if (!it.hasNext()) {
            return null;
        }
        IndexMember m = (IndexMember)it.next();
        String columnName = m.getColumn().getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        String columns = columnName;
        while (it.hasNext()) {
            m = (IndexMember)it.next();
            columnName = m.getColumn().getName();
            if (quoteIdentifiers) {
                columnName = this.getDoubleQuotedString(columnName);
            }
            columns = String.valueOf(columns) + ", ";
            columns = String.valueOf(columns) + columnName;
        }
        return columns;
    }

    protected String getAlterTableAddColumnColumnString(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getColumnString(column, quoteIdentifiers, qualifyNames, true);
    }

    protected String getColumnString(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getColumnString(column, quoteIdentifiers, qualifyNames, false);
    }

    protected String getColumnString(Column column, boolean quoteIdentifiers, boolean qualifyNames, boolean isAddColumn) {
        LUWColumn db2Column = (LUWColumn)column;
        String columnName = column.getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        String columnString = String.valueOf(columnName) + " " + this.getDataTypeString((TypedElement)column, column.getTable().getSchema(), qualifyNames);
        String defaultValue = this.getDefaultValue(column);
        DB2IdentitySpecifier spec = (DB2IdentitySpecifier)db2Column.getIdentitySpecifier();
        if (!column.isNullable()) {
            columnString = String.valueOf(columnString) + " " + "NOT" + " " + "NULL";
        }
        String typeName = this.getDataTypeString((TypedElement)column, column.getTable().getSchema(), quoteIdentifiers, qualifyNames);
        if (spec == null && !typeName.equalsIgnoreCase("XML")) {
            if (defaultValue != null && !defaultValue.equals("")) {
                columnString = String.valueOf(columnString) + " " + "DEFAULT" + " " + defaultValue;
            } else if (isAddColumn && !column.isNullable()) {
                columnString = String.valueOf(columnString) + " " + "DEFAULT";
            }
        }
        if (typeName.indexOf("CLOB") != -1 || typeName.indexOf("BLOB") != -1) {
            columnString = String.valueOf(columnString) + this.getLOBLoggedClause(db2Column);
            if (db2Column.isLobCompacted()) {
                columnString = String.valueOf(columnString) + " COMPACT";
            }
        }
        ValueExpression v = db2Column.getGenerateExpression();
        if (spec != null) {
            GenerateType generateType = db2Column.getGenerationType();
            columnString = generateType == GenerateType.ALWAYS_LITERAL ? String.valueOf(columnString) + " GENERATED ALWAYS AS IDENTITY " : String.valueOf(columnString) + " GENERATED BY DEFAULT AS IDENTITY ";
            if (!spec.isSystemGenerated()) {
                columnString = String.valueOf(columnString) + "(" + this.getIdentityString(spec) + ")";
            }
        } else if (v != null) {
            if (v.getSQL() == null || v.getSQL().trim().length() == 0) {
                this.getEngineeringCallBack().writeMessage(MessageFormat.format(LUWDdlMessages.FE_GENERATED_COLUMN_HAS_NO_EXPRESSION, this.getName(column, false, true)));
            } else {
                String generationExpression = v.getSQL().trim();
                if (!generationExpression.startsWith("(") || !generationExpression.endsWith(")")) {
                    generationExpression = "(" + generationExpression + ")";
                }
                columnString = String.valueOf(columnString) + " GENERATED ALWAYS AS (" + generationExpression + ")";
            }
        } else if (typeName.equalsIgnoreCase("TIMESTAMP") && db2Column.isRowChangeTimestamp()) {
            GenerateType generateType = db2Column.getGenerationType();
            columnString = generateType == GenerateType.ALWAYS_LITERAL ? String.valueOf(columnString) + " GENERATED ALWAYS FOR EACH ROW ON UPDATE AS ROW CHANGE TIMESTAMP " : String.valueOf(columnString) + " GENERATED BY DEFAULT FOR EACH ROW ON UPDATE AS ROW CHANGE TIMESTAMP ";
        }
        return columnString;
    }

    protected String getLOBLoggedClause(LUWColumn db2Column) {
        if (!db2Column.isLobLogged()) {
            return NOT_LOGGED;
        }
        return this.getLOBLoggedClause(db2Column.getDataType());
    }

    protected String getLOBLoggedClause(LUWAttributeDefinition db2Attr) {
        if (!db2Attr.isLOBLogged()) {
            return NOT_LOGGED;
        }
        return this.getLOBLoggedClause(db2Attr.getDataType());
    }

    protected String getLOBLoggedClause(DataType dt) {
        int length = 0;
        if (SQLDataTypesPackage.eINSTANCE.getCharacterStringDataType().isSuperTypeOf(dt.eClass())) {
            CharacterStringDataType cdt = (CharacterStringDataType)dt;
            length = cdt.getLength();
            if (cdt.getPrimitiveType() == PrimitiveType.NATIONAL_CHARACTER_LARGE_OBJECT_LITERAL) {
                length *= 2;
            }
        } else if (SQLDataTypesPackage.eINSTANCE.getBinaryStringDataType().isSuperTypeOf(dt.eClass())) {
            length = ((BinaryStringDataType)dt).getLength();
        }
        if (length > 0x40000000) {
            return NOT_LOGGED;
        }
        return "";
    }

    private String getTablespaceString(LUWStorageTable table, boolean quoteIdentifiers) {
        LUWTableSpace tableSpace = table.getRegularDataTableSpace();
        String tablespaceClause = "";
        if (tableSpace != null) {
            String regularTableSpaceName = tableSpace.getName();
            if (quoteIdentifiers) {
                regularTableSpaceName = this.getDoubleQuotedString(regularTableSpaceName);
            }
            tablespaceClause = String.valueOf(NEWLINE) + "\tIN " + regularTableSpaceName;
        }
        if ((tableSpace = table.getIndexDataTableSpace()) != null) {
            String indexTableSpaceName = tableSpace.getName();
            if (quoteIdentifiers) {
                indexTableSpaceName = this.getDoubleQuotedString(indexTableSpaceName);
            }
            tablespaceClause = String.valueOf(tablespaceClause) + " INDEX IN " + indexTableSpaceName;
        }
        if ((tableSpace = table.getLOBDataTableSpace()) != null) {
            String lobTableSpaceName = tableSpace.getName();
            if (quoteIdentifiers) {
                lobTableSpaceName = this.getDoubleQuotedString(lobTableSpaceName);
            }
            tablespaceClause = String.valueOf(tablespaceClause) + " LONG IN " + lobTableSpaceName;
        }
        return tablespaceClause;
    }

    private boolean hasContainers(LUWTableSpace tablespace) {
        return !tablespace.getContainers().isEmpty();
    }

    private String getContainers(LUWTableSpace tablespace) {
        EList containers = tablespace.getContainers();
        if (containers.isEmpty()) {
            return null;
        }
        HashMap contMap = new HashMap();
        ArrayList<LUWDatabaseContainer> nopartn = null;
        for (Object cobj : tablespace.getContainers()) {
            LUWDatabaseContainer cont = (LUWDatabaseContainer)cobj;
            EList partns = cont.getPartitions();
            if (partns.isEmpty()) {
                if (nopartn == null) {
                    nopartn = new ArrayList<LUWDatabaseContainer>();
                    contMap.put(null, nopartn);
                }
                nopartn.add(cont);
                continue;
            }
            HashSet<Integer> cpartns = new HashSet<Integer>();
            for (Object pobj : partns) {
                LUWDatabasePartition partn = (LUWDatabasePartition)pobj;
                cpartns.add(new Integer(partn.getNumber()));
            }
            List<LUWDatabaseContainer> clist = null;
            for (Set s : contMap.keySet()) {
                if (s.size() != cpartns.size() || !s.containsAll(cpartns)) continue;
                clist = (List)contMap.get(s);
                break;
            }
            if (clist == null) {
                clist = new ArrayList<LUWDatabaseContainer>();
                contMap.put(cpartns, clist);
            }
            clist.add(cont);
        }
        StringBuilder txt = new StringBuilder();
        boolean database_managed = tablespace.getManagementType() == ManagementType.DATABASE_MANAGED_LITERAL;
        for (Map.Entry entry : contMap.entrySet()) {
            txt.append(String.valueOf(NEWLINE) + "\t" + "USING (");
            boolean first = true;
            for (LUWDatabaseContainer container : (List)entry.getValue()) {
                if (!first) {
                    txt.append(", ");
                } else {
                    first = false;
                }
                LUWContainerType type = container.getContainerType();
                if (database_managed) {
                    if (type == LUWContainerType.DEVICE_LITERAL) {
                        txt.append("DEVICE ");
                    } else if (type == LUWContainerType.FILE_LITERAL) {
                        txt.append("FILE ");
                    }
                }
                txt.append(this.getSingleQuotedString(container.getName()));
                if (!database_managed) continue;
                if (container.getSizeInPages() > 0) {
                    txt.append(" " + container.getSizeInPages());
                    continue;
                }
                txt.append(" " + container.getSize());
                txt.append(" " + container.getSizeUnits().getName());
            }
            txt.append(")");
            Set partnums = (Set)entry.getKey();
            if (partnums == null || partnums.isEmpty()) continue;
            txt.append(" ON DBPARTITIONNUM (");
            boolean first2 = true;
            for (Integer partnum : partnums) {
                if (!first2) {
                    txt.append(", ");
                } else {
                    first2 = false;
                }
                txt.append(partnum);
            }
            txt.append(")");
        }
        return txt.toString();
    }

    protected String getOwnerType(TableConstraint constraint) {
        BaseTable table = constraint.getBaseTable();
        if (table instanceof LUWNickname) {
            return "NICKNAME";
        }
        return "TABLE";
    }

    protected String getPartitionKey(LUWStorageTable table, boolean quoteIdentifiers) {
        LUWPartitionKey partitionKey = table.getPartitionKey();
        if (partitionKey == null) {
            return "";
        }
        if (partitionKey.getColumns().size() < 1) {
            return "";
        }
        String statement = String.valueOf(NEWLINE) + "\t";
        statement = String.valueOf(statement) + this.getPartitionKeyDefinition(partitionKey, quoteIdentifiers);
        return statement;
    }

    private String getPartitionKeyDefinition(LUWPartitionKey partitionKey, boolean quoteIdentifiers) {
        String definition = "PARTITIONING KEY(";
        Iterator it = partitionKey.getColumns().iterator();
        while (it.hasNext()) {
            String columnName = ((Column)it.next()).getName();
            if (quoteIdentifiers) {
                columnName = this.getDoubleQuotedString(columnName);
            }
            definition = String.valueOf(definition) + columnName;
            if (!it.hasNext()) continue;
            definition = String.valueOf(definition) + ", ";
        }
        definition = String.valueOf(definition) + ")";
        if (partitionKey.getPartitionMethod() == PartitionMethod.get(0)) {
            definition = String.valueOf(definition) + " USING HASHING";
        }
        return definition;
    }

    protected String getDataTypeString(TypedElement typedElement, Schema schema, boolean qualifyNames) {
        String type = null;
        if (this.generator != null && EngineeringOptionID.useDomain((EngineeringOption[])this.generator.getSelectedOptions())) {
            type = this.getDomainTypeString(typedElement, schema, qualifyNames);
        }
        if (type == null) {
            type = super.getDataTypeString(typedElement, schema, qualifyNames);
        }
        return type;
    }

    protected String getDataTypeString(TypedElement typedElement, Schema schema, boolean quoteIdentifiers, boolean qualifyNames) {
        String type = null;
        if (this.generator != null && EngineeringOptionID.useDomain((EngineeringOption[])this.generator.getSelectedOptions())) {
            type = this.getDomainTypeString(typedElement, schema, qualifyNames);
        }
        if (type == null) {
            type = super.getDataTypeString(typedElement, schema, quoteIdentifiers, qualifyNames);
        }
        return type;
    }

    protected String getName(LUWWrapper wrapper, boolean quoteIdentifiers) {
        String name = wrapper.getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
        }
        return name;
    }

    protected String getName(LUWServer server, boolean quoteIdentifiers) {
        String name = server.getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
        }
        return name;
    }

    protected String getName(LUWUserMapping userMapping, boolean quoteIdentifiers) {
        String name = userMapping.getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
        }
        return name;
    }

    protected String getName(LUWTableSpace tablespace, boolean quoteIdentifiers) {
        String name = tablespace.getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
        }
        return name;
    }

    protected String getName(LUWDatabasePackage pkg, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = pkg.getName();
        String schemaName = pkg.getSchema().getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            name = String.valueOf(schemaName) + "." + name;
        }
        return name;
    }

    protected String getName(LUWGlobalVariable variable, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = variable.getName();
        String schemaName = variable.getSchema().getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            name = String.valueOf(schemaName) + "." + name;
        }
        return name;
    }

    protected String getName(LUWModule module, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = module.getName();
        String schemaName = module.getOwningSchema().getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            name = String.valueOf(schemaName) + "." + name;
        }
        return name;
    }

    protected String getIdentityString(DB2IdentitySpecifier identitySpecifier) {
        StringBuffer sb = new StringBuffer();
        if (identitySpecifier.getStartValue() != null) {
            sb.append(" START WITH " + identitySpecifier.getStartValue());
        }
        if (identitySpecifier.getIncrement() != null) {
            sb.append(" INCREMENT BY " + identitySpecifier.getIncrement());
        }
        if (identitySpecifier.getMinimum() != null) {
            sb.append(" MINVALUE " + identitySpecifier.getMinimum());
        }
        if (identitySpecifier.getMaximum() != null) {
            sb.append(" MAXVALUE " + identitySpecifier.getMaximum());
        }
        if (identitySpecifier.isCycleOption()) {
            sb.append(" CYCLE");
        } else {
            sb.append(" NO CYCLE");
        }
        if (identitySpecifier.getCache() > 1) {
            sb.append(" CACHE " + identitySpecifier.getCache());
        } else {
            sb.append(" NO CACHE");
        }
        return sb.toString();
    }

    protected String getIdentityAlterationString(DB2IdentitySpecifier identitySpecifier) {
        StringBuffer sb = new StringBuffer();
        if (identitySpecifier.getStartValue() != null) {
            sb.append(" RESTART WITH " + identitySpecifier.getStartValue());
        }
        if (identitySpecifier.getIncrement() != null) {
            sb.append(" SET INCREMENT BY " + identitySpecifier.getIncrement());
        }
        if (identitySpecifier.getMinimum() != null) {
            sb.append(" SET MINVALUE " + identitySpecifier.getMinimum());
        }
        if (identitySpecifier.getMaximum() != null) {
            sb.append(" SET MAXVALUE " + identitySpecifier.getMaximum());
        }
        if (identitySpecifier.isCycleOption()) {
            sb.append(" SET CYCLE");
        } else {
            sb.append(" SET NO CYCLE");
        }
        if (identitySpecifier.getCache() > 1) {
            sb.append(" SET CACHE " + identitySpecifier.getCache());
        } else {
            sb.append(" SET NO CACHE");
        }
        return sb.toString();
    }

    protected String getTableDimension(LUWTable table, boolean quotedIdentifier) {
        String text = "";
        for (DB2Index index : table.getIndex()) {
            if (index.getIndexType() != DB2IndexType.DIMENSION_LITERAL) continue;
            String dimensionPart = this.getParentKeyColumns((Index)index, quotedIdentifier);
            if (!text.equals("")) {
                text = String.valueOf(text) + ",  ";
            }
            text = String.valueOf(text) + dimensionPart;
        }
        if (!text.equals("")) {
            text = String.valueOf(NEWLINE) + "\t" + DIMENSION_BY + " " + "(" + text + ")";
        }
        return text;
    }

    protected String getDefaultValue(Column column) {
        String defaultValue = column.getDefaultValue();
        if (defaultValue == null || defaultValue.equals("")) {
            return null;
        }
        SQLDataType type = column.getContainedType();
        if (type == null) {
            return null;
        }
        if (!((!(type instanceof CharacterStringDataType) || defaultValue.equalsIgnoreCase("USER") || defaultValue.equalsIgnoreCase("CURRENT USER") || defaultValue.equalsIgnoreCase("CURRENT_USER") || defaultValue.equalsIgnoreCase("SESSION_USER") || defaultValue.equalsIgnoreCase("SESSION USER") || defaultValue.equalsIgnoreCase("SYSTEM_USER") || defaultValue.equalsIgnoreCase("NULL")) && (!(type instanceof DateDataType) && !(type instanceof TimeDataType) || defaultValue.equals("NULL") || defaultValue.toUpperCase().matches(".*SYSDATE.*") || defaultValue.toUpperCase().matches(".*CURRENT DATE.*") || defaultValue.toUpperCase().matches(".*CURRENT_DATE.*") || defaultValue.toUpperCase().matches(".*CURRENT TIME.*") || defaultValue.toUpperCase().matches(".*CURRENT_TIME.*") || defaultValue.toUpperCase().matches(".*CURRENT TIMESTAMP.*") || defaultValue.toUpperCase().matches(".*CURRENT_TIMESTAMP.*")))) {
            return this.ensureSingleQuotedString(defaultValue);
        }
        if (!(!(type instanceof BinaryStringDataType) || defaultValue.equalsIgnoreCase("NULL") || defaultValue.startsWith("X'") && defaultValue.endsWith("'"))) {
            return HEX_LITERAL_PREFIX + this.getSingleQuotedString(defaultValue);
        }
        return defaultValue;
    }

    protected String getCompressionValue(LUWStorageTable table) {
        StringBuffer text = new StringBuffer();
        if (table.isValueCompression()) {
            text.append(NEWLINE).append("\t").append(VALUE_COMPRESSION);
        }
        return text.toString();
    }

    protected boolean isTablespaceContainersRequried(LUWTableSpace tablespace) {
        return true;
    }

    protected String getPrivilegedObjectName(Privilege privilege, boolean quoteIdentifiers, boolean qualifyNames) {
        SQLObject obj = privilege.getObject();
        String name = null;
        if (obj instanceof Table) {
            name = this.getName((Table)obj, quoteIdentifiers, qualifyNames);
        } else if (obj instanceof Index) {
            name = this.getName((Index)obj, quoteIdentifiers, qualifyNames);
        } else if (obj instanceof Sequence) {
            name = this.getName((Sequence)obj, quoteIdentifiers, qualifyNames);
        } else if (obj instanceof Schema) {
            name = this.getName((Schema)obj, quoteIdentifiers, qualifyNames);
        } else if (obj instanceof LUWModule) {
            name = this.getName((LUWModule)obj, quoteIdentifiers, qualifyNames);
        } else if (obj instanceof LUWGlobalVariable) {
            name = this.getName((LUWGlobalVariable)obj, quoteIdentifiers, qualifyNames);
        } else if (obj instanceof Routine) {
            name = this.getRoutineSpecifier(obj, quoteIdentifiers, qualifyNames);
        } else if (obj instanceof UserDefinedType) {
            name = this.getName((UserDefinedType)obj, quoteIdentifiers, qualifyNames);
        } else if (obj instanceof LUWTableSpace) {
            name = this.getName((LUWTableSpace)obj, quoteIdentifiers);
        } else if (obj instanceof LUWDatabasePackage) {
            name = this.getName((LUWDatabasePackage)obj, quoteIdentifiers, qualifyNames);
        } else if (obj instanceof Database) {
            name = "";
        }
        return name;
    }

    protected String getPrivilegedObjectTypeString(Privilege privilege) {
        SQLObject obj = privilege.getObject();
        if (obj instanceof BaseTable) {
            return "TABLE";
        }
        if (obj instanceof Method) {
            return "METHOD";
        }
        if (obj instanceof Function) {
            return "FUNCTION";
        }
        if (obj instanceof Procedure) {
            return "PROCEDURE";
        }
        if (obj instanceof ViewTable) {
            return "TABLE";
        }
        if (obj instanceof Index) {
            return "INDEX";
        }
        if (obj instanceof Schema) {
            return "SCHEMA";
        }
        if (obj instanceof Sequence) {
            return "SEQUENCE";
        }
        if (obj instanceof Database) {
            return "DATABASE";
        }
        if (obj instanceof DB2Package) {
            return "PACKAGE";
        }
        if (obj instanceof LUWTableSpace) {
            return "TABLESPACE";
        }
        if (obj instanceof LUWModule) {
            return MODULE;
        }
        if (obj instanceof LUWGlobalVariable) {
            return VARIABLE;
        }
        return "";
    }

    protected String getGrantRoleAuthorizationString(RoleAuthorization roleAuth, boolean quoteIdentifiers) {
        AuthorizationIdentifier grantee = roleAuth.getGrantee();
        String authStr = String.valueOf(NEWLINE) + "GRANT" + " " + this.getName((AuthorizationIdentifier)roleAuth.getRole(), quoteIdentifiers) + " " + "TO" + this.getGranteeType(grantee) + " " + this.getName(roleAuth.getGrantee(), quoteIdentifiers);
        if (roleAuth.isGrantable()) {
            authStr = String.valueOf(authStr) + " WITH ADMIN OPTION";
        }
        return authStr;
    }

    protected String getAlterTableAlterValueCompressionString(LUWTable table) {
        String compressionStr = String.valueOf(NEWLINE) + "\t";
        compressionStr = table.isValueCompression() ? String.valueOf(compressionStr) + "ACTIVATE" : String.valueOf(compressionStr) + "DEACTIVATE";
        compressionStr = String.valueOf(compressionStr) + " VALUE COMPRESSION";
        return compressionStr;
    }

    protected String getAlterTableAlterVolatileString(LUWTable table) {
        if (table instanceof LUWTable) {
            String volatileStr = String.valueOf(NEWLINE) + "\t";
            if (table.isVolatile()) {
                return String.valueOf(volatileStr) + "VOLATILE";
            }
            return String.valueOf(volatileStr) + "NOT VOLATILE";
        }
        return "";
    }

    protected String getAlterTableAlterRowCompressionString(LUWTable table) {
        if (table instanceof LUWStorageTable) {
            String compressionStr = String.valueOf(NEWLINE) + "\t";
            if (table.isRowCompression()) {
                return String.valueOf(compressionStr) + "COMPRESS YES";
            }
            return String.valueOf(compressionStr) + "COMPRESS NO";
        }
        return "";
    }

    public String alterTableAddColumn(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        DB2IdentitySpecifier spec = (DB2IdentitySpecifier)column.getIdentitySpecifier();
        if (spec != null) {
            this.getEngineeringCallBack().writeMessage(MessageFormat.format(LUWDdlMessages.FE_ALTER_TABLE_ADD_COLUMN_IDENTITY_OPTIONS, this.getName(column, false, true)));
        }
        return super.alterTableAddColumn(column, quoteIdentifiers, qualifyNames);
    }

    public String alterTableDropColumn(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        Table table = (Table)ContainmentServiceImpl.INSTANCE.getContainer((EObject)column);
        if (table != null && table instanceof BaseTable) {
            String statement = "ALTER TABLE " + this.getName(table, quoteIdentifiers, qualifyNames) + " DROP COLUMN " + this.getColumnNameString(column, quoteIdentifiers, qualifyNames);
            return statement;
        }
        return null;
    }

    protected String getDistributeKeyword() {
        return PARTITION_KEY;
    }

    protected String getBufferPoolSize(LUWBufferPool bufferpool) {
        String text = null;
        int size = bufferpool.getSize();
        if (size <= 0) {
            this.getEngineeringCallBack().writeMessage(MessageFormat.format(LUWDdlMessages.FE_BUFFERPOOL_INVAILD_SIZE_VALUE, bufferpool.getName()));
            return null;
        }
        text = " SIZE " + bufferpool.getSize();
        return text;
    }

    public String reorgTable(Column col, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.reorgTable(col.getTable(), quoteIdentifiers, qualifyNames);
    }

    public String reorgTable(Table table, boolean quoteIdentifiers, boolean qualifyNames) {
        String tableName = table.getName();
        String schemaName = table.getSchema().getName();
        if (quoteIdentifiers) {
            tableName = this.getDoubleQuotedString(tableName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            tableName = String.valueOf(schemaName) + "." + tableName;
        }
        return "CALL SYSPROC.ADMIN_CMD('REORG TABLE " + tableName + "'" + ")";
    }

    public String getName(LUWPartitionGroup pg, boolean quoteIdentifiers) {
        String pgName = pg.getName();
        if (quoteIdentifiers) {
            pgName = this.getDoubleQuotedString(pgName);
        }
        return pgName;
    }

    protected String getGranteeType(AuthorizationIdentifier authID) {
        if (authID instanceof Group) {
            return " GROUP";
        }
        if (authID instanceof Role) {
            return " ROLE";
        }
        if (authID instanceof User) {
            return " USER";
        }
        return "";
    }

    public String[] grantOn(LUWDatabasePackage dbPackage, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getGrantString((SQLObject)dbPackage, quoteIdentifiers, qualifyNames);
    }

    public String[] grantOn(LUWModule module, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getGrantString(module, quoteIdentifiers, qualifyNames);
    }

    public String[] grantOn(LUWGlobalVariable variable, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.getGrantString((SQLObject)variable, quoteIdentifiers, qualifyNames);
    }

    private String createModuleObject(LUWModuleObject moduleObject, boolean quoteIdentifiers, boolean qualifyNames) {
        ILUWModuleDdlBuilder moduleBuilder = LUWDdlGenerator.getModuleDdlBuilder();
        if (moduleBuilder != null) {
            return moduleBuilder.buildCreateStatement((SQLObject)moduleObject, quoteIdentifiers, qualifyNames);
        }
        return null;
    }

    private String dropModuleObject(LUWModuleObject moduleObject, boolean quoteIdentifiers, boolean qualifyNames) {
        ILUWModuleDdlBuilder moduleBuilder = LUWDdlGenerator.getModuleDdlBuilder();
        if (moduleBuilder != null) {
            return moduleBuilder.buildDropStatement((SQLObject)moduleObject, quoteIdentifiers, qualifyNames);
        }
        return null;
    }

    private String commentOnModuleObject(LUWModuleObject moduleObject, boolean quoteIdentifiers, boolean qualifyNames) {
        ILUWModuleDdlBuilder moduleBuilder = LUWDdlGenerator.getModuleDdlBuilder();
        if (moduleBuilder != null) {
            return moduleBuilder.buildCommentStatement((SQLObject)moduleObject, quoteIdentifiers, qualifyNames);
        }
        return null;
    }

    protected String getName(UserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        String typeName;
        boolean isModuleObject = type instanceof LUWModuleObject;
        String string = typeName = quoteIdentifiers ? this.getDoubleQuotedString(type.getName()) : type.getName();
        if (isModuleObject) {
            String moduleName = quoteIdentifiers ? this.getDoubleQuotedString(((LUWModuleObject)type).getModule().getName()) : ((LUWModuleObject)type).getModule().getName();
            String schemaName = quoteIdentifiers ? this.getDoubleQuotedString(((LUWModuleObject)type).getModule().getOwningSchema().getName()) : ((LUWModuleObject)type).getModule().getOwningSchema().getName();
            typeName = String.valueOf(moduleName) + "." + typeName;
            if (qualifyNames) {
                typeName = String.valueOf(schemaName) + "." + typeName;
            }
        } else {
            String schemaName;
            String string2 = schemaName = quoteIdentifiers ? this.getDoubleQuotedString(type.getSchema().getName()) : type.getSchema().getName();
            if (qualifyNames) {
                typeName = String.valueOf(schemaName) + "." + typeName;
            }
        }
        return typeName;
    }

    protected String RecoverDroppedTableString(LUWTableSpace tablespace) {
        String text = "";
        if (tablespace.getTablespaceType() == TableSpaceType.REGULAR_LITERAL && !tablespace.isRecoverDroppedTableOn()) {
            text = String.valueOf(text) + NEWLINE + "\t" + "DROPPED TABLE RECOVERY " + OFF;
        }
        return text;
    }

    private String getName(String oldname, boolean quoteIdentifiers) {
        if (quoteIdentifiers) {
            oldname = this.getDoubleQuotedString(oldname);
        }
        return oldname;
    }

    public String alterTablespaceRename(LUWTableSpace tablespace, String oldname, boolean quoteIdentifiers, boolean qualifyNames) {
        return "RENAME TABLESPACE " + this.getName(oldname, quoteIdentifiers) + " " + "TO" + " " + this.getName(tablespace, quoteIdentifiers);
    }

    public String alterTablespaceProlog(LUWTableSpace tablespace, boolean quoteIdentifiers, boolean qualifyNames) {
        String tablespaceName = tablespace.getName();
        if (quoteIdentifiers) {
            tablespaceName = this.getDoubleQuotedString(tablespaceName);
        }
        return "ALTER TABLESPACE " + tablespaceName;
    }

    public String alterTablespaceContainers(LUWTableSpace tablespace, EList newContainers, EList oldContainers, boolean quoteIdentifiers, boolean qualifyNames) {
        String text = "";
        boolean first = true;
        block0: for (LUWDatabaseContainer container : newContainers) {
            String newName = container.getName();
            LUWContainerType newType = container.getContainerType();
            for (LUWDatabaseContainer oldContainer : oldContainers) {
                if (oldContainer.getName().equals(newName) && ((Object)((Object)oldContainer.getContainerType())).equals((Object)newType)) continue block0;
            }
            text = first ? String.valueOf(text) + NEWLINE + "\t" + "ADD" + " " + "(" : String.valueOf(text) + ",";
            if (((Object)((Object)LUWContainerType.DEVICE_LITERAL)).equals((Object)newType)) {
                text = String.valueOf(text) + "DEVICE ";
            } else if (((Object)((Object)LUWContainerType.FILE_LITERAL)).equals((Object)newType)) {
                text = String.valueOf(text) + "FILE ";
            }
            text = String.valueOf(text) + this.getSingleQuotedString(newName);
            if (container.getSizeInPages() > 0) {
                text = String.valueOf(text) + " " + container.getSizeInPages();
            } else {
                text = String.valueOf(text) + " " + container.getSize();
                text = String.valueOf(text) + " " + container.getSizeUnits().getName();
            }
            first = false;
        }
        if (!first) {
            text = String.valueOf(text) + ")";
        }
        first = true;
        block2: for (LUWDatabaseContainer container : oldContainers) {
            String oldName = container.getName();
            LUWContainerType oldType = container.getContainerType();
            for (LUWDatabaseContainer newContainer : newContainers) {
                if (newContainer.getName().equals(oldName) && ((Object)((Object)newContainer.getContainerType())).equals((Object)oldType)) continue block2;
            }
            text = first ? String.valueOf(text) + NEWLINE + "\t" + "DROP" + " " + "(" : String.valueOf(text) + ",";
            if (((Object)((Object)LUWContainerType.DEVICE_LITERAL)).equals((Object)oldType)) {
                text = String.valueOf(text) + "DEVICE ";
            } else if (((Object)((Object)LUWContainerType.FILE_LITERAL)).equals((Object)oldType)) {
                text = String.valueOf(text) + "FILE ";
            }
            text = String.valueOf(text) + this.getSingleQuotedString(oldName);
            first = false;
        }
        if (!first) {
            text = String.valueOf(text) + ")";
        }
        return text;
    }

    public String alterTablespaceContainersSize(LUWTableSpace tablespace, EList newContainers, EList oldContainers, boolean quoteIdentifiers, boolean qualifyNames, LUWDeltaDdlGenerator delta) {
        String text = "";
        boolean first = true;
        for (LUWDatabaseContainer container : newContainers) {
            String newName = container.getName();
            LUWContainerType newType = container.getContainerType();
            for (LUWDatabaseContainer oldContainer : oldContainers) {
                if (!oldContainer.getName().equals(newName) || !((Object)((Object)oldContainer.getContainerType())).equals((Object)newType) || ((Object)((Object)newType)).equals((Object)LUWContainerType.DIRECTORY_LITERAL)) continue;
                EAttribute feature = LUWPackage.eINSTANCE.getLUWDatabaseContainer_SizeInPages();
                int oldSizeInPages = (Integer)delta.getOldContainerValue((EStructuralFeature)feature, container);
                feature = LUWPackage.eINSTANCE.getLUWDatabaseContainer_Size();
                int oldSize = (Integer)delta.getOldContainerValue((EStructuralFeature)feature, container);
                feature = LUWPackage.eINSTANCE.getLUWDatabaseContainer_SizeUnits();
                UnitType oldSizeUnits = (UnitType)delta.getOldContainerValue((EStructuralFeature)feature, container);
                if (oldSizeInPages == container.getSizeInPages() && oldSize == container.getSize() && oldSizeUnits.equals(container.getSizeUnits())) continue;
                text = first ? String.valueOf(text) + NEWLINE + "\t" + RESIZE + " " + "(" : String.valueOf(text) + ",";
                if (((Object)((Object)LUWContainerType.DEVICE_LITERAL)).equals((Object)newType)) {
                    text = String.valueOf(text) + "DEVICE ";
                } else if (((Object)((Object)LUWContainerType.FILE_LITERAL)).equals((Object)newType)) {
                    text = String.valueOf(text) + "FILE ";
                }
                text = String.valueOf(text) + this.getSingleQuotedString(newName);
                if (container.getSizeInPages() > 0 && oldSizeInPages != container.getSizeInPages()) {
                    text = String.valueOf(text) + " " + container.getSizeInPages();
                } else {
                    text = String.valueOf(text) + " " + container.getSize();
                    text = String.valueOf(text) + " " + container.getSizeUnits().getName();
                }
                first = false;
            }
        }
        if (!first) {
            text = String.valueOf(text) + ")";
        }
        return text;
    }

    public String tablespaceBufferPoolClause(LUWTableSpace tablespace, boolean quoteIdentifiers) {
        LUWBufferPool bufferpool = tablespace.getBufferPool();
        if (bufferpool != null) {
            String bufferpoolName = bufferpool.getName();
            if (quoteIdentifiers) {
                bufferpoolName = this.getDoubleQuotedString(bufferpoolName);
            }
            return String.valueOf(NEWLINE) + "\t" + BUFFERPOOL + " " + bufferpoolName;
        }
        return "";
    }

    public String tablespaceOverheadClause(LUWTableSpace tablespace) {
        return String.valueOf(NEWLINE) + "\t" + OVERHEAD + " " + String.valueOf(tablespace.getOverhead());
    }

    public String tablespaceXferRateClause(LUWTableSpace tablespace) {
        return String.valueOf(NEWLINE) + "\t" + XFER_RATE + " " + String.valueOf(tablespace.getTransferRate());
    }

    public String tablespaceDroppedTableRecoveryClause(LUWTableSpace tablespace) {
        return String.valueOf(NEWLINE) + "\t" + DROPPED_TABLE_RECOVERY + " " + (tablespace.isRecoverDroppedTableOn() ? "ON" : OFF);
    }

    public String tablespaceAutoResizeClause(LUWTableSpace tablespace) {
        return "";
    }

    public String tablespaceIncreaseSizeClause(LUWTableSpace tablespace) {
        return "";
    }

    public String tablespaceMaxSizeClause(LUWTableSpace tablespace) {
        return "";
    }

    public String tablespacePrefetchSizeClause(LUWTableSpace tablespace) {
        int prefetchsize = tablespace.getPreFetchSize();
        return String.valueOf(NEWLINE) + "\t" + PREFETCHSIZE + " " + (prefetchsize > 0 ? String.valueOf(prefetchsize) : AUTOMATIC);
    }

    public String transferSchemaOwnership(Schema changed, boolean quoteIdentifiers) {
        AuthorizationIdentifier auth = changed.getOwner();
        if (auth != null) {
            return "TRANSFER OWNERSHIP OF SCHEMA " + this.getName(changed.getName(), quoteIdentifiers) + " " + "TO" + " " + "USER" + " " + this.getName(auth, quoteIdentifiers) + " " + PRESERVE_PRIVILEGES;
        }
        return null;
    }
}

