/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.utils;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadPoolFactory
implements ThreadFactory {
    private ConcurrentHashMap<String, AtomicInteger> counters = new ConcurrentHashMap();
    private final String name;

    public DaemonThreadPoolFactory(Class<?> parentClass) {
        this.name = "Hector." + parentClass.getName();
    }

    private int getNextThreadNumber() {
        if (!this.counters.containsKey(this.name)) {
            this.counters.putIfAbsent(this.name, new AtomicInteger());
        }
        return this.counters.get(this.name).incrementAndGet();
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName(this.name + "-" + this.getNextThreadNumber());
        return t;
    }
}

