/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline.providers;

import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;

public class ListBandProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        if (!(object instanceof SlotHandle)) {
            return;
        }
        SlotHandle model = (SlotHandle)object;
        if (model.getElementHandle() instanceof ListHandle && model.getSlotID() == 1) {
            InsertAction insertAction = new InsertAction(object, Messages.getString((String)"ListBandProvider.action.text"), "ListGroup");
            menu.add((IAction)insertAction);
        } else {
            menu.add((IAction)new InsertAction(object));
        }
        super.createContextMenu(sourceViewer, object, menu);
    }

    public String getNodeDisplayName(Object object) {
        SlotHandle model = (SlotHandle)object;
        if (model.getElementHandle() instanceof ListHandle) {
            switch (model.getSlotID()) {
                case 0: {
                    return HEADER_DISPALYNAME;
                }
                case 3: {
                    return FOOTER_DISPALYNAME;
                }
                case 2: {
                    return DETAIL_DISPALYNAME;
                }
                case 1: {
                    return GROUPS_DISPALYNAME;
                }
            }
        } else if (model.getElementHandle() instanceof ListGroupHandle) {
            switch (model.getSlotID()) {
                case 0: {
                    return HEADER_DISPALYNAME;
                }
                case 1: {
                    return FOOTER_DISPALYNAME;
                }
            }
        }
        return super.getNodeDisplayName((Object)model);
    }

    public String getIconName(Object object) {
        SlotHandle model = (SlotHandle)object;
        if (model.getElementHandle() instanceof ListHandle) {
            switch (model.getSlotID()) {
                case 0: {
                    return "Header";
                }
                case 3: {
                    return "Footer";
                }
                case 2: {
                    return "Details";
                }
                case 1: {
                    return "Groups";
                }
            }
        } else if (model.getElementHandle() instanceof ListGroupHandle) {
            switch (model.getSlotID()) {
                case 0: {
                    return "Group Header";
                }
                case 1: {
                    return "Group Footer";
                }
            }
        }
        return super.getIconName((Object)model);
    }

    protected boolean performInsert(Object model, SlotHandle slotHandle, String type, String position, Map extendData) throws Exception {
        if ("ListGroup".equals(type)) {
            return UIUtil.createGroup((DesignElementHandle)((SlotHandle)model).getElementHandle());
        }
        return super.performInsert(model, slotHandle, type, position, extendData);
    }
}

