/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.timeFunction.DateTimeUtility;
import org.eclipse.birt.report.data.adapter.group.ICalculator;
import org.eclipse.birt.report.data.adapter.i18n.AdapterResourceHandle;
import org.eclipse.birt.report.data.adapter.impl.DataRequestSessionImpl;
import org.eclipse.birt.report.data.adapter.impl.SecurityListener;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class DataSetIterator
implements IDatasetIterator {
    static final String DATE_TIME_ATTR_NAME = "DateTime";
    private boolean started = false;
    private IResultIterator it;
    private ResultMeta metadata;
    private Calendar calendar;
    private Calendar defaultCalendar;
    private SecurityListener securityListener;
    private long nullTime;
    private String dimName;
    private IQueryResults queryResult;

    private void executeQuery(DataRequestSessionImpl session, IQueryDefinition query, Map appContext) throws AdapterException {
        try {
            Scriptable scope = session.getScope();
            TempDateTransformer tt = new TempDateTransformer(session.getDataSessionContext().getDataEngineContext().getLocale());
            ScriptableObject.putProperty((Scriptable)scope, (String)tt.getClassName(), (Object)((Object)tt));
            this.queryResult = session.prepare(query, appContext).execute(scope);
            this.it = this.queryResult.getResultIterator();
        }
        catch (BirtException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    public DataSetIterator(DataRequestSessionImpl session, IQueryDefinition query, List<ColumnMeta> meta, Map appContext) throws BirtException {
        this.defaultCalendar = Calendar.getInstance((ULocale)session.getDataSessionContext().getDataEngineContext().getLocale());
        this.defaultCalendar.setTimeZone(TimeZone.getDefault());
        this.defaultCalendar.clear();
        this.calendar = Calendar.getInstance((ULocale)session.getDataSessionContext().getDataEngineContext().getLocale());
        this.calendar.setTimeZone(session.getDataSessionContext().getDataEngineContext().getTimeZone());
        this.calendar.clear();
        this.calendar.set(0, 0, 1, 0, 0, 0);
        this.nullTime = this.calendar.getTimeInMillis();
        this.calendar.clear();
        this.executeQuery(session, query, appContext);
        this.metadata = new ResultMeta(meta);
    }

    public static String createLevelACLName(String levelName) {
        return "_$ACL$_" + levelName;
    }

    public void initSecurityListenerAndDimension(String dimName, SecurityListener listener) {
        this.securityListener = listener;
        this.dimName = dimName;
    }

    static int getDefaultStartValue(String timeType, String value) throws AdapterException {
        if (value != null && Double.parseDouble(value) != 0.0) {
            return Integer.parseInt(value);
        }
        if ("day-of-month".equals(timeType)) {
            return 1;
        }
        if ("day-of-week".equals(timeType)) {
            return 1;
        }
        if ("day-of-year".equals(timeType)) {
            return 1;
        }
        if ("week-of-month".equals(timeType)) {
            return 1;
        }
        if ("week-of-year".equals(timeType)) {
            return 1;
        }
        if ("month".equals(timeType)) {
            return 1;
        }
        if ("quarter".equals(timeType)) {
            return 1;
        }
        if ("year".equals(timeType)) {
            return 1;
        }
        if ("hour".equals(timeType)) {
            return 0;
        }
        if ("minute".equals(timeType)) {
            return 0;
        }
        if ("second".equals(timeType)) {
            return 0;
        }
        throw new AdapterException("Error");
    }

    static String createLevelName(String dimName, String levelName) {
        if (dimName != null) {
            return String.valueOf(dimName) + "/" + levelName;
        }
        return levelName;
    }

    public void close() throws BirtException {
        if (this.queryResult != null) {
            this.queryResult.close();
        }
        if (this.it != null) {
            this.it.close();
        }
    }

    public int getFieldIndex(String name) throws BirtException {
        return this.metadata.getFieldIndex(name);
    }

    public int getFieldType(String name) throws BirtException {
        return this.metadata.getFieldType(name);
    }

    public Object getValue(int fieldIndex) throws BirtException {
        Object value = this.it.getValue(this.metadata.getFieldName(fieldIndex));
        if (value == null) {
            return this.metadata.getNullValueReplacer(fieldIndex);
        }
        if (byte[].class.equals(value.getClass())) {
            return value;
        }
        Object convertedValue = this.metadata.getDataProcessor(fieldIndex).process(value);
        return convertedValue.getClass().isAssignableFrom(value.getClass()) ? convertedValue : DataTypeUtil.convert((Object)convertedValue, value.getClass());
    }

    public boolean next() throws BirtException {
        boolean hasNext = false;
        if (this.it.getQueryResults().getPreparedQuery().getReportQueryDefn().getGroups().size() == 0) {
            hasNext = this.it.next();
        } else if (!this.started) {
            this.started = true;
            hasNext = this.it.next();
        } else {
            this.it.skipToEnd(this.it.getQueryResults().getPreparedQuery().getReportQueryDefn().getGroups().size());
            hasNext = this.it.next();
        }
        if (!hasNext) {
            this.it.close();
        } else if (this.securityListener != null) {
            this.securityListener.process(this.dimName, this);
        }
        return hasNext;
    }

    public int getSummaryInt(String bindingName) throws BirtException {
        return this.it.getInteger(bindingName);
    }

    private Calendar getCalendar(Object d) {
        assert (d != null);
        if (d instanceof Date) {
            return this.defaultCalendar;
        }
        return this.calendar;
    }

    private static void cleanTimePortion(Calendar d) {
        d.set(11, 0);
        d.set(12, 0);
        d.set(13, 0);
        d.set(14, 0);
    }

    static String createDateTransformerExpr(String timeType, String value) {
        return "TempDateTransformer.transform(\"" + timeType + "\"," + value + ")";
    }

    static class ColumnMeta {
        static final int LEVEL_KEY_TYPE = 1;
        static final int MEASURE_TYPE = 2;
        static final int UNKNOWN_TYPE = 3;
        private String name;
        private int dataType;
        private int type;
        private int index;
        private IDataProcessor dataProcessor;

        ColumnMeta(String name, IDataProcessor processor, int type) {
            this.name = name;
            this.type = type;
            this.dataProcessor = processor == null ? new DummyDataProcessor() : processor;
        }

        public int getIndex() {
            return this.index;
        }

        public int getType() {
            return this.dataType;
        }

        public String getName() {
            return this.name;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void setDataType(int type) {
            this.dataType = type;
        }

        public boolean isLevelKey() {
            return this.type == 1;
        }

        public boolean isMeasure() {
            return this.type == 2;
        }

        public void setType(int type) {
            this.type = type;
        }

        public IDataProcessor getDataProcessor() {
            return this.dataProcessor;
        }
    }

    static class DataProcessorWrapper
    implements IDataProcessor {
        private ICalculator calculator;

        DataProcessorWrapper(ICalculator calculator) {
            this.calculator = calculator;
        }

        @Override
        public Object process(Object d) throws AdapterException {
            try {
                return this.calculator.calculate(d);
            }
            catch (BirtException e) {
                throw new AdapterException(e.getLocalizedMessage(), e);
            }
        }
    }

    static class DateTimeAttributeProcessor
    implements IDataProcessor {
        private String timeType;
        private Calendar calendar;

        DateTimeAttributeProcessor(String timeType, ULocale locale, TimeZone zone) {
            this.timeType = timeType;
            this.calendar = Calendar.getInstance((ULocale)locale);
            if (zone != null) {
                this.calendar.setTimeZone(zone);
            }
        }

        private void populateCalendar(Object d) {
            assert (d != null);
            try {
                java.util.Date date = DataTypeUtil.toDate((Object)d);
                this.calendar.setTime(date);
            }
            catch (BirtException e) {
                throw new IllegalArgumentException(AdapterResourceHandle.getInstance().getMessage("invalid.datetime.value"));
            }
        }

        @Override
        public Object process(Object d) throws AdapterException {
            if (d == null) {
                return null;
            }
            this.populateCalendar(d);
            if ("day-of-month".equals(this.timeType) || "day-of-week".equals(this.timeType) || "day-of-year".equals(this.timeType) || "week-of-month".equals(this.timeType) || "week-of-year".equals(this.timeType)) {
                DataSetIterator.cleanTimePortion(this.calendar);
                return this.calendar.getTime();
            }
            if ("month".equals(this.timeType)) {
                DataSetIterator.cleanTimePortion(this.calendar);
                this.calendar.set(5, 1);
                return this.calendar.getTime();
            }
            if ("quarter".equals(this.timeType)) {
                DataSetIterator.cleanTimePortion(this.calendar);
                this.calendar.set(5, 1);
                int month = this.calendar.get(2);
                switch (month) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.calendar.set(2, 0);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        this.calendar.set(2, 3);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        this.calendar.set(2, 6);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        this.calendar.set(2, 9);
                    }
                }
                return this.calendar.getTime();
            }
            if ("year".equals(this.timeType)) {
                DataSetIterator.cleanTimePortion(this.calendar);
                this.calendar.set(2, 0);
                this.calendar.set(5, 1);
                return this.calendar.getTime();
            }
            if ("hour".equals(this.timeType)) {
                this.calendar.set(12, 0);
                this.calendar.set(13, 1);
                this.calendar.set(14, 0);
                return this.calendar.getTime();
            }
            if ("minute".equals(this.timeType)) {
                this.calendar.set(13, 1);
                this.calendar.set(14, 0);
                return this.calendar.getTime();
            }
            if ("second".equals(this.timeType)) {
                this.calendar.set(14, 0);
                return this.calendar.getTime();
            }
            throw new AdapterException("adapter.invalid.datetimetype", this.timeType);
        }
    }

    private static class DummyDataProcessor
    implements IDataProcessor {
        private DummyDataProcessor() {
        }

        @Override
        public Object process(Object d) {
            return d;
        }
    }

    private class Function_Transform
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        public Function_Transform(ULocale locale) {
        }

        @Override
        protected Object getValue(Object[] args) throws BirtException {
            assert (args.length == 2);
            String timeType = args[0].toString();
            Object d = args[1];
            return DateTimeUtility.getPortion(d, timeType, DataSetIterator.this.getCalendar(d));
        }
    }

    abstract class Function_temp
    extends BaseFunction
    implements Function {
        private static final long serialVersionUID = 1L;

        Function_temp() {
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            args = this.convertToJavaObjects(args);
            try {
                return this.getValue(args);
            }
            catch (BirtException e) {
                throw new IllegalArgumentException("The type of arguement is incorrect.");
            }
        }

        protected abstract Object getValue(Object[] var1) throws BirtException;

        private Object[] convertToJavaObjects(Object[] args) {
            int i = 0;
            while (i < args.length) {
                args[i] = JavascriptEvalUtil.convertJavascriptValue((Object)args[i]);
                ++i;
            }
            return args;
        }
    }

    static interface IDataProcessor {
        public Object process(Object var1) throws AdapterException;
    }

    private class ResultMeta {
        private HashMap columnMetaMap = new HashMap();
        private HashMap indexMap = new HashMap();
        private Object[] nullValueReplacer;

        ResultMeta(List columnMetas) {
            this.nullValueReplacer = new Object[columnMetas.size()];
            int i = 0;
            while (i < columnMetas.size()) {
                ColumnMeta columnMeta = (ColumnMeta)columnMetas.get(i);
                columnMeta.setIndex(i + 1);
                this.columnMetaMap.put(columnMeta.getName(), columnMeta);
                this.indexMap.put(i + 1, columnMeta);
                if (columnMeta.isLevelKey()) {
                    this.nullValueReplacer[i] = this.createNullValueReplacer(columnMeta.getType());
                }
                ++i;
            }
        }

        public int getFieldIndex(String fieldName) {
            return ((ColumnMeta)this.columnMetaMap.get(fieldName)).getIndex();
        }

        public int getFieldType(String fieldName) {
            return ((ColumnMeta)this.columnMetaMap.get(fieldName)).getType();
        }

        public String getFieldName(int index) {
            return ((ColumnMeta)this.indexMap.get(index)).getName();
        }

        public Object getNullValueReplacer(int index) {
            return this.nullValueReplacer[index - 1];
        }

        public IDataProcessor getDataProcessor(int index) {
            return ((ColumnMeta)this.indexMap.get(index)).getDataProcessor();
        }

        private Object createNullValueReplacer(int fieldType) {
            switch (fieldType) {
                case 6: {
                    return new java.util.Date(DataSetIterator.this.nullTime);
                }
                case 9: {
                    return new Date(DataSetIterator.this.nullTime);
                }
                case 10: {
                    return new Time(DataSetIterator.this.nullTime);
                }
                case 1: {
                    return Boolean.FALSE;
                }
                case 4: {
                    return new BigDecimal(0);
                }
                case 3: {
                    return new Double(0.0);
                }
                case 2: {
                    return 0;
                }
                case 5: {
                    return "";
                }
            }
            return "";
        }
    }

    private class TempDateTransformer
    extends ScriptableObject {
        private static final long serialVersionUID = 1L;

        public TempDateTransformer(ULocale locale) {
            this.defineProperty("transform", (Object)new Function_Transform(locale), 0);
        }

        public String getClassName() {
            return "TempDateTransformer";
        }
    }
}

