/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import com.ibm.icu.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.factory.IExternalizer;
import org.eclipse.birt.chart.factory.IResourceFinder;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Interactivity;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.InteractivityImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.reportitem.BIRTActionEvaluator;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartReportStyleProcessor;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.api.ChartReportItemHelper;
import org.eclipse.birt.chart.reportitem.ui.ChartExpressionButton;
import org.eclipse.birt.chart.reportitem.ui.ChartExpressionButtonUtil;
import org.eclipse.birt.chart.reportitem.ui.ChartImageServiceProvider;
import org.eclipse.birt.chart.reportitem.ui.ChartReportItemUIFactory;
import org.eclipse.birt.chart.reportitem.ui.ChartReportItemUIUtil;
import org.eclipse.birt.chart.reportitem.ui.ChartXTabUIUtil;
import org.eclipse.birt.chart.reportitem.ui.DesignerRepresentation;
import org.eclipse.birt.chart.reportitem.ui.QueryUIHelper;
import org.eclipse.birt.chart.reportitem.ui.ReportDataServiceProvider;
import org.eclipse.birt.chart.reportitem.ui.dialogs.ChartExpressionProvider;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.ui.swt.composites.FormatSpecifierHandler;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartDataSheet;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartUIFactory;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartUIHelper;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.IExpressionButton;
import org.eclipse.birt.chart.ui.swt.interfaces.IExpressionValidator;
import org.eclipse.birt.chart.ui.swt.interfaces.IFormatSpecifierHandler;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ApplyButtonHandler;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.preview.ChartLivePreviewThread;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IButtonHandler;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IWizardContext;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileFolderSelectionDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.HyperlinkBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.designer.ui.extensions.ReportItemBuilderUI;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ChartReportItemBuilderImpl
extends ReportItemBuilderUI
implements IUIServiceProvider {
    protected static boolean isChartWizardOpen = false;
    protected static int iInstanceCount = 0;
    protected ExtendedItemHandle extendedHandle = null;
    protected ChartWizardContext wizardContext = null;
    protected final String taskId;
    protected IFormatSpecifierHandler formatSpecifierHandler;
    protected static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");

    public ChartReportItemBuilderImpl() {
        this(null);
    }

    public ChartReportItemBuilderImpl(String taskId) {
        this.taskId = taskId;
    }

    public static boolean isChartWizardOpen() {
        return isChartWizardOpen;
    }

    public int open(ExtendedItemHandle eih) {
        if (iInstanceCount > 0) {
            return 1;
        }
        ++iInstanceCount;
        if (ChartCubeUtil.isAxisChart((DesignElementHandle)eih)) {
            DesignElementHandle hostChart = eih.getElementProperty("hostChart");
            this.extendedHandle = (ExtendedItemHandle)hostChart;
        } else {
            this.extendedHandle = eih;
        }
        ReportDataServiceProvider dataProvider = null;
        ChartLivePreviewThread livePreviewThread = null;
        try {
            ChartWizardContext context;
            Chart cmClone;
            IReportItem item = null;
            try {
                item = this.extendedHandle.getReportItem();
                if (item == null) {
                    this.extendedHandle.loadExtendedElement();
                    item = this.extendedHandle.getReportItem();
                }
            }
            catch (ExtendedElementException exception) {
                logger.log((Exception)((Object)exception));
            }
            if (item == null) {
                logger.log(4, Messages.getString("ChartReportItemBuilderImpl.log.UnableToLocate"));
                return 1;
            }
            CommandStack commandStack = this.extendedHandle.getRoot().getCommandStack();
            String TRANS_NAME = org.eclipse.birt.chart.reportitem.i18n.Messages.getString((String)"ChartElementCommandImpl.editChart");
            commandStack.startTrans(TRANS_NAME);
            ChartReportItemImpl crii = (ChartReportItemImpl)item;
            Chart cm = (Chart)crii.getProperty("chart.instance");
            Chart chart = cmClone = cm == null ? null : cm.copyInstance();
            if (cmClone != null) {
                this.maintainCompatibility(cmClone);
            }
            Object[] applyData = new Object[3];
            Shell parentShell = null;
            if (PlatformUI.isWorkbenchRunning()) {
                parentShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            }
            ChartWizard chartBuilder = new ChartWizard(parentShell);
            dataProvider = ChartReportItemUIFactory.instance().createReportDataServiceProvider(this.extendedHandle);
            ChartReportItemUIFactory uiFactory = ChartReportItemUIFactory.instance();
            IChartDataSheet dataSheet = uiFactory.createDataSheet(this.extendedHandle, dataProvider);
            ChartImageServiceProvider imageProvider = new ChartImageServiceProvider(this.extendedHandle);
            this.wizardContext = context = uiFactory.createWizardContext(cmClone, this, imageProvider, dataProvider, dataSheet);
            livePreviewThread = new ChartLivePreviewThread((IDataServiceProvider)dataProvider);
            livePreviewThread.start();
            context.setLivePreviewThread((Thread)livePreviewThread);
            context.setUIFactory((IChartUIFactory)uiFactory);
            dataProvider.setWizardContext(context);
            if (dataProvider.checkState(32)) {
                context.setEnabled("Chart.Axis", false);
                context.setEnabled("Chart.Axis.X Axis", false);
                context.setEnabled("Chart.Axis.Y Axis", false);
                context.setEnabled("Chart.Axis.Z Axis", false);
                context.setEnabled("Chart.Legend", false);
                context.setEnabled("Chart.Title", false);
            }
            this.addCustomButtons(chartBuilder, context, commandStack, TRANS_NAME, applyData);
            context.setRtL(crii.isLayoutDirectionRTL());
            context.setTextRtL(this.extendedHandle.isDirectionRTL());
            context.setResourceFinder((IResourceFinder)crii);
            context.setExternalizer((IExternalizer)crii);
            Object of = this.extendedHandle.getProperty("outputFormat");
            if (of instanceof String) {
                if (of.equals("GIF")) {
                    context.setOutputFormat("PNG");
                } else {
                    context.setOutputFormat((String)of);
                }
            }
            context.setInheritColumnsOnly(this.extendedHandle.getBooleanProperty("inheritColumns"));
            context.setExtendedItem((Object)this.extendedHandle);
            context.setProcessor((IStyleProcessor)new ChartReportStyleProcessor((DesignElementHandle)this.extendedHandle, false));
            ChartAdapter.beginIgnoreNotifications();
            if (dataProvider.checkState(2048)) {
                dataProvider.update("CopySeriesDefinition", null);
            }
            ChartWizard.clearExceptions();
            context.setActionEvaluator((IActionEvaluator)new BIRTActionEvaluator());
            ChartAdapter.endIgnoreNotifications();
            this.beforeOpenChartBuilder();
            isChartWizardOpen = true;
            ChartWizardContext contextResult = (ChartWizardContext)chartBuilder.open(null, this.taskId, (IWizardContext)context);
            isChartWizardOpen = false;
            if (contextResult != null && contextResult.getModel() != null) {
                if (!chartBuilder.isOkPressed()) {
                    commandStack.rollback();
                    return 1;
                }
                this.updateModel(this.extendedHandle, chartBuilder, crii, cm, contextResult.getModel(), contextResult.getOutputFormat(), contextResult.isInheritColumnsOnly());
                if (dataProvider.isPartChart()) {
                    ChartXTabUIUtil.updateXTabForAxis((AggregationCellHandle)ChartCubeUtil.getXtabContainerCell((DesignElementHandle)this.extendedHandle), (ExtendedItemHandle)this.extendedHandle, (boolean)ChartXTabUIUtil.isTransposedChartWithAxes(cm), (ChartWithAxes)((ChartWithAxes)contextResult.getModel()));
                }
                this.afterOpenChartBuilder();
                commandStack.commit();
                return 0;
            }
            if (applyData[0] != null) {
                commandStack.rollback();
                this.updateModel(this.extendedHandle, chartBuilder, crii, cm, (Chart)applyData[0], (String)applyData[1], (Boolean)applyData[2]);
                if (dataProvider.isPartChart()) {
                    commandStack.startTrans(TRANS_NAME);
                    ChartXTabUIUtil.updateXTabForAxis((AggregationCellHandle)ChartCubeUtil.getXtabContainerCell((DesignElementHandle)this.extendedHandle), (ExtendedItemHandle)this.extendedHandle, (boolean)ChartXTabUIUtil.isTransposedChartWithAxes(cm), (ChartWithAxes)((ChartWithAxes)applyData[0]));
                    commandStack.commit();
                }
                return 0;
            }
            commandStack.rollback();
            return 1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            --iInstanceCount;
            this.extendedHandle = null;
            isChartWizardOpen = false;
            if (livePreviewThread != null) {
                livePreviewThread.end();
            }
            ChartWizard.clearExceptions();
        }
    }

    protected void addCustomButtons(ChartWizard chartBuilder, final ChartWizardContext context, final CommandStack commandStack, final String TRANS_NAME, final Object[] applyData) {
        chartBuilder.addCustomButton((IButtonHandler)new ApplyButtonHandler(chartBuilder){

            public void run() {
                super.run();
                applyData[0] = context.getModel().copyInstance();
                applyData[1] = context.getOutputFormat();
                applyData[2] = context.isInheritColumnsOnly();
                commandStack.commit();
                commandStack.startTrans(TRANS_NAME);
            }
        });
    }

    protected void maintainCompatibility(Chart cm) {
        ChartUtil.reviseVersion((Chart)cm);
        this.normalizeModel(cm);
        if (cm.getInteractivity() == null) {
            Interactivity interactivity = InteractivityImpl.create();
            interactivity.eAdapters().addAll((Collection)cm.eAdapters());
            cm.setInteractivity(interactivity);
        }
        if (cm.getLegend().getSeparator() == null) {
            LineAttributes separator = LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1);
            separator.setVisible(true);
            separator.eAdapters().addAll((Collection)cm.eAdapters());
            cm.getLegend().setSeparator(separator);
        }
        if (cm.getExtendedProperties().isEmpty()) {
            ChartModelHelper.instance().updateExtendedProperties(cm.getExtendedProperties());
        }
        if (cm.getSampleData() == null) {
            SampleData sampleData = DataFactory.eINSTANCE.createSampleData();
            sampleData.getBaseSampleData().clear();
            sampleData.getOrthogonalSampleData().clear();
            if (cm instanceof ChartWithoutAxes) {
                BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData();
                sdBase.setDataSetRepresentation(ChartUtil.getNewSampleData((AxisType)AxisType.TEXT_LITERAL, (int)0));
                sampleData.getBaseSampleData().add((Object)sdBase);
                int i = 0;
                while (i < ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)cm).size()) {
                    OrthogonalSampleData oSample = DataFactory.eINSTANCE.createOrthogonalSampleData();
                    oSample.setDataSetRepresentation(ChartUtil.getNewSampleData((AxisType)AxisType.LINEAR_LITERAL, (int)i));
                    oSample.setSeriesDefinitionIndex(i);
                    sampleData.getOrthogonalSampleData().add((Object)oSample);
                    ++i;
                }
            } else if (cm instanceof ChartWithAxes) {
                ChartWithAxes chart = (ChartWithAxes)cm;
                BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData();
                sdBase.setDataSetRepresentation(ChartUtil.getNewSampleData((AxisType)ChartUIUtil.getAxisXForProcessing((ChartWithAxes)chart).getType(), (int)0));
                sampleData.getBaseSampleData().add((Object)sdBase);
                for (Axis axis : ChartUIUtil.getAxisXForProcessing((ChartWithAxes)chart).getAssociatedAxes()) {
                    int i = 0;
                    while (i < axis.getSeriesDefinitions().size()) {
                        OrthogonalSampleData oSample = DataFactory.eINSTANCE.createOrthogonalSampleData();
                        oSample.setDataSetRepresentation(ChartUtil.getNewSampleData((AxisType)axis.getType(), (int)i));
                        oSample.setSeriesDefinitionIndex(i);
                        sampleData.getOrthogonalSampleData().add((Object)oSample);
                        ++i;
                    }
                }
            }
            cm.setSampleData(sampleData);
        }
    }

    private void normalizeModel(Chart cm) {
        String chartType = cm.getType();
        if ("Column Chart".equals(chartType)) {
            cm.setType("Bar Chart");
        } else if ("Doughnut Chart".equals(chartType)) {
            cm.setType("Pie Chart");
        }
    }

    protected void updateModel(ExtendedItemHandle eih, ChartWizard chartBuilder, ChartReportItemImpl crii, Chart cmOld, Chart cmNew, String outputFormat, boolean bInheritColumnsOnly) {
        try {
            eih.setProperty("outputFormat", (Object)outputFormat);
            eih.setProperty("inheritColumns", (Object)bInheritColumnsOnly);
            crii.executeSetModelCommand(eih, cmOld, cmNew);
            Bounds bo = cmNew.getBlock().getBounds();
            if (bo == null || bo.getWidth() == 0.0 || bo.getHeight() == 0.0) {
                bo = ChartItemUtil.createDefaultChartBounds((ExtendedItemHandle)eih, (Chart)cmNew);
            }
            NumberFormat nf = ChartUIUtil.getDefaultNumberFormatInstance();
            if (eih.getWidth().getStringValue() == null) {
                eih.setWidth(String.valueOf(nf.format(bo.getWidth())) + "pt");
            }
            if (eih.getHeight().getStringValue() == null) {
                eih.setHeight(String.valueOf(nf.format(bo.getHeight())) + "pt");
            }
        }
        catch (SemanticException smx) {
            logger.log((Exception)((Object)smx));
        }
        if (crii.getDesignerRepresentation() != null) {
            ((DesignerRepresentation)((Object)crii.getDesignerRepresentation())).setDirty(true);
        }
    }

    @Deprecated
    public String invoke(String sExpression, Object oContext, String sTitle) {
        ExpressionBuilder eb = new ExpressionBuilder(sExpression);
        eb.setExpressionProvider((IExpressionProvider)new ExpressionProvider((DesignElementHandle)((ExtendedItemHandle)oContext)));
        if (sTitle != null) {
            eb.setDialogTitle(String.valueOf(eb.getDialogTitle()) + " - " + sTitle);
        }
        if (eb.open() == 0) {
            sExpression = eb.getResult();
        }
        return sExpression;
    }

    @Deprecated
    public String invoke(String sExpression, Object oContext, String sTitle, boolean isChartProvider) {
        ExpressionBuilder eb = new ExpressionBuilder(sExpression);
        eb.setExpressionProvider((IExpressionProvider)new ChartExpressionProvider());
        if (sTitle != null) {
            eb.setDialogTitle(String.valueOf(eb.getDialogTitle()) + " - " + sTitle);
        }
        if (eb.open() == 0) {
            sExpression = eb.getResult();
        }
        return sExpression;
    }

    public String[] validate(Chart cm, Object oContext) {
        ArrayList<String> alProblems = new ArrayList<String>(4);
        ExtendedItemHandle eih = (ExtendedItemHandle)oContext;
        if (DEUtil.getDataSetList((DesignElementHandle)eih).size() == 0 && ChartReportItemHelper.instance().getBindingCubeHandle((ReportItemHandle)eih) == null) {
            alProblems.add(Messages.getString("ChartReportItemBuilderImpl.problem.hasNotBeenFound"));
        }
        QueryUIHelper helper = new QueryUIHelper(cm);
        helper.enableDataTypeValidator(this.wizardContext.getDataServiceProvider());
        alProblems.addAll(helper.validate());
        return alProblems.toArray(new String[alProblems.size()]);
    }

    public List<String> getRegisteredKeys() {
        return this.extendedHandle.getModuleHandle().getMessageKeys();
    }

    public String getValue(String sKey) {
        String value = this.extendedHandle.getModuleHandle().getMessage(sKey);
        if (value == null || value.equals("")) {
            return sKey;
        }
        return value;
    }

    public final double getConvertedValue(double dOriginalValue, String sFromUnits, String sToUnits) {
        if (sFromUnits == null || sToUnits == null) {
            return dOriginalValue;
        }
        IDisplayServer ids = ChartUIUtil.getDisplayServer();
        if (sFromUnits.equalsIgnoreCase("pixels")) {
            dOriginalValue = dOriginalValue * 72.0 / (double)ids.getDpiResolution();
        }
        double dResult = DimensionUtil.convertTo((double)dOriginalValue, (String)ChartReportItemBuilderImpl.getBIRTUnitsFor(sFromUnits), (String)ChartReportItemBuilderImpl.getBIRTUnitsFor(sToUnits)).getMeasure();
        if (sToUnits.equalsIgnoreCase("pixels")) {
            dResult = (double)ids.getDpiResolution() * dResult / 72.0;
        }
        return dResult;
    }

    private static String getBIRTUnitsFor(String sUnits) {
        if (sUnits.equalsIgnoreCase("inches")) {
            return "in";
        }
        if (sUnits.equalsIgnoreCase("centimeters")) {
            return "cm";
        }
        return "pt";
    }

    protected ExpressionProvider createExpressionProvider(int command, Object context) {
        return new ChartExpressionProvider((DesignElementHandle)((ExtendedItemHandle)context), this.wizardContext, ChartReportItemUIUtil.getExpressionBuilderStyle(command));
    }

    public String invoke(int command, String value, Object context, String sTitle) throws ChartException {
        final ExpressionProvider ep = this.createExpressionProvider(command, context);
        Shell shell = null;
        switch (command) {
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                shell = new Shell(Display.getDefault(), 67696);
                ChartUIUtil.bindHelp((Control)shell, (String)"org.eclipse.birt.chart.cshelp.EditURL_ID");
                HyperlinkBuilder hb = new HyperlinkBuilder(shell, true){

                    protected ExpressionProvider getExpressionProvider() {
                        return ep;
                    }
                };
                try {
                    hb.setInputString(value, (DesignElementHandle)this.extendedHandle);
                    if (sTitle != null) {
                        hb.setTitle(String.valueOf(hb.getTitle()) + " - " + sTitle);
                    }
                    if (hb.open() != 0) break;
                    value = hb.getResultString();
                    break;
                }
                catch (Exception e) {
                    throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 13, (Throwable)e);
                }
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                shell = new Shell(Display.getDefault(), 67696);
                ChartUIUtil.bindHelp((Control)shell, (String)"org.eclipse.birt.chart.cshelp.ExpressionBuilder_ID");
                ExpressionBuilder eb = new ExpressionBuilder(shell, value);
                eb.setExpressionProvider((IExpressionProvider)ep);
                if (sTitle != null) {
                    eb.setDialogTitle(String.valueOf(eb.getDialogTitle()) + " - " + sTitle);
                }
                if (eb.open() != 0) break;
                value = eb.getResult();
                break;
            }
            case 11: {
                ResourceFileFolderSelectionDialog dialog = new ResourceFileFolderSelectionDialog(true, true, new String[]{"*.jpg;*.gif;*.png;"});
                dialog.setEmptyFolderShowStatus(2);
                dialog.setTitle(sTitle);
                dialog.setMessage(sTitle);
                if (dialog.open() == 0) {
                    String path = dialog.getPath();
                    return path;
                }
                return null;
            }
        }
        return value;
    }

    public boolean isInvokingSupported() {
        return true;
    }

    public boolean isEclipseModeSupported() {
        return true;
    }

    public Object invoke(IUIServiceProvider.Command command, Object ... inData) throws ChartException {
        IExpressionButton outData = null;
        switch (command) {
            case EXPRESS_BUTTON_CREATE: {
                if (inData.length <= 3) break;
                Composite parent = (Composite)inData[0];
                Control control = (Control)inData[1];
                final ExtendedItemHandle eih = (ExtendedItemHandle)inData[2];
                int iCode = (Integer)inData[3];
                ChartExpressionProvider ep = new ChartExpressionProvider((DesignElementHandle)eih, this.wizardContext, ChartReportItemUIUtil.getExpressionBuilderStyle(iCode));
                if (inData.length > 6 && (inData[6].equals("category") || inData[6].equals("optional"))) {
                    final IChartUIHelper helper = ChartReportItemUIFactory.instance().createUIHelper();
                    ep.addFilter(new ExpressionFilter(){

                        public boolean select(Object parentElement, Object element) {
                            try {
                                ComputedColumnHandle cch;
                                String exp;
                                if (element instanceof ComputedColumnHandle && !helper.useDataSetRow((Object)eih, exp = (cch = (ComputedColumnHandle)element).getExpression())) {
                                    return false;
                                }
                            }
                            catch (BirtException e) {
                                logger.log((Exception)((Object)e));
                            }
                            return true;
                        }
                    });
                }
                IExpressionButton ceb = ChartExpressionButtonUtil.createExpressionButton(parent, control, eih, (IExpressionProvider)ep);
                if (inData.length > 4) {
                    Listener listener = (Listener)inData[4];
                    ceb.addListener(listener);
                }
                if (inData.length > 5 && inData[5] != null && ceb instanceof ChartExpressionButton) {
                    IExpressionValidator ev = (IExpressionValidator)inData[5];
                    ((ChartExpressionButton)ceb).getExpressionHelper().setExpressionValidator(ev);
                }
                outData = ceb;
            }
        }
        return outData;
    }

    public IFormatSpecifierHandler getFormatSpecifierHandler() {
        if (this.formatSpecifierHandler == null) {
            this.formatSpecifierHandler = new FormatSpecifierHandler();
        }
        return this.formatSpecifierHandler;
    }

    protected void beforeOpenChartBuilder() {
    }

    protected void afterOpenChartBuilder() {
    }
}

