/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.group;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.impl.group.DateGroupCalculator;

class SecondGroupCalculator
extends DateGroupCalculator {
    public SecondGroupCalculator(Object intervalStart, double intervalRange, ULocale locale, TimeZone timeZone) throws BirtException {
        super(intervalStart, intervalRange, locale, timeZone);
    }

    @Override
    public Object calculate(Object value) throws BirtException {
        if (value == null) {
            return new Double(-1.0);
        }
        Date target = this.getDate(value);
        if (this.intervalStart == null) {
            return new Double(Math.floor((double)this.dateTimeUtil.diffSecond(this.defaultStart, target) / (double)this.getDateIntervalRange()));
        }
        if (this.dateTimeUtil.diffSecond((Date)this.intervalStart, target) < 0L) {
            return new Double(-1.0);
        }
        return new Double(Math.floor((double)this.dateTimeUtil.diffSecond((Date)this.intervalStart, target) / (double)this.getDateIntervalRange()));
    }
}

