/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.ide.adapters;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.FileReportProvider;
import org.eclipse.birt.report.designer.internal.ui.ide.adapters.IDEFileReportDocumentProvider;
import org.eclipse.birt.report.designer.internal.ui.ide.adapters.ReportDocumentProvider;
import org.eclipse.birt.report.designer.internal.ui.ide.adapters.WorkspaceOperationRunner;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.designer.ui.ide.wizards.SaveReportAsWizard;
import org.eclipse.birt.report.designer.ui.ide.wizards.SaveReportAsWizardDialog;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class IDEFileReportProvider
implements IReportProvider {
    private ModuleHandle model = null;
    private static final String VERSION_MESSAGE = Messages.getString((String)"TextPropertyDescriptor.Message.Version");
    private WorkspaceOperationRunner fOperationRunner;

    public void connect(ModuleHandle model) {
        this.model = model;
    }

    public ModuleHandle queryReportModuleHandle() {
        return this.model;
    }

    public ModuleHandle getReportModuleHandle(Object element) {
        return this.getReportModuleHandle(element, false);
    }

    public void saveReport(ModuleHandle moduleHandle, Object element, IProgressMonitor monitor) {
        this.saveReport(moduleHandle, element, null, monitor);
    }

    public void saveReport(ModuleHandle moduleHandle, Object element, IPath origReportPath, IProgressMonitor monitor) {
        IPath path;
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            IFile file = input.getFile();
            if (ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, IWorkspace.VALIDATE_PROMPT).getSeverity() == 0) {
                this.saveFile(moduleHandle, file, origReportPath, monitor);
            }
        } else if (element instanceof IEditorInput && (path = this.getInputPath((IEditorInput)element)) != null) {
            this.saveFile(moduleHandle, path.toFile(), origReportPath, monitor);
        }
    }

    private void saveFile(final ModuleHandle moduleHandle, final File file, final IPath oldReportPath, IProgressMonitor monitor) {
        if (file.exists() && !file.canWrite()) {
            MessageDialog.openError((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"IDEFileReportProvider.ReadOnlyEncounter.Title"), (String)Messages.getFormattedString((String)"IDEFileReportProvider.ReadOnlyEncounter.Message", (Object[])new Object[]{file.getAbsolutePath()}));
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public final synchronized void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor pm) throws CoreException {
                            try {
                                this.execute(pm);
                            }
                            catch (CoreException e) {
                                throw e;
                            }
                            catch (IOException e) {
                                ExceptionHandler.handle((Throwable)e);
                            }
                        }
                    };
                    ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 0, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }

            public void execute(IProgressMonitor monitor) throws CoreException, IOException {
                if (file.exists() || file.createNewFile()) {
                    try {
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file), 16384);){
                            moduleHandle.serialize((OutputStream)out);
                            ((OutputStream)out).flush();
                            if (oldReportPath != null) {
                                FileReportProvider.copyReportConfigFile((IPath)new Path(file.getAbsolutePath()), (IPath)oldReportPath);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        try {
            IRunnableContext runner = this.getOperationRunner(monitor);
            if (runner != null) {
                runner.run(false, false, op);
            } else {
                new ProgressMonitorDialog(UIUtil.getDefaultShell()).run(false, true, op);
            }
        }
        catch (InterruptedException runner) {
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void saveFile(final ModuleHandle moduleHandle, final IFile file, final IPath oldReportPath, IProgressMonitor monitor) {
        if (file.exists() && file.isReadOnly()) {
            MessageDialog.openError((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"IDEFileReportProvider.ReadOnlyEncounter.Title"), (String)Messages.getFormattedString((String)"IDEFileReportProvider.ReadOnlyEncounter.Message", (Object[])new Object[]{file.getFullPath()}));
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public final synchronized void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor pm) throws CoreException {
                            try {
                                this.execute(pm);
                            }
                            catch (CoreException e) {
                                throw e;
                            }
                            catch (IOException e) {
                                ExceptionHandler.handle((Throwable)e);
                            }
                        }
                    };
                    ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 0, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }

            public void execute(IProgressMonitor monitor) throws CoreException, IOException {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                moduleHandle.serialize((OutputStream)out);
                byte[] bytes = out.toByteArray();
                out.close();
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                IContainer container = file.getParent();
                if (!container.exists() && container instanceof IFolder) {
                    UIUtil.createFolder((IFolder)((IFolder)container), (IProgressMonitor)monitor);
                }
                if (file.exists()) {
                    file.setContents((InputStream)is, true, true, monitor);
                } else {
                    file.create((InputStream)is, true, monitor);
                }
                if (oldReportPath != null) {
                    FileReportProvider.copyReportConfigFile((IPath)file.getLocation(), (IPath)oldReportPath);
                }
            }
        };
        try {
            IRunnableContext runner = this.getOperationRunner(monitor);
            if (runner != null) {
                runner.run(false, false, op);
            } else {
                new ProgressMonitorDialog(UIUtil.getDefaultShell()).run(false, true, op);
            }
        }
        catch (InterruptedException runner) {
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        try {
            file.refreshLocal(0, monitor);
        }
        catch (CoreException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public IPath getSaveAsPath(Object element) {
        SaveReportAsWizardDialog dialog;
        IFile file = null;
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            file = input.getFile();
        }
        if ((dialog = new SaveReportAsWizardDialog(UIUtil.getDefaultShell(), (IWizard)new SaveReportAsWizard(this.model, file))).open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    public IEditorInput createNewEditorInput(IPath path) {
        return new FileEditorInput(ResourcesPlugin.getWorkspace().getRoot().getFile(path));
    }

    public IPath getInputPath(IEditorInput input) {
        if (input instanceof IURIEditorInput) {
            URI uri = ((IURIEditorInput)input).getURI();
            if (uri == null && input instanceof IFileEditorInput) {
                return ((IFileEditorInput)input).getFile().getFullPath();
            }
            IPath localPath = URIUtil.toPath((URI)uri);
            String host = uri.getHost();
            if (host != null && localPath == null) {
                return new Path(String.valueOf(host) + uri.getPath()).makeUNC(true);
            }
            return localPath;
        }
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getLocation();
        }
        return null;
    }

    public IDocumentProvider getReportDocumentProvider(Object element) {
        if (element instanceof FileEditorInput) {
            return new ReportDocumentProvider();
        }
        return new IDEFileReportDocumentProvider();
    }

    public ModuleHandle getReportModuleHandle(Object element, boolean reset) {
        IEditorInput input;
        IPath path;
        if ((this.model == null || reset) && (path = this.getInputPath(input = (IEditorInput)element)) != null) {
            String fileName = path.toOSString();
            try {
                String projectFolder;
                HashMap<String, Object> properties = new HashMap<String, Object>();
                String designerVersion = MessageFormat.format(VERSION_MESSAGE, ReportPlugin.getVersion(), ReportPlugin.getBuildInfo());
                properties.put("createdBy", designerVersion);
                properties.put("createdBy", designerVersion);
                if (fileName.endsWith(".rpttemplate")) {
                    properties.put("semanticCheck", false);
                }
                if ((projectFolder = this.getProjectFolder(input)) != null) {
                    properties.put("resourceFolder", projectFolder);
                }
                this.model = SessionHandleAdapter.getInstance().init(fileName, (InputStream)new FileInputStream(path.toFile()), properties);
            }
            catch (IOException | DesignFileException e) {
                ExceptionHandler.handle((Throwable)e, (boolean)true);
            }
        }
        return this.model;
    }

    private String getProjectFolder(IEditorInput input) {
        IPath path;
        String retValue = UIUtil.getProjectFolder((IEditorInput)input);
        if (retValue == null && (path = this.getInputPath(input)) != null) {
            return path.toFile().getParent();
        }
        return retValue;
    }

    private IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        if (this.fOperationRunner == null) {
            this.fOperationRunner = new WorkspaceOperationRunner();
        }
        this.fOperationRunner.setProgressMonitor(monitor);
        return this.fOperationRunner;
    }
}

