/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dtree;

import org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import org.eclipse.core.internal.dtree.DataTreeLookup;
import org.eclipse.core.internal.dtree.ObjectNotFoundException;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractDataTree {
    private boolean immutable = false;
    protected static final IPath[] NO_CHILDREN = new IPath[0];

    public abstract AbstractDataTreeNode copyCompleteSubtree(IPath var1);

    public abstract void createChild(IPath var1, String var2);

    public abstract void createChild(IPath var1, String var2, Object var3);

    public abstract void createSubtree(IPath var1, AbstractDataTreeNode var2);

    public abstract void deleteChild(IPath var1, String var2);

    public IPath getChild(IPath parentKey, int index) {
        String child = this.getNameOfChild(parentKey, index);
        return parentKey.append(child);
    }

    abstract int getChildCount(IPath var1);

    abstract IPath[] getChildren(IPath var1);

    public abstract Object getData(IPath var1);

    abstract String getNameOfChild(IPath var1, int var2);

    public abstract String[] getNamesOfChildren(IPath var1);

    static void handleImmutableTree() {
        throw new RuntimeException(Messages.dtree_immutable);
    }

    static void handleNotFound(IPath key) {
        throw new ObjectNotFoundException(NLS.bind((String)Messages.dtree_notFound, (Object)key));
    }

    public void immutable() {
        this.immutable = true;
    }

    public abstract boolean includes(IPath var1);

    public boolean isImmutable() {
        return this.immutable;
    }

    public abstract DataTreeLookup lookup(IPath var1);

    public IPath rootKey() {
        return Path.ROOT;
    }

    public abstract void setData(IPath var1, Object var2);

    void setImmutable(boolean bool) {
        this.immutable = bool;
    }

    void setRootNode(AbstractDataTreeNode node) {
        throw new Error(Messages.dtree_subclassImplement);
    }
}

