/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.e4.ui.progress.internal.BlockedJobsDialog;
import org.eclipse.e4.ui.progress.internal.FinishedJobs;
import org.eclipse.e4.ui.progress.internal.ProgressManager;
import org.eclipse.e4.ui.progress.internal.ProgressViewUpdater;
import org.eclipse.jface.dialogs.IDialogBlockedHandler;
import org.eclipse.swt.widgets.Shell;

@Creatable
@Singleton
public class WorkbenchDialogBlockedHandler
implements IDialogBlockedHandler {
    IProgressMonitor outerMonitor;
    @Inject
    @Optional
    IProgressService progressService;
    @Inject
    @Optional
    ProgressManager progressManager;
    @Inject
    @Optional
    FinishedJobs finishedJobs;
    @Inject
    @Optional
    ProgressViewUpdater progressViewUpdater;
    int nestingDepth = 0;

    public void clearBlocked() {
        if (this.nestingDepth == 0) {
            return;
        }
        --this.nestingDepth;
        if (this.nestingDepth <= 0) {
            BlockedJobsDialog.clear(this.outerMonitor);
            this.outerMonitor = null;
            this.nestingDepth = 0;
        }
    }

    public void showBlocked(Shell parentShell, IProgressMonitor blockingMonitor, IStatus blockingStatus, String blockedName) {
        ++this.nestingDepth;
        if (this.outerMonitor == null) {
            this.outerMonitor = blockingMonitor;
            if (blockedName == null && parentShell != null) {
                blockedName = parentShell.getText();
            }
            BlockedJobsDialog.createBlockedDialog(parentShell, blockingMonitor, blockingStatus, blockedName, this.progressService, this.finishedJobs, this.progressViewUpdater, this.progressManager);
        }
    }

    public void showBlocked(IProgressMonitor blocking, IStatus blockingStatus, String blockedName) {
        this.showBlocked(null, blocking, blockingStatus, blockedName);
    }
}

