/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.libprov.internal;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.common.project.facet.core.internal.FacetedProjectFrameworkJavaPlugin;
import org.eclipse.jst.common.project.facet.core.libprov.EnablementExpressionContext;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderActionType;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderInstallOperationConfig;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperation;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;

public final class LibraryProvider
implements ILibraryProvider {
    private static final String EXPR_VAR_CONTEXT = "context";
    private static final String EXPR_VAR_REQUESTING_PROJECT_FACET = "requestingProjectFacet";
    private static final String EXPR_VAR_PROJECT_FACETS = "projectFacets";
    private static final String EXPR_VAR_TARGETED_RUNTIMES = "targetedRuntimes";
    private static final String EXPR_VAR_PROVIDER = "provider";
    private String id = null;
    private String pluginId = null;
    private String label = null;
    private ILibraryProvider base = null;
    private boolean isAbstract = false;
    private boolean isHidden = false;
    private Expression enablementCondition = null;
    private Integer priority = null;
    private final Map<String, String> params = new HashMap<String, String>();
    private final Map<LibraryProviderActionType, ActionDef> actionDefs = new EnumMap<LibraryProviderActionType, ActionDef>(LibraryProviderActionType.class);

    LibraryProvider() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    @Override
    public String getLabel() {
        String result = this.label != null ? this.label : (this.base != null ? this.base.getLabel() : this.id);
        return result;
    }

    void setLabel(String label) {
        this.label = label;
    }

    @Override
    public ILibraryProvider getBaseProvider() {
        return this.base;
    }

    void setBaseProvider(ILibraryProvider base) {
        this.base = base;
    }

    @Override
    public ILibraryProvider getRootProvider() {
        ILibraryProvider prov = this;
        while (prov.getBaseProvider() != null) {
            prov = prov.getBaseProvider();
        }
        return prov;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    void setIsAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    void setIsHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    @Override
    public int getPriority() {
        if (this.priority != null) {
            return this.priority;
        }
        if (this.base != null) {
            return this.base.getPriority();
        }
        return 0;
    }

    void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public boolean isEnabledFor(IFacetedProjectBase fproj, IProjectFacetVersion fv) {
        return this.isEnabledFor(fproj, fv, null);
    }

    @Override
    public boolean isEnabledFor(IFacetedProjectBase fproj, IProjectFacetVersion fv, Map<String, Object> customVariables) {
        EvaluationContext evalContext = new EvaluationContext(null, (Object)fv);
        EnablementExpressionContext context = new EnablementExpressionContext(fproj, fv, this);
        evalContext.setAllowPluginActivation(true);
        if (customVariables != null) {
            for (Map.Entry<String, Object> entry : customVariables.entrySet()) {
                evalContext.addVariable(entry.getKey(), entry.getValue());
            }
        }
        evalContext.addVariable(EXPR_VAR_CONTEXT, (Object)context);
        evalContext.addVariable(EXPR_VAR_REQUESTING_PROJECT_FACET, (Object)fv);
        evalContext.addVariable(EXPR_VAR_PROJECT_FACETS, (Object)fproj.getProjectFacets());
        evalContext.addVariable(EXPR_VAR_TARGETED_RUNTIMES, (Object)fproj.getTargetedRuntimes());
        evalContext.addVariable(EXPR_VAR_PROVIDER, (Object)this);
        for (Expression expression : this.getEnablementConditions()) {
            try {
                EvaluationResult evalResult = expression.evaluate((IEvaluationContext)evalContext);
                if (evalResult != EvaluationResult.FALSE) continue;
                return false;
            }
            catch (CoreException e) {
                FacetedProjectFrameworkJavaPlugin.log((Exception)((Object)e));
            }
        }
        return true;
    }

    void setEnablementCondition(Expression enablementCondition) {
        this.enablementCondition = enablementCondition;
    }

    private List<Expression> getEnablementConditions() {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        LibraryProvider provider = this;
        while (provider != null) {
            if (provider.enablementCondition != null) {
                expressions.add(provider.enablementCondition);
            }
            provider = (LibraryProvider)provider.base;
        }
        return expressions;
    }

    @Override
    public Map<String, String> getParams() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.base != null) {
            result.putAll(((LibraryProvider)this.base).getParams());
        }
        result.putAll(this.params);
        return result;
    }

    void addParam(String name, String value) {
        this.params.put(name, value);
    }

    @Override
    public boolean isActionSupported(LibraryProviderActionType type) {
        return this.getActionDef(type) != null;
    }

    public LibraryProviderOperation createOperation(LibraryProviderActionType type) {
        ActionDef actionDef = this.getActionDef(type);
        if (actionDef == null) {
            throw new IllegalArgumentException();
        }
        Class<LibraryProviderOperation> cl = actionDef.getOperationClass();
        if (cl == null) {
            return null;
        }
        return (LibraryProviderOperation)PluginUtil.instantiate((String)actionDef.getPluginId(), cl);
    }

    public LibraryProviderOperationConfig createInstallOperationConfig(LibraryInstallDelegate libraryInstallDelegate) {
        ActionDef actionDef = this.getActionDef(LibraryProviderActionType.INSTALL);
        if (actionDef == null) {
            throw new IllegalArgumentException();
        }
        Class<LibraryProviderOperationConfig> cl = actionDef.getConfigClass();
        if (cl == null) {
            return null;
        }
        LibraryProviderOperationConfig cfg = (LibraryProviderOperationConfig)PluginUtil.instantiate((String)actionDef.getPluginId(), cl);
        if (cfg instanceof LibraryProviderInstallOperationConfig) {
            ((LibraryProviderInstallOperationConfig)cfg).init(libraryInstallDelegate, this);
        } else {
            cfg.init(libraryInstallDelegate.getFacetedProject(), libraryInstallDelegate.getProjectFacetVersion(), this);
        }
        return cfg;
    }

    public LibraryProviderOperationConfig createOperationConfig(IFacetedProjectBase fproj, IProjectFacetVersion fv, LibraryProviderActionType type) {
        ActionDef actionDef = this.getActionDef(type);
        if (actionDef == null) {
            throw new IllegalArgumentException();
        }
        Class<LibraryProviderOperationConfig> cl = actionDef.getConfigClass();
        if (cl == null) {
            return null;
        }
        LibraryProviderOperationConfig cfg = (LibraryProviderOperationConfig)PluginUtil.instantiate((String)actionDef.getPluginId(), cl);
        cfg.init(fproj, fv, this);
        return cfg;
    }

    ActionDef getActionDef(LibraryProviderActionType type) {
        ActionDef actionDef = this.actionDefs.get((Object)type);
        if (actionDef == null && this.base != null) {
            actionDef = ((LibraryProvider)this.base).getActionDef(type);
        }
        return actionDef;
    }

    void addActionDef(LibraryProviderActionType type, String configClassName, String operationClassName) {
        ActionDef actionDef = new ActionDef(configClassName, operationClassName);
        this.actionDefs.put(type, actionDef);
    }

    @Override
    public int compareTo(ILibraryProvider other) {
        int result;
        int p2;
        int p1 = this.getPriority();
        int n = p1 < (p2 = other.getPriority()) ? -1 : (result = p1 == p2 ? 0 : 1);
        if (result == 0) {
            result = this.getId().compareTo(other.getId());
        }
        return result;
    }

    private final class ActionDef {
        private final String configClassName;
        private Class<LibraryProviderOperationConfig> configClass;
        private final String operationClassName;
        private Class<LibraryProviderOperation> operationClass;

        public ActionDef(String configClassName, String operationClassName) {
            if (configClassName == null) {
                this.configClassName = null;
                this.configClass = LibraryProviderOperationConfig.class;
            } else {
                this.configClassName = configClassName;
                this.configClass = null;
            }
            this.operationClassName = operationClassName;
            this.operationClass = null;
        }

        public String getPluginId() {
            return LibraryProvider.this.getPluginId();
        }

        public synchronized Class<LibraryProviderOperationConfig> getConfigClass() {
            if (this.configClass == null) {
                this.configClass = PluginUtil.loadClass((String)this.getPluginId(), (String)this.configClassName, LibraryProviderOperationConfig.class);
            }
            return this.configClass;
        }

        public synchronized Class<LibraryProviderOperation> getOperationClass() {
            if (this.operationClass == null) {
                this.operationClass = PluginUtil.loadClass((String)this.getPluginId(), (String)this.operationClassName, LibraryProviderOperation.class);
            }
            return this.operationClass;
        }
    }
}

