/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.reportitem.ui.dialogs.ExpressionDialogCellEditor;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.views.attributes.IPropertyDescriptor;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ParamBinding;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ReportItemParametersDialog
extends BaseDialog {
    private HashMap propertiesMap = new HashMap(7);
    private Table table;
    private ArrayList resultList;
    private ArrayList bindingParametersList;
    private static final String Binding = "binding";
    private TableViewer tableViewer;
    private static final String[] columnNames = new String[]{Messages.getString("ChartDataBindingPage.Lbl.Parameter"), Messages.getString("ChartDataBindingPage.Lbl.DataType"), Messages.getString("ChartDataBindingPage.Lbl.Value")};
    private ExpressionDialogCellEditor expressionCellEditor;
    private static IChoiceSet DataTypes = DesignEngine.getMetaDataDictionary().getChoiceSet("columnDataType");
    private static final String DEFAULT_VALUE_LABEL = Messages.getString("ChartDataBindingPage.Lbl.DefaultValue");
    private ReportItemHandle reportItemHandle = null;

    public ReportItemParametersDialog(ReportItemHandle reportItemHandle) {
        super(Messages.getString("ChartDataBindingPage.Lbl.Parameter"));
        this.reportItemHandle = reportItemHandle;
    }

    protected Control createDialogArea(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.DataSetParameter_ID");
        Composite composite = (Composite)super.createDialogArea(parent);
        this.buildUI(composite);
        Object[] descriptors = this.propertiesMap.values().toArray();
        int i = 0;
        while (i < descriptors.length) {
            IPropertyDescriptor descriptor = (IPropertyDescriptor)descriptors[i];
            ArrayList<ReportItemHandle> input = new ArrayList<ReportItemHandle>();
            input.add(this.reportItemHandle);
            descriptor.setInput(input);
            ++i;
        }
        this.refreshValues();
        return composite;
    }

    private void buildUI(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        parent.setLayout((Layout)layout);
        this.table = new Table(parent, 68356);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 100;
        this.table.setLayoutData((Object)gridData);
        int i = 0;
        while (i < columnNames.length) {
            TableColumn column = new TableColumn(this.table, 16384);
            column.setText(columnNames[i]);
            if (i == 1) {
                column.setWidth(80);
            } else {
                column.setWidth(160);
            }
            ++i;
        }
        this.table.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 32) {
                    String oldValue;
                    int selectionIndex = ReportItemParametersDialog.this.table.getSelectionIndex();
                    if (selectionIndex < 0) {
                        return;
                    }
                    TableItem item = ReportItemParametersDialog.this.table.getItem(selectionIndex);
                    Object[] pair = (Object[])item.getData();
                    DataSetParameterHandle dataHandle = (DataSetParameterHandle)pair[0];
                    ParamBindingHandle bindingHandle = (ParamBindingHandle)pair[1];
                    String string = oldValue = bindingHandle == null ? null : bindingHandle.getExpression();
                    if (oldValue == null) {
                        oldValue = dataHandle.getDefaultValue();
                    }
                    String value = ReportItemParametersDialog.this.expressionCellEditor.openDialogBox((Control)ReportItemParametersDialog.this.table, oldValue);
                    ReportItemParametersDialog.this.setValue(bindingHandle, value, item);
                }
            }
        });
        this.createTableViewer();
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x860 | 0x10 | 0x10000);
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(columnNames);
        this.expressionCellEditor = new ExpressionDialogCellEditor((Composite)this.table);
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[2] = this.expressionCellEditor;
        this.tableViewer.setCellEditors(cellEditorArray);
        this.tableViewer.setContentProvider((IContentProvider)new BindingContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new BindingLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new BindingCellModifier());
    }

    private void refreshValues() {
        this.reconstructTable();
        this.updateBindingData();
    }

    private void reconstructTable() {
        this.tableViewer.setInput((Object)this.reportItemHandle);
        this.expressionCellEditor.setItemHandle(this.reportItemHandle.getContainer());
    }

    private void updateBindingData() {
        if (DEUtil.getDataSetList((DesignElementHandle)this.reportItemHandle).size() == 0) {
            return;
        }
        Iterator iterator = this.reportItemHandle.paramBindingsIterator();
        while (iterator != null && iterator.hasNext()) {
            ParamBindingHandle handle = (ParamBindingHandle)iterator.next();
            String expression = handle.getExpression();
            int rowIndex = this.bindingParametersList.indexOf(handle);
            if (rowIndex == -1 || expression == null) continue;
            this.table.getItem(rowIndex).setText(columnNames.length - 1, expression);
            TableItem item = this.table.getItem(rowIndex);
            if (item.getData(Binding) != null) continue;
            item.setData(Binding, (Object)handle);
        }
    }

    private ParamBindingHandle createBindingHandle(String name) throws SemanticException {
        PropertyHandle propertyHandle = this.getPropertyHandle();
        ParamBinding binding = StructureFactory.createParamBinding();
        binding.setParamName(name);
        propertyHandle.addItem((IStructure)binding);
        return (ParamBindingHandle)binding.getHandle((SimpleValueHandle)propertyHandle);
    }

    private PropertyHandle getPropertyHandle() {
        return this.reportItemHandle.getPropertyHandle("paramBindings");
    }

    protected DataSetHandle getDataSetFromHandle() {
        if (this.reportItemHandle.getDataSet() != null) {
            return this.reportItemHandle.getDataSet();
        }
        List datasetList = DEUtil.getDataSetList((DesignElementHandle)this.reportItemHandle.getContainer());
        if (datasetList.size() > 0) {
            return (DataSetHandle)datasetList.get(0);
        }
        return null;
    }

    private void setValue(ParamBindingHandle bindingHandle, Object value, TableItem item) {
        if ((value == null || "".equals(value)) && bindingHandle != null) {
            try {
                this.getPropertyHandle().removeItem((Object)bindingHandle.getStructure());
            }
            catch (PropertyValueException e) {
                e.printStackTrace();
                return;
            }
        }
        if (bindingHandle == null) {
            try {
                bindingHandle = this.createBindingHandle(item.getText(0));
            }
            catch (SemanticException e) {
                e.printStackTrace();
                return;
            }
        }
        bindingHandle.setExpression((String)value);
        this.reconstructTable();
    }

    private class BindingCellModifier
    implements ICellModifier {
        private BindingCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property.equals(columnNames[2]);
        }

        public Object getValue(Object element, String property) {
            ParamBindingHandle bindingParameter = (ParamBindingHandle)((Object[])element)[1];
            if (bindingParameter != null) {
                return bindingParameter.getExpression();
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            int index;
            Object model = element;
            if (element instanceof Item) {
                model = ((Item)element).getData();
            }
            if ((index = ReportItemParametersDialog.this.resultList.indexOf(model)) != -1) {
                Object[] pair = (Object[])model;
                ParamBindingHandle bindingHandle = (ParamBindingHandle)pair[1];
                ReportItemParametersDialog.this.setValue(bindingHandle, value, (TableItem)element);
            }
        }
    }

    private class BindingContentProvider
    implements IStructuredContentProvider {
        private BindingContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ParamBindingHandle handle;
            if (inputElement == null) {
                return new Object[0];
            }
            ReportItemHandle inputHandle = (ReportItemHandle)inputElement;
            DataSetHandle dataHandle = ReportItemParametersDialog.this.getDataSetFromHandle();
            if (dataHandle == null) {
                return new Object[0];
            }
            ReportItemParametersDialog.this.bindingParametersList = new ArrayList();
            ArrayList<String> bindingParametersNameList = new ArrayList<String>();
            ReportItemParametersDialog.this.resultList = new ArrayList();
            Iterator iterator = inputHandle.paramBindingsIterator();
            while (iterator.hasNext()) {
                handle = (ParamBindingHandle)iterator.next();
                ReportItemParametersDialog.this.bindingParametersList.add(handle);
                bindingParametersNameList.add(handle.getParamName());
            }
            iterator = dataHandle.parametersIterator();
            while (iterator.hasNext()) {
                handle = (DataSetParameterHandle)iterator.next();
                Object[] objectArray = new Object[2];
                objectArray[0] = handle;
                Object[] result = objectArray;
                int index = bindingParametersNameList.indexOf(handle.getName());
                if (index != -1) {
                    result[1] = ReportItemParametersDialog.this.bindingParametersList.get(index);
                }
                ReportItemParametersDialog.this.resultList.add(result);
            }
            return ReportItemParametersDialog.this.resultList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class BindingLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private BindingLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = "";
            DataSetParameterHandle parameter = (DataSetParameterHandle)((Object[])element)[0];
            ParamBindingHandle bindingParameter = (ParamBindingHandle)((Object[])element)[1];
            switch (columnIndex) {
                case 0: {
                    if (parameter.getName() == null) break;
                    text = parameter.getName();
                    break;
                }
                case 1: {
                    if (parameter.getDataType() == null) break;
                    text = ChoiceSetFactory.getDisplayNameFromChoiceSet((String)parameter.getDataType(), (IChoiceSet)DataTypes);
                    break;
                }
                case 2: {
                    if (bindingParameter != null && bindingParameter.getExpression() != null) {
                        text = bindingParameter.getExpression();
                        break;
                    }
                    if (parameter.getDefaultValue() == null) break;
                    text = String.valueOf(parameter.getDefaultValue()) + " " + DEFAULT_VALUE_LABEL;
                }
            }
            return text;
        }
    }
}

