/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.impl;

import com.ibm.icu.util.ULocale;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.Properties;
import java.util.logging.Level;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.birt.data.oda.mongodb.impl.DataSetMetaData;
import org.eclipse.birt.data.oda.mongodb.impl.MDbQuery;
import org.eclipse.birt.data.oda.mongodb.impl.MongoDBDriver;
import org.eclipse.birt.data.oda.mongodb.nls.Messages;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class MDbConnection
implements IConnection {
    private MongoDatabase m_mongoDbInstance;

    public void open(Properties connProperties) throws OdaException {
        MongoDatabase dbInstance;
        if (this.isOpen()) {
            return;
        }
        this.m_mongoDbInstance = dbInstance = MDbConnection.getMongoDatabase(connProperties);
    }

    public static MongoDatabase getMongoDatabase(Properties connProperties) throws OdaException {
        MongoClient mongoClient = MongoDBDriver.getMongoNode(connProperties);
        String dbName = MongoDBDriver.getDatabaseName(connProperties);
        if (dbName == null || dbName.isEmpty()) {
            throw new OdaException(Messages.mDbConnection_missingValueDBName);
        }
        MongoDatabase dbInstance = null;
        try {
            Boolean dbExists = MDbConnection.existsDatabase(mongoClient, dbName, connProperties);
            if (dbExists != null && !dbExists.booleanValue()) {
                throw new OdaException(Messages.bind((String)Messages.mDbConnection_invalidDatabaseName, (Object)dbName));
            }
            dbInstance = mongoClient.getDatabase(dbName);
            MDbConnection.authenticateDB(dbInstance, connProperties);
        }
        catch (Exception ex) {
            MongoDBDriver.getLogger().log(Level.SEVERE, "Unable to get Database " + dbName + ". " + ex.getMessage(), ex);
            throw new OdaException((Throwable)ex);
        }
        return dbInstance;
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
        this.m_mongoDbInstance = null;
    }

    public boolean isOpen() throws OdaException {
        return this.m_mongoDbInstance != null;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new DataSetMetaData(this);
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        if (!this.isOpen()) {
            throw new OdaException(Messages.mDbConnection_noConnection);
        }
        return new MDbQuery(this);
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }

    public void commit() throws OdaException {
    }

    public void rollback() throws OdaException {
    }

    public void setLocale(ULocale locale) throws OdaException {
    }

    MongoDatabase getConnectedDB() {
        return this.m_mongoDbInstance;
    }

    static void authenticateDB(MongoDatabase mongoDb, Properties connProps) throws OdaException {
        try {
            mongoDb.runCommand((Bson)new Document("ping", (Object)1));
        }
        catch (Exception ex) {
            OdaException odaEx = new OdaException((Throwable)ex);
            String username = MongoDBDriver.getUserName(connProps);
            MongoDBDriver.getLogger().info(Messages.bind((String)"Unable to authenticate user (${0}) in database (${1}).\n ${2}", (Object[])new Object[]{username, mongoDb, odaEx.getCause().getMessage()}));
            throw odaEx;
        }
    }

    private static Boolean existsDatabase(MongoClient mongoClient, String dbName, Properties connProps) throws OdaException {
        if (dbName == null) {
            return false;
        }
        try {
            MongoIterable databaseNameIterable = mongoClient.listDatabaseNames();
            for (String databaseName : databaseNameIterable) {
                if (!dbName.equals(databaseName)) continue;
                return true;
            }
            return false;
        }
        catch (MongoException ex) {
            MongoDBDriver.getLogger().log(Level.SEVERE, "Unable to connect host", ex);
            throw new OdaException((Throwable)ex);
        }
    }
}

