/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.data.util.BufferedRandomAccessFile;
import org.eclipse.birt.data.engine.olap.data.util.IObjectWriter;

class BigDecimalRandomWriter
implements IObjectWriter {
    private static Logger logger = Logger.getLogger(BigDecimalRandomWriter.class.getName());

    BigDecimalRandomWriter() {
    }

    @Override
    public void write(BufferedRandomAccessFile file, Object obj) throws IOException {
        try {
            if (obj instanceof BigDecimal) {
                file.writeBigDecimal((BigDecimal)obj);
            } else {
                file.writeBigDecimal(BigDecimal.valueOf(((Number)obj).doubleValue()));
            }
        }
        catch (ClassCastException ce) {
            logger.log(Level.FINE, ce.getMessage(), ce);
        }
    }
}

