/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.timefunction.ITimeFunction;
import org.eclipse.birt.data.engine.api.timefunction.ITimePeriod;
import org.eclipse.birt.data.engine.api.timefunction.TimePeriodType;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.ExprUtil;
import org.eclipse.birt.data.engine.olap.api.query.IComputedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDrillFilter;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.IncrementExecutionHint;

public class CubeQueryDefinitionUtil {
    private CubeQueryDefinitionUtil() {
    }

    public static IncrementExecutionHint getIncrementExecutionHint(ICubeQueryDefinition basedQuery, ICubeQueryDefinition newQuery) throws DataException {
        if (!(basedQuery.getFilterOption() == newQuery.getFilterOption() && CubeQueryDefinitionUtil.isEqualMeasures(basedQuery.getMeasures(), newQuery.getMeasures()) && CubeQueryDefinitionUtil.isEqualMeasures(basedQuery.getComputedMeasures(), newQuery.getComputedMeasures()) && CubeQueryDefinitionUtil.isEqualEdges(basedQuery, newQuery))) {
            return null;
        }
        if (!CubeQueryDefinitionUtil.isEqualCubeOperations(basedQuery.getCubeOperations(), newQuery.getCubeOperations())) {
            return null;
        }
        IncrementExecutionHint ieh = new IncrementExecutionHint();
        IBinding[] bindings = CubeQueryDefinitionUtil.getIncrementBindings(basedQuery, newQuery);
        if (bindings == null) {
            return null;
        }
        ieh.setBindings(bindings);
        IFilterDefinition[] filters = CubeQueryDefinitionUtil.getIncrementFilters(basedQuery, newQuery);
        if (filters == null) {
            return null;
        }
        ieh.setFilters(filters);
        ISortDefinition[] sorts = CubeQueryDefinitionUtil.getIncrementSorts(basedQuery, newQuery);
        ieh.setSorts(sorts);
        return ieh;
    }

    private static IBinding[] getIncrementBindings(ICubeQueryDefinition basedQuery, ICubeQueryDefinition newQuery) throws DataException {
        if (newQuery.getBindings().size() < basedQuery.getBindings().size()) {
            return null;
        }
        Iterator itr1 = basedQuery.getBindings().iterator();
        Iterator itr2 = newQuery.getBindings().iterator();
        HashMap<String, IBinding> bindings1 = new HashMap<String, IBinding>();
        HashMap<String, IBinding> bindings2 = new HashMap<String, IBinding>();
        while (itr1.hasNext()) {
            IBinding b1 = (IBinding)itr1.next();
            IBinding b2 = (IBinding)itr2.next();
            bindings1.put(b1.getBindingName(), b1);
            bindings2.put(b2.getBindingName(), b2);
        }
        while (itr2.hasNext()) {
            IBinding b2 = (IBinding)itr2.next();
            bindings2.put(b2.getBindingName(), b2);
        }
        for (String name : bindings1.keySet()) {
            IBinding b2 = (IBinding)bindings2.get(name);
            if (b2 == null) {
                return null;
            }
            if (!CubeQueryDefinitionUtil.isEqual((IBinding)bindings1.get(name), b2)) {
                return null;
            }
            bindings2.remove(name);
        }
        if (!bindings2.isEmpty()) {
            return null;
        }
        return new IBinding[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IFilterDefinition[] getIncrementFilters(ICubeQueryDefinition basedQuery, ICubeQueryDefinition newQuery) throws DataException {
        if (newQuery.getFilters().size() < basedQuery.getFilters().size()) {
            return null;
        }
        List baseFilters = basedQuery.getFilters();
        List newFilters = newQuery.getFilters();
        ArrayList<IFilterDefinition> resultFilters = new ArrayList<IFilterDefinition>();
        int i = 0;
        while (i < newFilters.size()) {
            IFilterDefinition filter = (IFilterDefinition)newFilters.get(i);
            boolean find = false;
            int j = 0;
            while (j < baseFilters.size()) {
                if (CubeQueryDefinitionUtil.isEqual((IFilterDefinition)newFilters.get(i), (IFilterDefinition)baseFilters.get(j))) {
                    if (((IFilterDefinition)newFilters.get(i)).updateAggregation() != ((IFilterDefinition)baseFilters.get(j)).updateAggregation()) return null;
                    find = true;
                    break;
                }
                ++j;
            }
            if (!find) {
                if (filter.updateAggregation() || newQuery.getFilters().size() <= basedQuery.getFilters().size()) return null;
                resultFilters.add(filter);
            } else if (filter.updateAggregation()) {
                return null;
            }
            ++i;
        }
        return resultFilters.toArray(new IFilterDefinition[0]);
    }

    private static ISortDefinition[] getIncrementSorts(ICubeQueryDefinition basedQuery, ICubeQueryDefinition newQuery) throws DataException {
        if (CubeQueryDefinitionUtil.isEqualSorts(basedQuery.getSorts(), newQuery.getSorts())) {
            return new ISortDefinition[0];
        }
        List result = newQuery.getSorts();
        return result.toArray(new ISortDefinition[0]);
    }

    private static boolean isEqual(IFilterDefinition fd1, IFilterDefinition fd2) {
        if (fd1 == null) {
            return fd2 == null;
        }
        if (fd2 == null || !fd1.getClass().equals(fd2.getClass()) || !ExprUtil.isEqualExpression(fd1.getExpression(), fd2.getExpression())) {
            return false;
        }
        if (fd1 instanceof ICubeSortDefinition) {
            ICubeFilterDefinition cfd1 = (ICubeFilterDefinition)fd1;
            ICubeFilterDefinition cfd2 = (ICubeFilterDefinition)fd2;
            if (!CubeQueryDefinitionUtil.isEqual(cfd1.getTargetLevel(), cfd2.getTargetLevel())) {
                return false;
            }
            if (!Arrays.deepEquals(cfd1.getAxisQualifierValues(), cfd2.getAxisQualifierValues())) {
                return false;
            }
            if (cfd1.getAxisQualifierLevels() == null) {
                return cfd2.getAxisQualifierLevels() == null;
            }
            if (cfd1.getAxisQualifierLevels().length != cfd2.getAxisQualifierLevels().length) {
                return false;
            }
            int i = 0;
            ILevelDefinition[] iLevelDefinitionArray = cfd1.getAxisQualifierLevels();
            int n = iLevelDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILevelDefinition ld = iLevelDefinitionArray[n2];
                if (!CubeQueryDefinitionUtil.isEqual(ld, cfd2.getAxisQualifierLevels()[i])) {
                    return false;
                }
                ++i;
                ++n2;
            }
        }
        return true;
    }

    private static boolean isEqual(IBinding b1, IBinding b2) throws DataException {
        if (!(b1.getBindingName().equals(b2.getBindingName()) && b1.getDataType() == b2.getDataType() && CubeQueryDefinitionUtil.isEqual(b1.getAggrFunction(), b2.getAggrFunction()) && ExprUtil.isEqualExpression(b1.getExpression(), b2.getExpression()))) {
            return false;
        }
        if (!ExprUtil.isEqualExpression(b1.getFilter(), b2.getFilter())) {
            return false;
        }
        if (b1.getArguments().size() != b2.getArguments().size()) {
            return false;
        }
        Iterator itr1 = b1.getArguments().iterator();
        Iterator itr2 = b2.getArguments().iterator();
        while (itr1.hasNext()) {
            IBaseExpression expr2;
            IBaseExpression expr1 = (IBaseExpression)itr1.next();
            if (ExprUtil.isEqualExpression(expr1, expr2 = (IBaseExpression)itr2.next())) continue;
            return false;
        }
        if (!Arrays.deepEquals(b1.getAggregatOns().toArray(), b2.getAggregatOns().toArray())) {
            return false;
        }
        return CubeQueryDefinitionUtil.isEqualTimeFunction(b1.getTimeFunction(), b2.getTimeFunction());
    }

    private static boolean isEqual(String s1, String s2) {
        if (s1 == null) {
            return s1 == s2;
        }
        return s1.equals(s2);
    }

    private static boolean isEqual(IDimensionDefinition dd1, IDimensionDefinition dd2) {
        if (dd1 == null) {
            return dd2 == null;
        }
        if (dd2 == null || !CubeQueryDefinitionUtil.isEqual(dd1.getName(), dd2.getName()) || dd1.getHierarchy().size() != dd2.getHierarchy().size()) {
            return false;
        }
        int i = 0;
        for (IHierarchyDefinition hd : dd1.getHierarchy()) {
            if (!CubeQueryDefinitionUtil.isEqual(hd.getName(), dd2.getHierarchy().get(i).getName())) {
                return false;
            }
            if (hd.getLevels().size() != dd2.getHierarchy().get(i).getLevels().size()) {
                return false;
            }
            int j = 0;
            for (ILevelDefinition ld : hd.getLevels()) {
                if (!CubeQueryDefinitionUtil.isEqual(ld.getName(), dd2.getHierarchy().get(i).getLevels().get(j).getName())) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private static boolean isEqual(IHierarchyDefinition hd1, IHierarchyDefinition hd2) {
        if (hd1 == null) {
            return hd2 == null;
        }
        if (hd2 == null || !CubeQueryDefinitionUtil.isEqual(hd1.getName(), hd2.getName()) || hd1.getLevels().size() != hd2.getLevels().size()) {
            return false;
        }
        int j = 0;
        for (ILevelDefinition ld : hd1.getLevels()) {
            if (!CubeQueryDefinitionUtil.isEqual(ld.getName(), hd2.getLevels().get(j).getName())) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private static boolean isEqual(ILevelDefinition ld1, ILevelDefinition ld2) {
        if (ld1 == null) {
            return ld2 == null;
        }
        if (ld2 == null || !CubeQueryDefinitionUtil.isEqual(ld1.getName(), ld2.getName())) {
            return false;
        }
        return CubeQueryDefinitionUtil.isEqual(ld1.getHierarchy(), ld2.getHierarchy());
    }

    private static boolean isEqual(IMeasureDefinition md1, IMeasureDefinition md2) throws DataException {
        if (md1 == null) {
            return md2 == null;
        }
        if (!(md2 != null && md1.getClass().equals(md2.getClass()) && CubeQueryDefinitionUtil.isEqual(md1.getName(), md2.getName()) && CubeQueryDefinitionUtil.isEqual(md1.getAggrFunction(), md2.getAggrFunction()))) {
            return false;
        }
        if (md1 instanceof IComputedMeasureDefinition) {
            IComputedMeasureDefinition cmd1 = (IComputedMeasureDefinition)md1;
            IComputedMeasureDefinition cmd2 = (IComputedMeasureDefinition)md1;
            if (!ExprUtil.isEqualExpression(cmd1.getExpression(), cmd2.getExpression())) {
                return false;
            }
            return cmd1.getDataType() == cmd2.getDataType();
        }
        return true;
    }

    private static boolean isEqualMeasures(List<IMeasureDefinition> mds1, List<IMeasureDefinition> mds2) throws DataException {
        if (mds1.size() != mds2.size()) {
            return false;
        }
        HashMap<String, IMeasureDefinition> map1 = new HashMap<String, IMeasureDefinition>();
        HashMap<String, IMeasureDefinition> map2 = new HashMap<String, IMeasureDefinition>();
        Iterator<IMeasureDefinition> itr1 = mds1.iterator();
        Iterator<IMeasureDefinition> itr2 = mds2.iterator();
        while (itr1.hasNext()) {
            IMeasureDefinition md1 = itr1.next();
            IMeasureDefinition md2 = itr2.next();
            map1.put(md1.getName(), md1);
            map2.put(md2.getName(), md2);
        }
        for (String name : map1.keySet()) {
            IMeasureDefinition md2 = (IMeasureDefinition)map2.get(name);
            if (md2 != null && CubeQueryDefinitionUtil.isEqual((IMeasureDefinition)map1.get(name), md2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqualEdges(ICubeQueryDefinition cqd1, ICubeQueryDefinition cqd2) {
        return CubeQueryDefinitionUtil.isEqual(cqd1.getEdge(1), cqd2.getEdge(1)) && CubeQueryDefinitionUtil.isEqual(cqd1.getEdge(2), cqd2.getEdge(2)) && CubeQueryDefinitionUtil.isEqual(cqd1.getEdge(3), cqd2.getEdge(3));
    }

    private static boolean isEqual(IEdgeDefinition ed1, IEdgeDefinition ed2) {
        if (ed1 == null) {
            return ed2 == null;
        }
        if (ed2 == null || !CubeQueryDefinitionUtil.isEqual(ed1.getName(), ed2.getName()) || ed1.getDimensions().size() != ed2.getDimensions().size()) {
            return false;
        }
        int i = 0;
        for (IDimensionDefinition dd : ed1.getDimensions()) {
            if (!CubeQueryDefinitionUtil.isEqual(dd, ed2.getDimensions().get(i))) {
                return false;
            }
            ++i;
        }
        if (ed1.getMirroredDefinition() == null) {
            if (ed2.getMirroredDefinition() != null) {
                return false;
            }
        } else {
            if (ed2.getMirroredDefinition() == null) {
                return false;
            }
            if (!CubeQueryDefinitionUtil.isEqual(ed1.getMirroredDefinition().getMirrorStartingLevel(), ed2.getMirroredDefinition().getMirrorStartingLevel())) {
                return false;
            }
            if (ed1.getMirroredDefinition().isBreakHierarchy() != ed2.getMirroredDefinition().isBreakHierarchy()) {
                return false;
            }
        }
        if (ed1.getDrillFilter().size() != ed2.getDrillFilter().size()) {
            return false;
        }
        i = 0;
        for (IEdgeDrillFilter edf : ed1.getDrillFilter()) {
            if (!CubeQueryDefinitionUtil.isEqual(edf, ed2.getDrillFilter().get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isEqual(IEdgeDrillFilter edf1, IEdgeDrillFilter edf2) {
        if (edf1 == null) {
            return edf2 == null;
        }
        if (edf2 == null || edf1.getLevelFilter().size() != edf2.getLevelFilter().size()) {
            return false;
        }
        Iterator<Object> itr1 = edf1.getLevelFilter().iterator();
        Iterator<Object> itr2 = edf2.getLevelFilter().iterator();
        while (itr1.hasNext()) {
            if (CubeQueryDefinitionUtil.isEqual(itr1.next(), itr2.next())) continue;
            return false;
        }
        if (edf1.getLevelSort().size() != edf2.getLevelSort().size()) {
            return false;
        }
        itr1 = edf1.getLevelSort().iterator();
        itr2 = edf2.getLevelSort().iterator();
        while (itr1.hasNext()) {
            if (CubeQueryDefinitionUtil.isEqual((ISortDefinition)itr1.next(), (ISortDefinition)itr2.next())) continue;
            return false;
        }
        if (!CubeQueryDefinitionUtil.isEqual(edf1.getTargetHierarchy(), edf2.getTargetHierarchy())) {
            return false;
        }
        if (!CubeQueryDefinitionUtil.isEqual(edf1.getTargetLevelName(), edf2.getTargetLevelName())) {
            return false;
        }
        return Arrays.deepEquals(edf1.getTuple().toArray(), edf2.getTuple().toArray());
    }

    private static boolean isEqual(ULocale l1, ULocale l2) {
        if (l1 == null) {
            return l2 == null;
        }
        if (l2 == null) {
            return false;
        }
        return CubeQueryDefinitionUtil.isEqual(l1.getBaseName(), l2.getBaseName());
    }

    private static boolean isEqual(ISortDefinition sd1, ISortDefinition sd2) {
        if (sd1 == null) {
            return sd2 == null;
        }
        if (sd2 == null) {
            return false;
        }
        if (!(sd1.getClass().equals(sd2.getClass()) && CubeQueryDefinitionUtil.isEqual(sd1.getColumn(), sd2.getColumn()) && sd1.getSortDirection() == sd2.getSortDirection() && ExprUtil.isEqualExpression(sd1.getExpression(), sd2.getExpression()) && sd1.getSortStrength() == sd2.getSortStrength() && CubeQueryDefinitionUtil.isEqual(sd1.getSortLocale(), sd2.getSortLocale()))) {
            return false;
        }
        if (sd1 instanceof ICubeSortDefinition) {
            ICubeSortDefinition s1 = (ICubeSortDefinition)sd1;
            ICubeSortDefinition s2 = (ICubeSortDefinition)sd2;
            if (!Arrays.equals(s1.getAxisQualifierValues(), s2.getAxisQualifierValues())) {
                return false;
            }
            if (s1.getAxisQualifierLevels() == null) {
                if (s2.getAxisQualifierLevels() != null) {
                    return false;
                }
            } else {
                if (s2.getAxisQualifierLevels() == null || s1.getAxisQualifierLevels().length != s2.getAxisQualifierLevels().length) {
                    return false;
                }
                int i = 0;
                ILevelDefinition[] iLevelDefinitionArray = s1.getAxisQualifierLevels();
                int n = iLevelDefinitionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILevelDefinition ld = iLevelDefinitionArray[n2];
                    if (!CubeQueryDefinitionUtil.isEqual(ld, s2.getAxisQualifierLevels()[i])) {
                        return false;
                    }
                    ++i;
                    ++n2;
                }
            }
            if (!CubeQueryDefinitionUtil.isEqual(s1.getTargetLevel(), s2.getTargetLevel())) {
                return false;
            }
        }
        return true;
    }

    private static boolean isEqual(ICubeOperation co1, ICubeOperation co2) throws DataException {
        if (co1 == null) {
            return co2 == null;
        }
        if (co2 == null || !co1.getClass().equals(co2.getClass()) || co1.getNewBindings().length != co2.getNewBindings().length) {
            return false;
        }
        int i = 0;
        while (i < co1.getNewBindings().length) {
            if (!CubeQueryDefinitionUtil.isEqual(co1.getNewBindings()[i], co2.getNewBindings()[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isEqualCubeOperations(ICubeOperation[] cos1, ICubeOperation[] cos2) throws DataException {
        if (cos1.length != cos2.length) {
            return false;
        }
        int i = 0;
        while (i < cos1.length) {
            if (!CubeQueryDefinitionUtil.isEqual(cos1[i], cos2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isEqualSorts(List<ISortDefinition> sorts1, List<ISortDefinition> sorts2) {
        if (sorts1.size() != sorts2.size()) {
            return false;
        }
        int i = 0;
        for (ISortDefinition sd : sorts1) {
            if (CubeQueryDefinitionUtil.isEqual(sd, sorts2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqualTimeFunction(ITimeFunction f1, ITimeFunction f2) throws DataException {
        if (f1 == f2) {
            return true;
        }
        if (f1 == null || f2 == null || !CubeQueryDefinitionUtil.isEqual(f1.getTimeDimension(), f2.getTimeDimension())) {
            return false;
        }
        if (f1.getReferenceDate().getDate() != null && !f1.getReferenceDate().getDate().equals(f2.getReferenceDate().getDate())) {
            return false;
        }
        if (f2.getReferenceDate().getDate() != null && !f2.getReferenceDate().getDate().equals(f1.getReferenceDate().getDate())) {
            return false;
        }
        if (!CubeQueryDefinitionUtil.isEqualTimePeriod(f1.getBaseTimePeriod(), f2.getBaseTimePeriod())) {
            return false;
        }
        return CubeQueryDefinitionUtil.isEqualTimePeriod(f1.getRelativeTimePeriod(), f2.getRelativeTimePeriod());
    }

    private static boolean isEqualTimePeriod(ITimePeriod p1, ITimePeriod p2) {
        boolean current2;
        int unit2;
        TimePeriodType type2;
        if (p1 == p2) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        TimePeriodType type1 = p1.getType();
        if (!type1.equals(type2 = p2.getType())) {
            return false;
        }
        int unit1 = p1.countOfUnit();
        if (unit1 != (unit2 = p2.countOfUnit())) {
            return false;
        }
        boolean current1 = p1.isCurrent();
        return current1 == (current2 = p2.isCurrent());
    }
}

