/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;

public class OlapQueryUtil {
    public static List validateBinding(ICubeQueryDefinition queryDefn, boolean suppressException) throws DataException {
        OlapExpressionCompiler.validateDependencyCycle(new HashSet<IBinding>(queryDefn.getBindings()));
        HashSet<IBinding> result = new HashSet<IBinding>();
        HashSet validDimLevels = new HashSet();
        OlapQueryUtil.populateLevel(queryDefn, validDimLevels, 2);
        OlapQueryUtil.populateLevel(queryDefn, validDimLevels, 1);
        OlapQueryUtil.populateLevel(queryDefn, validDimLevels, 3);
        HashMap<IBinding, HashSet<String>> bindingReferences = new HashMap<IBinding, HashSet<String>>();
        HashSet<String> bindingNames = new HashSet<String>();
        int i = 0;
        while (i < queryDefn.getBindings().size()) {
            IBinding binding = (IBinding)queryDefn.getBindings().get(i);
            if (bindingNames.contains(binding.getBindingName())) {
                result.add(binding);
                OlapQueryUtil.throwException(suppressException, new DataException("data.engine.DuplicatedBindingName", binding.getBindingName()));
            } else {
                List<String> references = ExpressionCompilerUtil.extractColumnExpression(binding.getExpression(), "data");
                bindingReferences.put(binding, new HashSet<String>(references));
                bindingNames.add(binding.getBindingName());
                Set levels = OlapExpressionCompiler.getReferencedDimLevel(binding.getExpression(), queryDefn.getBindings());
                if (levels != null && levels.size() > 0 && !validDimLevels.containsAll(levels)) {
                    result.add(binding);
                    OlapQueryUtil.throwException(suppressException, new DataException("data.olap.invalidBindingReferToInexitDim", binding.getBindingName()));
                } else if (binding.getAggregatOns().size() > 0) {
                    if (binding.getAggrFunction() == null) {
                        result.add(binding);
                        OlapQueryUtil.throwException(suppressException, new DataException("data.olap.invalidBindingMissingAggrFunc", binding.getBindingName()));
                    } else {
                        HashSet<DimLevel> lvls = new HashSet<DimLevel>();
                        int j = 0;
                        while (j < binding.getAggregatOns().size()) {
                            lvls.add(OlapExpressionUtil.getTargetDimLevel(binding.getAggregatOns().get(j).toString()));
                            ++j;
                        }
                        if (!validDimLevels.containsAll(lvls)) {
                            result.add(binding);
                            OlapQueryUtil.throwException(suppressException, new DataException("data.olap.invalidBindingReferToInexitDim", binding.getBindingName()));
                        }
                    }
                }
            }
            ++i;
        }
        ICubeOperation[] iCubeOperationArray = queryDefn.getCubeOperations();
        int references = iCubeOperationArray.length;
        int n = 0;
        while (n < references) {
            ICubeOperation co = iCubeOperationArray[n];
            IBinding[] iBindingArray = co.getNewBindings();
            int n2 = iBindingArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IBinding b = iBindingArray[n3];
                if (bindingNames.contains(b.getBindingName())) {
                    result.add(b);
                    OlapQueryUtil.throwException(suppressException, new DataException("data.engine.DuplicatedBindingName", b.getBindingName()));
                }
                bindingNames.add(b.getBindingName());
                ++n3;
            }
            ++n;
        }
        for (Map.Entry entry : bindingReferences.entrySet()) {
            for (String reference : (Set)entry.getValue()) {
                if (bindingNames.contains(reference)) continue;
                result.add((IBinding)entry.getKey());
                OlapQueryUtil.throwException(suppressException, new DataException("data.olap.referencedBindingNotExist", reference));
            }
        }
        return new ArrayList(result);
    }

    private static void throwException(boolean suppressException, DataException e) throws DataException {
        if (!suppressException) {
            throw e;
        }
    }

    private static void populateLevel(ICubeQueryDefinition queryDefn, Set validDimLevels, int edgeType) {
        if (queryDefn.getEdge(edgeType) == null) {
            return;
        }
        int i = 0;
        while (i < queryDefn.getEdge(edgeType).getDimensions().size()) {
            int j = 0;
            while (j < OlapQueryUtil.getHierarchy(queryDefn, edgeType, i).getLevels().size()) {
                ILevelDefinition level = OlapQueryUtil.getHierarchy(queryDefn, edgeType, i).getLevels().get(j);
                validDimLevels.add(new DimLevel(OlapQueryUtil.getDimension(queryDefn, edgeType, i).getName(), level.getName()));
                ++j;
            }
            ++i;
        }
    }

    private static IHierarchyDefinition getHierarchy(ICubeQueryDefinition queryDefn, int edgeType, int i) {
        return OlapQueryUtil.getDimension(queryDefn, edgeType, i).getHierarchy().get(0);
    }

    private static IDimensionDefinition getDimension(ICubeQueryDefinition queryDefn, int edgeType, int i) {
        return queryDefn.getEdge(edgeType).getDimensions().get(i);
    }
}

