/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.script.model;

import com.ibm.icu.util.ULocale;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.debug.internal.core.vm.ReportVMClient;
import org.eclipse.birt.report.debug.internal.core.vm.VMBreakPoint;
import org.eclipse.birt.report.debug.internal.core.vm.VMContextData;
import org.eclipse.birt.report.debug.internal.core.vm.VMException;
import org.eclipse.birt.report.debug.internal.core.vm.VMListener;
import org.eclipse.birt.report.debug.internal.core.vm.VMStackFrame;
import org.eclipse.birt.report.debug.internal.core.vm.VMValue;
import org.eclipse.birt.report.debug.internal.core.vm.VMVariable;
import org.eclipse.birt.report.debug.internal.core.vm.js.JsLineBreakPoint;
import org.eclipse.birt.report.debug.internal.core.vm.js.JsTransientLineBreakPoint;
import org.eclipse.birt.report.debug.internal.script.model.ScriptDebugElement;
import org.eclipse.birt.report.debug.internal.script.model.ScriptDebugThread;
import org.eclipse.birt.report.debug.internal.script.model.ScriptLineBreakpoint;
import org.eclipse.birt.report.debug.internal.script.model.ScriptStackFrame;
import org.eclipse.birt.report.debug.internal.script.model.ScriptValue;
import org.eclipse.birt.report.debug.internal.script.model.ScriptVariable;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public class ScriptDebugTarget
extends ScriptDebugElement
implements IDebugTarget,
IBreakpointManagerListener,
VMListener {
    private ModuleHandle handle;
    private static final Logger logger = Logger.getLogger(ScriptDebugTarget.class.getName());
    private IProcess process;
    private ScriptDebugThread thread;
    private IThread[] threads;
    private String name;
    ReportVMClient reportVM;
    private ILaunch launch;
    private List breakPoints = new ArrayList();
    private String fileName = "";
    private int listenPort;
    private boolean fTerminating;
    private boolean fTerminated;

    public ScriptDebugTarget(ILaunch launch, ReportVMClient vm, String name, IProcess process, int listenPort, String tempFolder, IProgressMonitor monitor) {
        super(null);
        this.launch = launch;
        this.reportVM = vm;
        this.name = name;
        this.process = process;
        this.listenPort = listenPort;
        launch.addDebugTarget((IDebugTarget)this);
        vm.addVMListener((VMListener)this);
        this.setTerminating(false);
        this.setTerminated(false);
        this.thread = new ScriptDebugThread(this);
        this.threads = new IThread[]{this.thread};
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointManagerListener((IBreakpointManagerListener)this);
        while (!this.isTerminated()) {
            if (monitor.isCanceled()) {
                try {
                    this.terminate();
                    continue;
                }
                catch (DebugException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            try {
                vm.connect(listenPort);
                break;
            }
            catch (VMException e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public ModuleHandle getModuleHandle() {
        if (this.handle == null) {
            try {
                this.handle = this.getSessionHandle().openModule(this.getFileName(), (InputStream)new FileInputStream(this.getFileName()));
            }
            catch (FileNotFoundException | DesignFileException throwable) {
                // empty catch block
            }
        }
        return this.handle;
    }

    private SessionHandle getSessionHandle() {
        return new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.getDefault());
    }

    @Override
    public IDebugTarget getDebugTarget() {
        return this;
    }

    public String getName() throws DebugException {
        if (this.name == null) {
            this.name = this.getDefaultName();
            try {
                this.name = this.getLaunch().getLaunchConfiguration().getAttribute("org.eclipse.birt.report.debug.script.model.ATTR_REPORT_PROGRAM", this.name);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return String.valueOf(this.renderState()) + this.name;
    }

    private String renderState() {
        if (this.isTerminated()) {
            return "<terminated>";
        }
        if (this.isDisconnected()) {
            return "<disconnected>";
        }
        return "";
    }

    private String getDefaultName() {
        return "Report Script Running at localhost:" + this.listenPort;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public IThread[] getThreads() throws DebugException {
        return this.threads;
    }

    public boolean hasThreads() throws DebugException {
        return !this.isTerminated() && !this.isDisconnected();
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (!(breakpoint instanceof ScriptLineBreakpoint)) {
            return false;
        }
        String str = ((ScriptLineBreakpoint)breakpoint).getFileName();
        if (str == null || str.length() == 0) {
            return false;
        }
        return str.equals(this.getFileName());
    }

    public boolean canTerminate() {
        return !this.isTerminated() && !this.isTerminating();
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    private void setTerminated(boolean terminated) {
        this.fTerminated = terminated;
    }

    public void terminate() throws DebugException {
        this.setTerminating(true);
        try {
            if (!this.isTerminated() && this.reportVM.isTerminated()) {
                this.terminated();
                return;
            }
        }
        catch (VMException e1) {
            logger.warning(e1.getMessage());
        }
        try {
            this.reportVM.terminate();
        }
        catch (VMException e) {
            logger.warning(e.getMessage());
        }
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        try {
            return this.reportVM.isSuspended();
        }
        catch (VMException e) {
            return true;
        }
    }

    public void resume() throws DebugException {
        try {
            this.reportVM.resume();
        }
        catch (VMException e) {
            logger.warning(e.getMessage());
        }
    }

    public void suspend() throws DebugException {
        try {
            this.reportVM.suspend();
        }
        catch (VMException e) {
            logger.warning(e.getMessage());
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (!this.supportsBreakpoint(breakpoint)) {
            return;
        }
        try {
            if (!breakpoint.isEnabled()) {
                return;
            }
        }
        catch (CoreException e1) {
            return;
        }
        ScriptLineBreakpoint scriptPoint = (ScriptLineBreakpoint)breakpoint;
        try {
            if (scriptPoint.shouldSkipBreakpoint()) {
                return;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        JsLineBreakPoint point = this.createJsLineBreakPoint(scriptPoint);
        try {
            if ("run to line".equals(((ScriptLineBreakpoint)breakpoint).getType())) {
                this.reportVM.addBreakPoint((VMBreakPoint)point);
            } else if (!this.breakPoints.contains(point)) {
                this.breakPoints.add(point);
                this.reportVM.addBreakPoint((VMBreakPoint)point);
            }
        }
        catch (VMException e) {
            logger.warning(e.getMessage());
        }
    }

    private JsLineBreakPoint createJsLineBreakPoint(ScriptLineBreakpoint breakpoint) {
        if ("run to line".equals(breakpoint.getType())) {
            return new JsTransientLineBreakPoint(breakpoint.getSubName(), breakpoint.getScriptLineNumber());
        }
        return new JsLineBreakPoint(breakpoint.getSubName(), breakpoint.getScriptLineNumber());
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!this.supportsBreakpoint(breakpoint)) {
            return;
        }
        try {
            if (breakpoint.isEnabled()) {
                this.breakpointAdded(breakpoint);
            } else {
                this.breakpointRemoved(breakpoint, null);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!this.supportsBreakpoint(breakpoint)) {
            return;
        }
        JsLineBreakPoint point = new JsLineBreakPoint(((ScriptLineBreakpoint)breakpoint).getSubName(), ((ScriptLineBreakpoint)breakpoint).getScriptLineNumber());
        if (this.breakPoints.contains(point)) {
            this.breakPoints.remove(point);
            try {
                this.reportVM.removeBreakPoint((VMBreakPoint)point);
            }
            catch (VMException e) {
                logger.warning(e.getMessage());
            }
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    @Override
    public ILaunch getLaunch() {
        return this.launch;
    }

    public void handleEvent(int eventCode, VMContextData context) {
        if (eventCode == 13) {
            this.suspended(8);
            this.thread.setStepping(false);
        } else if (eventCode == 12) {
            this.suspended(8);
            this.thread.setStepping(false);
        } else if (eventCode == 14) {
            this.suspended(8);
            this.thread.setStepping(false);
        } else if (eventCode == 9) {
            this.started();
        } else if (eventCode == 7) {
            this.suspended(16);
        } else if (eventCode == 8) {
            this.suspended(32);
        } else if (eventCode == 10) {
            this.terminated();
        } else if (eventCode == 11) {
            this.resumed(1);
        }
    }

    private void resumed(int detail) {
        this.thread.fireResumeEvent(detail);
    }

    private void started() {
        this.installDeferredBreakpoints();
        try {
            this.reportVM.resume();
        }
        catch (VMException e) {
            logger.warning(e.getMessage());
        }
        this.fireCreationEvent();
    }

    private void installDeferredBreakpoints() {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.birt.report.debug.script.model");
        int i = 0;
        while (i < breakpoints.length) {
            this.breakpointAdded(breakpoints[i]);
            ++i;
        }
    }

    private void suspended(int detail) {
        this.thread.fireSuspendEvent(detail);
    }

    private void terminated() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
        this.setTerminating(false);
        if (!this.fTerminated) {
            this.setTerminated(true);
            this.reportVM.disconnect();
            this.fireTerminateEvent();
        }
        this.breakPoints.clear();
    }

    protected IStackFrame[] getStackFrames() throws DebugException {
        try {
            VMStackFrame[] frames = this.reportVM.getStackFrames();
            int len = frames.length;
            IStackFrame[] retValue = new IStackFrame[len];
            int i = len - 1;
            while (i >= 0) {
                VMStackFrame frame = frames[i];
                ScriptStackFrame debugStack = new ScriptStackFrame(this.thread, frame.getName(), i);
                debugStack.setLineNumber(frame.getLineNumber());
                retValue[len - i - 1] = debugStack;
                --i;
            }
            return retValue;
        }
        catch (VMException e) {
            logger.warning(e.getMessage());
            return null;
        }
    }

    public void stepInto() throws DebugException {
        try {
            this.thread.setStepping(true);
            this.reportVM.stepInto();
        }
        catch (VMException e) {
            logger.warning(e.getMessage());
        }
    }

    public void stepOver() throws DebugException {
        try {
            this.thread.setStepping(true);
            this.reportVM.step();
        }
        catch (VMException e) {
            logger.warning(e.getMessage());
        }
    }

    public void stepReturn() throws DebugException {
        try {
            this.thread.setStepping(true);
            this.reportVM.stepOut();
        }
        catch (VMException e) {
            logger.warning(e.getMessage());
        }
    }

    public IVariable[] getVariables(ScriptStackFrame frame) {
        VMStackFrame fm;
        block4: {
            fm = this.reportVM.getStackFrame(frame.getIdentifier());
            if (fm != null) break block4;
            return null;
        }
        try {
            VMVariable[] variables = fm.getVariables();
            IVariable[] retValue = new IVariable[variables.length];
            int i = 0;
            while (i < variables.length) {
                VMVariable variable = variables[i];
                ScriptVariable debugVariable = new ScriptVariable(frame, variable.getName(), variable.getTypeName());
                VMValue value = variable.getValue();
                ScriptValue debugValue = new ScriptValue(frame, value);
                debugVariable.setOriVale(debugValue);
                retValue[i] = debugVariable;
                ++i;
            }
            return retValue;
        }
        catch (VMException e) {
            logger.warning(e.getMessage());
            return null;
        }
    }

    public ScriptValue evaluate(ScriptStackFrame frame, String expression) {
        VMValue value;
        try {
            value = this.reportVM.evaluate(expression);
        }
        catch (VMException e) {
            return null;
        }
        if (value == null || "<undefined>".equals(value.getTypeName()) || "<exception>".equals(value.getTypeName())) {
            return null;
        }
        ScriptValue debugValue = new ScriptValue(frame, value);
        return debugValue;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    protected boolean isTerminating() {
        return this.fTerminating;
    }

    protected void setTerminating(boolean terminating) {
        this.fTerminating = terminating;
    }

    public boolean isAvailable() {
        return !this.isTerminated() && !this.isTerminating();
    }

    @Override
    public String getDisplayName() {
        try {
            return this.getName();
        }
        catch (DebugException e) {
            return this.getDefaultName();
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        if (!this.isAvailable()) {
            return;
        }
        for (JsLineBreakPoint breakpoint : new ArrayList(this.breakPoints)) {
            try {
                if (enabled) {
                    this.reportVM.removeBreakPoint((VMBreakPoint)breakpoint);
                    continue;
                }
                this.reportVM.removeBreakPoint((VMBreakPoint)breakpoint);
            }
            catch (VMException e) {
                logger.warning(e.getMessage());
            }
        }
    }
}

