/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.ui.views.IPageGenerator;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class TabPageGenerator
implements IPageGenerator {
    public static final String ACTIVE_PAGE = "ActivePage";
    protected int tabIndex = 0;
    protected String selectedTabText;
    protected List input;
    protected CTabFolder tabFolder;
    protected FolderSelectionAdapter listener;

    public void createTabItems(List input) {
        ISafeRunnable runnable = new ISafeRunnable(){

            public void run() throws Exception {
                CTabItem[] oldPages = TabPageGenerator.this.tabFolder.getItems();
                int index = TabPageGenerator.this.tabFolder.getSelectionIndex();
                int i = 0;
                while (i < oldPages.length) {
                    if (!oldPages[i].isDisposed() && index != i) {
                        if (oldPages[i].getControl() != null) {
                            oldPages[i].getControl().dispose();
                        }
                        oldPages[i].dispose();
                    }
                    ++i;
                }
                if (index > -1 && !oldPages[index].isDisposed()) {
                    oldPages[index].getControl().dispose();
                    oldPages[index].dispose();
                }
            }

            public void handleException(Throwable exception) {
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
    }

    public void createControl(Composite parent, Object input) {
        this.input = (List)input;
        if (this.tabFolder == null || this.tabFolder.isDisposed()) {
            this.tabFolder = new CTabFolder(parent, 128);
            this.tabFolder.setLayoutData((Object)new GridData(1808));
            this.createTabItems(this.input);
        }
        this.showPropertiesPage();
    }

    public Control getControl() {
        return this.tabFolder;
    }

    protected void showPropertiesPage() {
        if (SessionHandleAdapter.getInstance().getReportDesignHandle() != null) {
            if (this.tabFolder == null || this.tabFolder.isDisposed()) {
                return;
            }
            this.selectStickyTab();
            this.tabFolder.getParent().layout(true);
        }
    }

    private void selectStickyTab() {
        CTabItem[] items = this.tabFolder.getItems();
        boolean tabFound = false;
        int i = 0;
        while (i < items.length) {
            if (items[i].getText().equals(this.selectedTabText)) {
                this.tabFolder.setSelection(i);
                tabFound = true;
                break;
            }
            ++i;
        }
        if (!tabFound) {
            if (this.tabIndex > this.tabFolder.getItemCount() - 1) {
                this.tabFolder.setSelection(this.tabFolder.getItemCount() - 1);
            } else {
                this.tabFolder.setSelection(this.tabIndex);
            }
        }
    }

    protected void addSelectionListener(TabPageGenerator generator) {
        if (this.listener == null) {
            this.listener = new FolderSelectionAdapter(generator);
            this.tabFolder.addSelectionListener((SelectionListener)this.listener);
        } else {
            this.tabFolder.removeSelectionListener((SelectionListener)this.listener);
            this.tabFolder.addSelectionListener((SelectionListener)this.listener);
        }
    }

    public Object getInput() {
        return this.input;
    }

    public void refresh() {
    }

    public String getSelectedTabText() {
        return this.selectedTabText;
    }

    public void setSelectedTabText(String selectedTabText) {
        this.selectedTabText = selectedTabText;
    }

    public void selectTabItem(String tabKey) {
        this.selectedTabText = tabKey;
        this.showPropertiesPage();
        this.tabFolder.notifyListeners(13, new Event());
    }

    public boolean isChange(Object element) {
        return true;
    }

    class FolderSelectionAdapter
    extends SelectionAdapter {
        TabPageGenerator generator;

        public FolderSelectionAdapter(TabPageGenerator generator) {
            this.generator = generator;
        }

        public void widgetSelected(SelectionEvent e) {
            if (TabPageGenerator.this.tabFolder != null) {
                TabPageGenerator.this.tabIndex = TabPageGenerator.this.tabFolder.getSelectionIndex();
                if (TabPageGenerator.this.tabFolder.getSelection() != null) {
                    TabPageGenerator.this.selectedTabText = TabPageGenerator.this.tabFolder.getSelection().getText();
                    this.generator.createTabItems(TabPageGenerator.this.input);
                }
            }
        }
    }
}

