/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataColumnBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDLocation;
import org.eclipse.birt.report.designer.internal.ui.dnd.IDropAdapter;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabCellEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.VirtualCellEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.VirtualCrosstabCellAdapter;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;

public class AggregationDropAdapter
implements IDropAdapter {
    public int canDrop(Object transfer, Object target, int operation, DNDLocation location) {
        if ((transfer.equals("DATA_AGG") || transfer.equals("DATA_TIMEPERIOD")) && target instanceof CrosstabCellEditPart) {
            CrosstabCellAdapter adapter = (CrosstabCellAdapter)((CrosstabCellEditPart)((Object)target)).getModel();
            if (adapter.getCrosstabCellHandle() != null && DEUtil.isReferenceElement((DesignElementHandle)adapter.getCrosstabCellHandle().getCrosstabHandle())) {
                return -1;
            }
            String posType = adapter.getPositionType();
            if ("measure_aggregation".equals(posType) || "cell_measure".equals(posType) || "measure_virtual".equals(posType) && transfer.equals("DATA_TIMEPERIOD")) {
                if (transfer.equals("DATA_TIMEPERIOD")) {
                    CrosstabReportItemHandle reportHandle = (CrosstabReportItemHandle)CrosstabUtil.getReportItem((DesignElementHandle)((DesignElementHandle)((CrosstabCellEditPart)((Object)target)).getParent().getModel()));
                    if (DEUtil.isReferenceElement((DesignElementHandle)reportHandle.getCrosstabHandle())) {
                        return -1;
                    }
                    CubeHandle cube = reportHandle.getCube();
                    if (cube == null) {
                        return -1;
                    }
                    List list = cube.getContents("dimensions");
                    if (list == null) {
                        return -1;
                    }
                    int i = 0;
                    while (i < list.size()) {
                        LevelViewHandle levelViewHandle;
                        LevelHandle levelHandle;
                        int count;
                        DimensionViewHandle viewHandle;
                        DimensionHandle dimension = (DimensionHandle)list.get(i);
                        if (CrosstabAdaptUtil.isTimeDimension(dimension) && ((viewHandle = reportHandle.getDimension(dimension.getName())) == null ? (count = dimension.getDefaultHierarchy().getLevelCount()) != 0 && "year".equals((levelHandle = dimension.getDefaultHierarchy().getLevel(0)).getDateTimeLevelType()) : (count = viewHandle.getLevelCount()) != 0 && "year".equals((levelViewHandle = viewHandle.getLevel(0)).getCubeLevel().getDateTimeLevelType()))) {
                            return 1;
                        }
                        ++i;
                    }
                    return -1;
                }
                return 1;
            }
        }
        return 0;
    }

    public boolean performDrop(Object transfer, Object target, int operation, DNDLocation location) {
        if (target instanceof EditPart) {
            EditPart editPart = (EditPart)target;
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            if ("DATA_TIMEPERIOD".equals(transfer)) {
                stack.startTrans("Add TimePeriod");
            } else {
                stack.startTrans("Add Aggregation");
            }
            DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(null);
            CrosstabCellHandle cellHandle = null;
            CrosstabReportItemHandle itemHandle = null;
            if (target instanceof VirtualCellEditPart) {
                itemHandle = ((VirtualCrosstabCellAdapter)((VirtualCellEditPart)((Object)target)).getModel()).getCrosstabReportItemHandle();
            } else if (target instanceof CrosstabCellEditPart) {
                cellHandle = ((CrosstabCellAdapter)((CrosstabCellEditPart)((Object)target)).getModel()).getCrosstabCellHandle();
            }
            try {
                DataColumnBindingDialog dialog = new DataColumnBindingDialog(true);
                if (target instanceof VirtualCellEditPart) {
                    dialog.setInput((ReportItemHandle)itemHandle.getModelHandle());
                } else if (target instanceof CrosstabCellEditPart) {
                    cellHandle.addContent((DesignElementHandle)dataHandle, 0);
                    dialog.setInput((ReportItemHandle)dataHandle, null, (Object)cellHandle);
                }
                dialog.setAggreate(true);
                if ("DATA_TIMEPERIOD".equals(transfer)) {
                    dialog.setTimePeriod(true);
                }
                if (dialog.open() == 0) {
                    if (target instanceof VirtualCellEditPart) {
                        ComputedColumnHandle bindingHandle = dialog.getBindingColumn();
                        ComputedMeasureViewHandle computedMeasure = itemHandle.insertComputedMeasure(bindingHandle.getName(), itemHandle.getComputedMeasures().size());
                        computedMeasure.addHeader();
                        ExtendedItemHandle crosstabModelHandle = (ExtendedItemHandle)itemHandle.getModelHandle();
                        if (bindingHandle == null) {
                            stack.rollback();
                        }
                        DataItemHandle dataItemHandle = DesignElementFactory.getInstance().newDataItem(bindingHandle.getName());
                        CrosstabAdaptUtil.formatDataItem(computedMeasure.getCubeMeasure(), dataItemHandle);
                        dataItemHandle.setResultSetColumn(bindingHandle.getName());
                        AggregationCellHandle cell = computedMeasure.getCell();
                        if ("horizontal".equals(itemHandle.getMeasureDirection())) {
                            CrosstabCellHandle crosstabCellHandle = computedMeasure.getHeader();
                            if (crosstabCellHandle == null) {
                                crosstabCellHandle = cell;
                            }
                            String string = itemHandle.getModelHandle().getModuleHandle().getDefaultUnits();
                        }
                        cell.addContent((DesignElementHandle)dataItemHandle);
                        stack.commit();
                    } else if (target instanceof CrosstabCellEditPart) {
                        CreateRequest request = new CreateRequest();
                        request.getExtendedData().put("newObject", dataHandle);
                        request.setLocation(location.getPoint());
                        Command command = editPart.getCommand((Request)request);
                        if (command != null && command.canExecute()) {
                            dataHandle.setResultSetColumn(dialog.getBindingColumn().getName());
                            editPart.getViewer().getEditDomain().getCommandStack().execute(command);
                            stack.commit();
                        } else {
                            stack.rollback();
                        }
                    }
                } else {
                    stack.rollback();
                }
            }
            catch (Exception e) {
                stack.rollback();
                ExceptionUtil.handle((Throwable)e);
            }
        }
        return true;
    }
}

