/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.PropertyDescriptorProvider;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;

public class HideMeasureHeaderProvider
extends PropertyDescriptorProvider {
    protected CrosstabReportItemHandle crosstabHandle;
    protected final String TRANS_NAME = "Change Crosstab Hidemeasure";
    protected static final Logger logger = Logger.getLogger(HideMeasureHeaderProvider.class.getName());

    public HideMeasureHeaderProvider(String property, String element) {
        super(property, element);
    }

    public String getDisplayName() {
        String displayName = super.getDisplayName();
        if (displayName != null && displayName.length() > 0) {
            return displayName;
        }
        return Messages.getString("CrosstabGeneralPage.HideMeasureHeader");
    }

    public void save(Object value) throws SemanticException {
        String stringValue = (String)value;
        if (this.input == null) {
            return;
        }
        if (this.crosstabHandle == null) {
            this.initializeCrosstab();
        }
        if (stringValue != null) {
            CommandStack stack = this.crosstabHandle.getModuleHandle().getCommandStack();
            stack.startTrans("Change Crosstab Hidemeasure");
            this.crosstabHandle.setHideMeasureHeader(Boolean.parseBoolean((String)value));
            CrosstabUtil.addAllHeaderLabel((CrosstabReportItemHandle)this.crosstabHandle);
            stack.commit();
        }
    }

    public void setInput(Object input) {
        super.setInput(input);
        this.initializeCrosstab();
    }

    protected void initializeCrosstab() {
        this.crosstabHandle = null;
        if (!(this.input != null && (this.input instanceof List && ((List)this.input).size() > 0 && ((List)this.input).get(0) instanceof ExtendedItemHandle || this.input instanceof ExtendedItemHandle))) {
            return;
        }
        ExtendedItemHandle handle = ((List)this.input).size() > 0 ? (ExtendedItemHandle)((List)this.input).get(0) : (ExtendedItemHandle)this.input;
        try {
            this.crosstabHandle = (CrosstabReportItemHandle)handle.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
    }
}

