/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0/.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.model.elements.interfaces;

/**
 * The interface for DataSet to store the constants.
 */
public interface IDataSetModel {

	/**
	 * The property name of the structures of the expected result set.
	 */

	String RESULT_SET_PROP = "resultSet"; //$NON-NLS-1$

	/**
	 * The property name of the structures of the expected result set's hint.
	 */

	String RESULT_SET_HINTS_PROP = "resultSetHints"; //$NON-NLS-1$

	/**
	 * The property name of the columns computed with expression.
	 */

	String COMPUTED_COLUMNS_PROP = "computedColumns"; //$NON-NLS-1$

	/**
	 * The property name of the column hint elements.
	 */

	String COLUMN_HINTS_PROP = "columnHints"; //$NON-NLS-1$

	/**
	 * The property name of the filters to apply to the data set.
	 */

	String FILTER_PROP = "filter"; //$NON-NLS-1$

	/**
	 * The property name of the data set parameters definitions.
	 */

	String PARAMETERS_PROP = "parameters"; //$NON-NLS-1$

	/**
	 * The property name of the cached data set information.
	 */

	String CACHED_METADATA_PROP = "cachedMetaData"; //$NON-NLS-1$

	/**
	 * The property name of the max number of rows to fetch from data set.
	 */

	String ROW_FETCH_LIMIT_PROP = "rowFetchLimit"; //$NON-NLS-1$

	/**
	 * The property name of the sort hint. It is a property list contains sort hints
	 * which supports row ordering.
	 */
	String SORT_HINTS_PROP = "sortHints"; //$NON-NLS-1$

	/**
	 * Name of the property that determines whether to do some cache for data-engine
	 * when rendering the report.
	 */
	String NEEDS_CACHE_PROP = "needsCache"; //$NON-NLS-1$

	/**
	 * Name of the property that defines the expression to calculate ACL for the
	 * entire data set. This expression is evaluated once for each data set, after
	 * the data set has been executed but before the first result set row has been
	 * processed.
	 */
	String ACL_EXPRESSION_PROP = "ACLExpression"; //$NON-NLS-1$

	/**
	 * Name of the property that defines the expression to calculate ACL for result
	 * set rows. This expression is evaluated once for each data set row after it
	 * has been retrieved. The expression has access to all column values of the
	 * current row.
	 */
	String ROW_ACL_EXPRESSION_PROP = "rowACLExpression"; //$NON-NLS-1$

	/**
	 * Name of the property that indicates whether the data set is visible outside
	 * of the data mart.
	 */
	String IS_VISIBLE_PROP = "isVisible"; //$NON-NLS-1$

	/**
	 * Name of the property that specifies the locale for this data set applied.
	 */
	String LOCALE_PROP = "locale"; //$NON-NLS-1$

	/**
	 * Name of the property that defines the ordering of null values. By default, it
	 * is nulls lowest.
	 */
	String NULLS_ORDERING_PROP = "nullsOrdering"; //$NON-NLS-1$

}
