/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.doc.legacy;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import org.eclipse.birt.doc.legacy.DocWriter;
import org.eclipse.birt.doc.legacy.LegacySpecParser;
import org.eclipse.birt.doc.legacy.RomImage;
import org.eclipse.birt.doc.legacy.RomUpdater;
import org.eclipse.birt.doc.legacy.SpecDumper;
import org.eclipse.birt.doc.legacy.SpecElement;
import org.eclipse.birt.doc.util.HTMLParser;

public class LegacyLoader {
    RomImage rom;
    ArrayList elements = new ArrayList();
    ArrayList structs = new ArrayList();
    static String[] elementTypes = new String[]{"Start", "End", "Single"};

    public static void main(String[] argv) {
        LegacyLoader loader = new LegacyLoader();
        try {
            loader.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load() throws Exception {
        this.loadRom();
        this.loadSpecs();
        this.dumpSpecs();
        this.updateRom();
        this.writeDescripDocs();
        this.writeRom();
    }

    private void loadSpecs() {
        this.loadSpecsInDir("elements", 0);
        this.loadSpecsInDir("structs", 1);
    }

    private void loadSpecsInDir(String dir, int type) {
        File elements = new File("orig/" + dir);
        String[] files = elements.list();
        int i = 0;
        while (i < files.length) {
            String fileName = files[i];
            if (fileName.endsWith(".html")) {
                System.out.println("Reading " + fileName);
                this.parseFile("orig/" + dir + "/" + fileName, type);
            }
            ++i;
        }
    }

    private void dumpSpecs() throws Exception {
        SpecDumper dumper = new SpecDumper();
        try {
            dumper.dump(this);
        }
        catch (IOException e) {
            System.err.println("Failed to dump spec info.");
            throw e;
        }
    }

    private void updateRom() throws Exception {
        RomUpdater updater = new RomUpdater(this);
        try {
            updater.update();
        }
        catch (Exception e) {
            System.out.println("Failed to load rom.def");
            throw e;
        }
    }

    private void writeDescripDocs() {
        try {
            DocWriter writer = new DocWriter();
            writer.startIndex();
            writer.startElementIndex();
            for (SpecElement element : this.elements) {
                writer.write(element);
            }
            writer.startStructIndex();
            for (SpecElement element : this.structs) {
                writer.write(element);
            }
            writer.endIndex();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to write element descriptions.");
        }
    }

    private void writeRom() {
        try {
            this.rom.write();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to write rom.def");
        }
    }

    public void parseFile(String fileName, int type) {
        try {
            LegacySpecParser parser = new LegacySpecParser();
            parser.parse(fileName, type);
            SpecElement element = parser.getElement();
            if (type == 0) {
                this.elements.add(element);
            } else {
                this.structs.add(element);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Could not load file " + fileName);
        }
    }

    void loadRom() throws RomImage.RomException {
        this.rom = new RomImage();
        try {
            this.rom.open();
        }
        catch (RomImage.RomException e) {
            System.err.println("ROM load failed");
            throw e;
        }
    }

    static void test(String fileName) throws FileNotFoundException {
        int token;
        HTMLParser parser = new HTMLParser();
        parser.open(fileName);
        while ((token = parser.getToken()) != -1) {
            switch (token) {
                case 5: {
                    System.out.print("Special Element: ");
                    System.out.println(parser.getTokenText());
                    break;
                }
                case 3: {
                    System.out.print(elementTypes[parser.getElementType()]);
                    System.out.print("Element: ");
                    System.out.println(parser.getFullElement());
                    break;
                }
                case 1: {
                    System.out.print("Text: ");
                    System.out.println(parser.getTokenText());
                }
            }
        }
    }

    public RomImage getRom() {
        return this.rom;
    }

    public AbstractList getElements() {
        return this.elements;
    }

    public AbstractList getStructures() {
        return this.structs;
    }
}

