/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.style.java;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class DoubleQuotedStringRule
implements IPredicateRule {
    private IToken fToken;
    private int m_qc;

    public DoubleQuotedStringRule(IToken tok) {
        this.fToken = tok;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (resume) {
            if (this.findEnd(scanner, this.m_qc)) {
                return this.fToken;
            }
        } else {
            int c = scanner.read();
            if (c == 92) {
                c = scanner.read();
                if ((c == 34 || c == 39) && this.findEnd(scanner, c)) {
                    return this.fToken;
                }
                scanner.unread();
            }
            scanner.unread();
        }
        return Token.UNDEFINED;
    }

    private boolean findEnd(ICharacterScanner scanner, int qc) {
        int c;
        this.m_qc = qc;
        int count = 0;
        int nsl = 0;
        while ((c = scanner.read()) != -1) {
            ++count;
            if (c == 92) {
                if (++nsl < 4) continue;
                nsl = 0;
                continue;
            }
            if (c == qc) {
                if (nsl == 1) {
                    return true;
                }
                nsl = 0;
                continue;
            }
            nsl = 0;
        }
        while (--count >= 0) {
            scanner.unread();
        }
        return false;
    }

    public IToken getSuccessToken() {
        return this.fToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }
}

