/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.product.ProductModel;
import org.eclipse.pde.internal.core.product.WorkspaceProductModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.XMLInputContext;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;

public class ProductInputContext
extends XMLInputContext {
    public static final String CONTEXT_ID = "product-context";

    public ProductInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    @Override
    public String getId() {
        return CONTEXT_ID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        WorkspaceProductModel model = null;
        if (input instanceof IStorageEditorInput) {
            try {
                if (input instanceof IFileEditorInput) {
                    IFile file = ((IFileEditorInput)input).getFile();
                    model = new WorkspaceProductModel(file, true);
                    model.load();
                    return model;
                }
                if (!(input instanceof IStorageEditorInput)) return model;
                BufferedInputStream is = new BufferedInputStream(((IStorageEditorInput)input).getStorage().getContents());
                model = new ProductModel();
                model.load((InputStream)is, false);
                return model;
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
                return null;
            }
        } else {
            if (!(input instanceof IURIEditorInput)) return model;
            IFileStore store = EFS.getStore((URI)((IURIEditorInput)input).getURI());
            InputStream is = store.openInputStream(4096, (IProgressMonitor)new NullProgressMonitor());
            model = new ProductModel();
            model.load(is, false);
        }
        return model;
    }

    @Override
    protected void addTextEditOperation(ArrayList<TextEdit> ops, IModelChangedEvent event) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void flushModel(IDocument doc) {
        if (!(this.getModel() instanceof IEditable)) {
            return;
        }
        IEditable editableModel = (IEditable)this.getModel();
        if (!editableModel.isDirty()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                StringWriter swriter = new StringWriter();
                try {
                    try (PrintWriter writer = new PrintWriter(swriter);){
                        editableModel.save(writer);
                        writer.flush();
                        String content = swriter.toString();
                        content = AbstractModel.fixLineDelimiter((String)content, (IFile)((IFile)((IModel)this.getModel()).getUnderlyingResource()));
                        doc.set(content);
                    }
                    if (swriter == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (swriter == null) throw throwable;
                    swriter.close();
                    throw throwable;
                }
                swriter.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
    }

    @Override
    protected boolean synchronizeModel(IDocument doc) {
        IProductModel model = (IProductModel)this.getModel();
        boolean cleanModel = true;
        String text = doc.get();
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));){
                model.reload((InputStream)stream, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException coreException) {
            cleanModel = false;
        }
        catch (IOException iOException) {}
        return cleanModel;
    }

    @Override
    protected void reorderInsertEdits(ArrayList<TextEdit> ops) {
    }

    @Override
    protected String getPartitionName() {
        return "___prod_partition";
    }
}

