/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.soap.customizations;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.binding.soap.SOAPBody;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;

public class SOAPSelectPartsDialog
extends Dialog {
    Definition definition;
    SOAPBody body;
    CheckboxTreeViewer checkList;
    Part[] selectedParts = new Part[0];

    public SOAPSelectPartsDialog(Shell parentShell, Definition definition, SOAPBody body) {
        super(parentShell);
        this.definition = definition;
        this.body = body;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.checkList = new CheckboxTreeViewer(composite, 0);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 100;
        gridData.widthHint = 200;
        this.checkList.getControl().setLayoutData((Object)gridData);
        this.checkList.setContentProvider((IContentProvider)new InternalTreeContentProvider());
        this.checkList.setLabelProvider((IBaseLabelProvider)new InternalLabelProvider());
        this.checkList.setInput((Object)"");
        List list = this.body.getParts();
        this.checkList.setCheckedElements(list.toArray());
        return composite;
    }

    protected void okPressed() {
        Object[] checked = this.checkList.getCheckedElements();
        this.selectedParts = new Part[checked.length];
        int i = 0;
        while (i < checked.length) {
            this.selectedParts[i] = (Part)checked[i];
            ++i;
        }
        super.okPressed();
    }

    public Part[] getSelectedParts() {
        return this.selectedParts;
    }

    class InternalLabelProvider
    extends LabelProvider {
        InternalLabelProvider() {
        }

        public String getText(Object element) {
            Part part = (Part)element;
            return part.getName();
        }

        public Image getImage(Object element) {
            return WSDLEditorPlugin.getInstance().getImage("icons/part_obj.gif");
        }
    }

    class InternalTreeContentProvider
    implements ITreeContentProvider {
        InternalTreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            EObject container = SOAPSelectPartsDialog.this.body.eContainer();
            Input messageReference = null;
            if (container instanceof BindingInput) {
                messageReference = ComponentReferenceUtil.computeInput((BindingInput)container);
            } else if (container instanceof BindingOutput) {
                messageReference = ComponentReferenceUtil.computeOutput((BindingOutput)container);
            }
            if (messageReference != null && messageReference.getEMessage() != null) {
                return messageReference.getEMessage().getEParts().toArray();
            }
            return Collections.EMPTY_LIST.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return Collections.EMPTY_LIST.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

