/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.data.engine.cache.BasicCachedList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odi.IAggrInfo;
import org.eclipse.birt.data.engine.odi.IAggrValueHolder;

public class AggrValuesUpdator
implements IAggrValueHolder {
    private IAggrInfo[] aggrInfos;
    private HashMap<String, Integer> aggrIndexMap;
    private ResultSetPopulator populator;
    private String tempDir;
    private List<Object>[] aggrValues;
    private List<Object>[] oldAggrValues;
    private HashMap<Integer, List<Integer>> summaryAggrsMap;
    private HashMap<String, Integer> runningAggrsMap;

    public AggrValuesUpdator(IAggrValueHolder aggrValuesHolder, ResultSetPopulator populator) throws DataException {
        Set<String> aggrNames = aggrValuesHolder.getAggrNames();
        this.aggrIndexMap = new HashMap();
        this.aggrInfos = new IAggrInfo[aggrNames.size()];
        this.aggrValues = new List[aggrNames.size()];
        this.oldAggrValues = new List[aggrNames.size()];
        this.summaryAggrsMap = new HashMap();
        this.runningAggrsMap = new HashMap();
        this.populator = populator;
        this.tempDir = populator.getSession().getTempDir();
        Iterator<String> itr = aggrNames.iterator();
        int i = 0;
        while (itr.hasNext()) {
            String aggrName = itr.next();
            this.aggrIndexMap.put(aggrName, i);
            this.aggrInfos[i] = aggrValuesHolder.getAggrInfo(aggrName);
            this.aggrValues[i] = new BasicCachedList(this.tempDir, DataEngineSession.getCurrentClassLoader());
            this.oldAggrValues[i] = aggrValuesHolder.getAggrValues(aggrName);
            if (this.aggrInfos[i].getAggregation().getType() == 0) {
                int level = this.aggrInfos[i].getGroupLevel();
                List<Integer> aggrs = this.summaryAggrsMap.get(level);
                if (aggrs == null) {
                    aggrs = new ArrayList<Integer>();
                    this.summaryAggrsMap.put(level, aggrs);
                }
                aggrs.add(i);
            } else {
                this.runningAggrsMap.put(aggrName, i);
            }
            ++i;
        }
    }

    @Override
    public IAggrInfo getAggrInfo(String aggrName) throws DataException {
        Integer i = this.aggrIndexMap.get(aggrName);
        return i == null ? null : this.aggrInfos[i];
    }

    public boolean hasAggr(String aggrName) throws DataException {
        return this.aggrIndexMap.get(aggrName) != null;
    }

    @Override
    public Object getAggrValue(String name) throws DataException {
        assert (this.populator != null);
        IAggrInfo aggrInfo = this.getAggrInfo(name);
        if (this.populator.getCache().getCount() == 0) {
            return aggrInfo.getAggregation().getDefaultValue();
        }
        int groupIndex = aggrInfo.getAggregation().getType() == 0 ? (aggrInfo.getGroupLevel() == 0 ? 0 : this.getCurrentGroupIndex(aggrInfo.getGroupLevel())) : this.getCurrentResultIndex();
        return this.aggrValues[this.aggrIndexMap.get(name)].get(groupIndex);
    }

    private int getCurrentGroupIndex(int groupLevel) throws DataException {
        assert (this.populator != null);
        return this.populator.getResultIterator().getCurrentGroupIndex(groupLevel);
    }

    private int getCurrentResultIndex() throws DataException {
        return this.populator.getResultIterator().getCurrentResultIndex();
    }

    @Override
    public List getAggrValues(String name) throws DataException {
        return this.aggrValues[this.aggrIndexMap.get(name)];
    }

    @Override
    public Set<String> getAggrNames() throws DataException {
        return this.aggrIndexMap.keySet();
    }

    public void onRow(int rowId) {
        for (Map.Entry<String, Integer> a : this.runningAggrsMap.entrySet()) {
            int idx = a.getValue();
            this.aggrValues[idx].add(this.oldAggrValues[idx].get(rowId));
        }
        List<Integer> lv0Idxs = this.summaryAggrsMap.get(0);
        int i = 0;
        while (lv0Idxs != null && i < lv0Idxs.size()) {
            int id = lv0Idxs.get(i);
            if (this.aggrValues[id].size() <= 0) {
                this.aggrValues[id].add(this.oldAggrValues[id].get(0));
            }
            ++i;
        }
    }

    public void onGroup(int level, int groupIndex) {
        List<Integer> idxs = this.summaryAggrsMap.get(level);
        int i = 0;
        while (idxs != null && i < idxs.size()) {
            int id = idxs.get(i);
            Object aggr = this.oldAggrValues[id].get(groupIndex);
            this.aggrValues[id].add(aggr);
            ++i;
        }
    }
}

