/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.script.JSObjectMetaData;
import org.eclipse.birt.report.designer.internal.ui.script.JSSyntaxContext;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfoList;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IMemberInfo;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;

class EngineClassJSObject
implements JSObjectMetaData {
    private static JSObjectMetaData.JSMethod[] noMthods = new JSObjectMetaData.JSMethod[0];
    private static JSObjectMetaData.JSField[] noFields = new JSObjectMetaData.JSField[0];
    private IClassInfo classInfo;
    private boolean showPublic;

    public EngineClassJSObject(IClassInfo classInfo) {
        this.classInfo = classInfo;
        this.showPublic = "DataSet".equals(classInfo.getName()) || "DataSource".equals(classInfo.getName());
    }

    @Override
    public String getName() {
        if (this.classInfo == null) {
            return "";
        }
        return this.classInfo.getName();
    }

    @Override
    public JSObjectMetaData.JSMethod[] getMethods() {
        if (this.classInfo == null) {
            return noMthods;
        }
        List methods = this.classInfo.getMethods();
        ArrayList<EngineClassMethod> all = new ArrayList<EngineClassMethod>();
        for (IMethodInfo method : methods) {
            if (!this.showPublic && !method.isStatic()) continue;
            all.add(new EngineClassMethod(method));
        }
        Collections.sort(all);
        return all.toArray(new JSObjectMetaData.JSMethod[all.size()]);
    }

    @Override
    public JSObjectMetaData.JSField[] getFields() {
        if (this.classInfo == null) {
            return noFields;
        }
        List members = this.classInfo.getMembers();
        ArrayList<EngineClassField> all = new ArrayList<EngineClassField>();
        for (IMemberInfo member : members) {
            if (!this.showPublic && !member.isStatic()) continue;
            all.add(new EngineClassField(member));
        }
        Collections.sort(all);
        return all.toArray(new JSObjectMetaData.JSField[all.size()]);
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public int getVisibility() {
        return 0;
    }

    @Override
    public JSObjectMetaData getComponentType() {
        return null;
    }

    class EngineClassField
    implements JSObjectMetaData.JSField,
    Comparable {
        private IMemberInfo member;
        private String displayText;

        public EngineClassField(IMemberInfo member) {
            this.member = member;
        }

        @Override
        public String getName() {
            return this.member.getDisplayName();
        }

        @Override
        public JSObjectMetaData getType() {
            JSObjectMetaData meta = JSSyntaxContext.getEnginJSObject(this.member.getDataType());
            if (meta == null) {
                try {
                    return JSSyntaxContext.getJavaClassMeta(this.member.getDataType());
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            return meta;
        }

        @Override
        public String getDisplayText() {
            if (this.displayText == null) {
                StringBuilder strbuf = new StringBuilder(this.getName());
                strbuf.append(" ");
                strbuf.append(EngineClassJSObject.this.classInfo.getName());
                this.displayText = strbuf.toString();
                Object var1_1 = null;
            }
            return this.displayText;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public int getVisibility() {
            return 0;
        }

        public int compareTo(Object obj) {
            if (obj instanceof EngineClassField && ((EngineClassField)obj).getName() != null) {
                return this.getName().compareToIgnoreCase(((EngineClassField)obj).getName());
            }
            return 0;
        }
    }

    class EngineClassMethod
    implements JSObjectMetaData.JSMethod,
    Comparable {
        private IMethodInfo method;
        private String displayText;

        public EngineClassMethod(IMethodInfo method) {
            this.method = method;
        }

        @Override
        public String getName() {
            return this.method.getDisplayName();
        }

        @Override
        public JSObjectMetaData getReturn() {
            JSObjectMetaData meta = JSSyntaxContext.getEnginJSObject(this.method.getReturnType());
            if (meta == null) {
                try {
                    return JSSyntaxContext.getJavaClassMeta(this.method.getReturnType());
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            return meta;
        }

        @Override
        public JSObjectMetaData[] getArguments() {
            Iterator itr = this.method.argumentListIterator();
            if (itr != null && itr.hasNext()) {
                IArgumentInfoList ail = (IArgumentInfoList)itr.next();
                ArrayList<JSObjectMetaData> args = new ArrayList<JSObjectMetaData>();
                Iterator aitr = ail.argumentsIterator();
                while (aitr.hasNext()) {
                    IArgumentInfo aif = (IArgumentInfo)aitr.next();
                    JSObjectMetaData meta = JSSyntaxContext.getEnginJSObject(aif.getType());
                    if (meta == null) {
                        try {
                            meta = JSSyntaxContext.getJavaClassMeta(aif.getType());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (meta == null) continue;
                    args.add(meta);
                }
                return args.toArray(new JSObjectMetaData[args.size()]);
            }
            return null;
        }

        @Override
        public String getDisplayText() {
            if (this.displayText == null) {
                StringBuilder strbuf = new StringBuilder(this.getName());
                strbuf.append("(");
                Iterator iter = this.method.argumentListIterator();
                if (iter.hasNext()) {
                    IArgumentInfoList element = (IArgumentInfoList)iter.next();
                    int i = 0;
                    Iterator iterator = element.argumentsIterator();
                    while (iterator.hasNext()) {
                        IArgumentInfo argument;
                        if (i++ > 0) {
                            strbuf.append(", ");
                        }
                        if ((argument = (IArgumentInfo)iterator.next()).getType() != null) {
                            strbuf.append(argument.getType()).append(" ");
                        }
                        strbuf.append(argument.getName());
                    }
                }
                strbuf.append(") ");
                strbuf.append(EngineClassJSObject.this.classInfo.getName());
                this.displayText = strbuf.toString();
                Object var1_1 = null;
            }
            return this.displayText;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public int getVisibility() {
            if (this.method.isStatic()) {
                return 3;
            }
            return 0;
        }

        public int compareTo(Object obj) {
            if (obj instanceof EngineClassMethod && ((EngineClassMethod)obj).getName() != null) {
                return this.getName().compareToIgnoreCase(((EngineClassMethod)obj).getName());
            }
            return 0;
        }
    }
}

