/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.swt.custom;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class LayoutTable
extends Composite {
    private static int COLUMN_TRIM = "carbon".equals(SWT.getPlatform()) ? 24 : 3;
    private ColumnsDescription columnDescription;
    private Table table;
    private boolean formStyle = false;

    public LayoutTable(Composite parent, ColumnsDescription columnsDescription, int style, boolean isFormStyle) {
        super(parent, 0);
        this.formStyle = isFormStyle;
        Assert.isNotNull((Object)columnsDescription);
        this.columnDescription = columnsDescription;
        if (this.formStyle) {
            this.setLayout((Layout)UIUtil.createGridLayoutWithMargin(1));
        } else {
            this.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        }
        this.table = !this.formStyle ? new Table((Composite)this, style) : FormWidgetFactory.getInstance().createTable(this, style);
        this.table.setHeaderVisible(columnsDescription.headers != null);
        this.table.setLinesVisible(columnsDescription.drawLines);
        this.table.setLayoutData((Object)new GridData(1808));
        int columnCount = this.columnDescription.isHeaderVisible() ? this.columnDescription.headers.length : this.columnDescription.columns.length;
        int i = 0;
        while (i < columnCount) {
            TableColumn column = new TableColumn(this.table, 0);
            if (this.columnDescription.isHeaderVisible()) {
                column.setText(this.columnDescription.headers[i]);
            }
            column.setMoveable(false);
            if (i < columnsDescription.columns.length) {
                column.setResizable(columnsDescription.columns[i].resizable);
            }
            ++i;
        }
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (LayoutTable.this.table != null && !LayoutTable.this.table.isDisposed()) {
                    Rectangle area = LayoutTable.this.getClientArea();
                    Point preferredSize = LayoutTable.this.computeTableSize(LayoutTable.this.table);
                    int width = area.width - 2 * LayoutTable.this.table.getBorderWidth();
                    if (preferredSize.y > area.height) {
                        Point vBarSize = LayoutTable.this.table.getVerticalBar().getSize();
                        width -= vBarSize.x;
                    }
                    if (LayoutTable.this.formStyle) {
                        width -= 2;
                    }
                    LayoutTable.this.layoutTable(width, area);
                }
            }
        });
    }

    private Point computeTableSize(Table table) {
        Point result = table.computeSize(-1, -1);
        int width = 0;
        int size = this.columnDescription.columns.length;
        int i = 0;
        while (i < size) {
            ColumnPixelData col;
            ColumnLayoutData layoutData = this.columnDescription.columns[i];
            if (layoutData instanceof ColumnPixelData) {
                col = (ColumnPixelData)layoutData;
                width += col.width;
                if (col.addTrim) {
                    width += COLUMN_TRIM;
                }
            } else if (layoutData instanceof ColumnWeightData) {
                col = (ColumnWeightData)layoutData;
                width += col.minimumWidth;
            } else {
                Assert.isTrue((boolean)false, (String)"Unknown column layout data");
            }
            ++i;
        }
        if (width > result.x) {
            result.x = width;
        }
        return result;
    }

    private void layoutTable(int width, Rectangle area) {
        boolean increase;
        boolean bl = increase = this.table.getSize().x < area.width;
        if (width <= 1) {
            return;
        }
        TableColumn[] tableColumns = this.table.getColumns();
        int size = Math.min(this.columnDescription.columns.length, tableColumns.length);
        int[] widths = new int[size];
        int fixedWidth = 0;
        int numberOfWeightColumns = 0;
        int totalWeight = 0;
        int i = 0;
        while (i < size) {
            ColumnLayoutData col = this.columnDescription.columns[i];
            if (col instanceof ColumnPixelData) {
                ColumnPixelData cpd = (ColumnPixelData)col;
                int pixels = cpd.width;
                if (cpd.addTrim) {
                    pixels += COLUMN_TRIM;
                }
                widths[i] = pixels;
                fixedWidth += pixels;
            } else if (col instanceof ColumnWeightData) {
                ColumnWeightData cw = (ColumnWeightData)col;
                ++numberOfWeightColumns;
                int weight = cw.weight;
                totalWeight += weight;
            } else {
                Assert.isTrue((boolean)false, (String)"Unknown column layout data");
            }
            ++i;
        }
        if (numberOfWeightColumns > 0) {
            int rest = width - fixedWidth;
            int totalDistributed = 0;
            int i2 = 0;
            while (i2 < size) {
                ColumnLayoutData col = this.columnDescription.columns[i2];
                if (col instanceof ColumnWeightData) {
                    int pixels;
                    ColumnWeightData cw = (ColumnWeightData)col;
                    int weight = cw.weight;
                    int n = pixels = totalWeight == 0 ? 0 : weight * rest / totalWeight;
                    if (pixels < cw.minimumWidth) {
                        pixels = cw.minimumWidth;
                    }
                    totalDistributed += pixels;
                    widths[i2] = pixels;
                }
                ++i2;
            }
            int diff = rest - totalDistributed;
            int i3 = 0;
            while (diff > 0) {
                ColumnLayoutData col;
                if (i3 == size) {
                    i3 = 0;
                }
                if ((col = this.columnDescription.columns[i3]) instanceof ColumnWeightData) {
                    int n = i3;
                    widths[n] = widths[n] + 1;
                    --diff;
                }
                ++i3;
            }
        }
        if (increase) {
            this.table.setSize(area.width, area.height);
        }
        i = 0;
        while (i < size) {
            tableColumns[i].setWidth(widths[i]);
            ++i;
        }
        if (!increase) {
            this.table.setSize(area.width, area.height);
        }
    }

    public Table getTable() {
        return this.table;
    }

    public static class ColumnsDescription {
        private ColumnLayoutData[] columns;
        private String[] headers;
        private boolean drawLines;

        public ColumnsDescription(ColumnLayoutData[] columns, String[] headers, boolean drawLines) {
            Assert.isNotNull((Object)columns);
            this.columns = columns;
            this.headers = headers;
            this.drawLines = drawLines;
        }

        public ColumnsDescription(String[] headers, boolean drawLines) {
            this(ColumnsDescription.createColumnWeightData(headers.length), headers, drawLines);
        }

        public ColumnsDescription(ColumnLayoutData[] columns, boolean drawLines) {
            this(columns, null, drawLines);
        }

        public ColumnsDescription(int nColumns, boolean drawLines) {
            this(ColumnsDescription.createColumnWeightData(nColumns), null, drawLines);
        }

        private static ColumnLayoutData[] createColumnWeightData(int nColumns) {
            ColumnLayoutData[] data = new ColumnLayoutData[nColumns];
            int i = 0;
            while (i < nColumns) {
                data[i] = new ColumnWeightData(1);
                ++i;
            }
            return data;
        }

        private boolean isHeaderVisible() {
            return this.headers != null && this.headers.length > 0;
        }
    }
}

