/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ods;

import org.eclipse.birt.report.engine.emitter.ods.SheetData;
import org.eclipse.birt.report.engine.emitter.ods.layout.OdsContainer;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;

public class ImageData
extends SheetData {
    private String altText;
    private String imageUrl;
    private float width;
    private float imageHeight;

    public ImageData(String uri, String altText, int imageWidth, int imageHeight, StyleEntry styleId, int datatype, OdsContainer currentContainer) {
        this.dataType = datatype;
        this.styleId = styleId;
        this.height = (float)imageHeight / 1000.0f;
        this.imageHeight = (int)this.height;
        this.width = Math.min(currentContainer.getSizeInfo().getWidth(), imageWidth);
        this.altText = altText;
        this.imageUrl = uri;
        this.rowSpanInDesign = 0;
    }

    public String getDescription() {
        return this.altText;
    }

    public void setDescription(String description) {
        this.altText = description;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public float getImageHeight() {
        return this.imageHeight;
    }

    public float getImageWidth() {
        return this.width / 1000.0f;
    }

    @Override
    public int getEndX() {
        return (int)((float)this.getStartX() + this.width);
    }
}

