/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts;

import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabCellEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabFirstCellEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.LevelCrosstabPopMenuProvider;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.LevelHandleDataItemEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.MeasureAggregationEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.MeasureCrosstabPopMenuProvider;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.MeasureHandleDataItemEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.VirtualCellEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.VirtualCrosstabCellAdapter;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.action.MenuManager;

public class CrosstabGraphicsFactory
implements EditPartFactory {
    public static final CrosstabGraphicsFactory INSTANCEOF = new CrosstabGraphicsFactory();

    public EditPart createEditPart(EditPart context, Object model) {
        if (context instanceof CrosstabCellEditPart && model instanceof DataItemHandle) {
            CrosstabCellAdapter adapter = ((CrosstabCellEditPart)context).getCrosstabCellAdapter();
            String position = adapter.getPositionType();
            if ("first_level_handle".equals(position) && adapter.getFirstDataItem() == model) {
                return new LevelHandleDataItemEditPart(model);
            }
            if ("level_handle".equals(position)) {
                return new LevelHandleDataItemEditPart(model);
            }
            if ("measure_header".equals(position)) {
                return new MeasureHandleDataItemEditPart(model);
            }
            if ("measure_aggregation".equals(position) || "cell_measure".equals(position)) {
                return new MeasureAggregationEditPart(model);
            }
        }
        if (model instanceof VirtualCrosstabCellAdapter) {
            return new VirtualCellEditPart(model);
        }
        if (model instanceof CrosstabCellAdapter) {
            if ("first_level_handle".equals(((CrosstabCellAdapter)model).getPositionType()) || "cell_measure".equals(((CrosstabCellAdapter)model).getPositionType())) {
                CrosstabFirstCellEditPart first = new CrosstabFirstCellEditPart(model);
                first.setManager(this.createMenuManager(((CrosstabCellAdapter)model).getPositionType(), context.getViewer()));
                return first;
            }
            return new CrosstabCellEditPart(model);
        }
        return null;
    }

    private MenuManager createMenuManager(String position, EditPartViewer viewer) {
        if ("first_level_handle".equals(position)) {
            return new LevelCrosstabPopMenuProvider(viewer);
        }
        if ("cell_measure".equals(position)) {
            return new MeasureCrosstabPopMenuProvider(viewer);
        }
        throw new RuntimeException("Don't support this position");
    }
}

