/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.views.outline;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Group;
import org.eclipse.bpmn2.Interface;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNLabel;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.ui.views.outline.AbstractGraphicsTreeEditPart;
import org.eclipse.bpmn2.modeler.ui.views.outline.BPMNDiagramTreeEditPart;
import org.eclipse.bpmn2.modeler.ui.views.outline.BPMNEdgeTreeEditPart;
import org.eclipse.bpmn2.modeler.ui.views.outline.BPMNLabelTreeEditPart;
import org.eclipse.bpmn2.modeler.ui.views.outline.BPMNShapeTreeEditPart;
import org.eclipse.bpmn2.modeler.ui.views.outline.BaseElementTreeEditPart;
import org.eclipse.bpmn2.modeler.ui.views.outline.DiagramTreeEditPart;
import org.eclipse.bpmn2.modeler.ui.views.outline.FlowElementTreeEditPart;
import org.eclipse.bpmn2.modeler.ui.views.outline.GroupTreeEditPart;
import org.eclipse.bpmn2.modeler.ui.views.outline.InterfaceTreeEditPart;
import org.eclipse.bpmn2.modeler.ui.views.outline.LaneTreeEditPart;
import org.eclipse.bpmn2.modeler.ui.views.outline.MessageTreeEditPart;
import org.eclipse.bpmn2.modeler.ui.views.outline.OperationTreeEditPart;
import org.eclipse.bpmn2.modeler.ui.views.outline.PoolTreeEditPart;
import org.eclipse.bpmn2.modeler.ui.views.outline.RootElementTreeEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.graphiti.mm.pictograms.Diagram;

public class BPMNDiagramTreeEditPartFactory
implements EditPartFactory {
    private int id;

    public BPMNDiagramTreeEditPartFactory(int id) {
        this.id = id;
    }

    public EditPart createEditPart(EditPart context, Object model) {
        AbstractGraphicsTreeEditPart ret = null;
        if (model instanceof Diagram) {
            ret = new DiagramTreeEditPart(this.id, (Diagram)model);
        } else if (context instanceof AbstractGraphicsTreeEditPart) {
            EditPart root = context;
            while (root.getParent() != null) {
                root = root.getParent();
            }
            DiagramTreeEditPart dep = (DiagramTreeEditPart)((Object)root.getChildren().get(0));
            if (model instanceof Participant) {
                ret = new PoolTreeEditPart(dep, (Participant)model);
            } else if (model instanceof Lane) {
                ret = new LaneTreeEditPart(dep, (Lane)model);
            } else if (model instanceof Group) {
                ret = new GroupTreeEditPart(dep, (Group)model);
            } else if (model instanceof Interface) {
                ret = new InterfaceTreeEditPart(dep, (Interface)model);
            } else if (model instanceof Operation) {
                ret = new OperationTreeEditPart(dep, (Operation)model);
            } else if (model instanceof Group) {
                ret = new GroupTreeEditPart(dep, (Group)model);
            } else if (model instanceof Message) {
                ret = new MessageTreeEditPart(dep, (Message)model);
            } else if (model instanceof RootElement) {
                ret = new RootElementTreeEditPart(dep, (RootElement)model);
            } else if (model instanceof FlowElement) {
                ret = new FlowElementTreeEditPart(dep, (FlowElement)model);
            } else if (model instanceof BaseElement) {
                ret = new BaseElementTreeEditPart(dep, (BaseElement)model);
            } else if (model instanceof BPMNDiagram) {
                ret = new BPMNDiagramTreeEditPart(dep, (BPMNDiagram)model);
            } else if (model instanceof BPMNShape) {
                ret = new BPMNShapeTreeEditPart(dep, (BPMNShape)model);
            } else if (model instanceof BPMNEdge) {
                ret = new BPMNEdgeTreeEditPart(dep, (BPMNEdge)model);
            } else if (model instanceof BPMNLabel) {
                ret = new BPMNLabelTreeEditPart(dep, (BPMNLabel)model);
            }
        }
        return ret;
    }
}

