/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.conversation;

import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.Conversation;
import org.eclipse.bpmn2.ConversationLink;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.modeler.core.features.BaseElementConnectionFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.DefaultDeleteBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractAddFlowFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractCreateFlowFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractReconnectFlowFeature;
import org.eclipse.bpmn2.modeler.core.features.label.UpdateLabelFeature;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.pictograms.Connection;

public class ConversationLinkFeatureContainer
extends BaseElementConnectionFeatureContainer {
    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof ConversationLink;
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddConversationLinkFeature(fp);
    }

    public ICreateConnectionFeature getCreateConnectionFeature(IFeatureProvider fp) {
        return new CreateConversationLinkFeature(fp);
    }

    public IReconnectionFeature getReconnectionFeature(IFeatureProvider fp) {
        return new ReconnectConversationLinkFeature(fp);
    }

    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        return new UpdateLabelFeature(fp);
    }

    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return new DefaultDeleteBPMNShapeFeature(fp){

            protected void deleteBusinessObject(Object bo) {
                if (bo instanceof ConversationLink) {
                    ConversationLink cl = (ConversationLink)bo;
                    if (cl.eContainer() instanceof Collaboration) {
                        Collaboration co = (Collaboration)cl.eContainer();
                        co.getConversationLinks().remove(cl);
                    }
                } else {
                    super.deleteBusinessObject(bo);
                }
            }
        };
    }

    public class AddConversationLinkFeature
    extends AbstractAddFlowFeature<ConversationLink> {
        public AddConversationLinkFeature(IFeatureProvider fp) {
            super(fp);
        }

        protected Polyline createConnectionLine(Connection connection) {
            Polyline connectionLine = super.createConnectionLine(connection);
            connectionLine.setLineWidth(Integer.valueOf(4));
            return connectionLine;
        }

        public Class getBusinessObjectType() {
            return ConversationLink.class;
        }
    }

    public static class CreateConversationLinkFeature
    extends AbstractCreateFlowFeature<ConversationLink, Participant, Conversation> {
        public CreateConversationLinkFeature(IFeatureProvider fp) {
            super(fp);
        }

        protected String getStencilImageId() {
            return ImageProvider.IMG_16_CONVERSATION_LINK;
        }

        protected Class<Participant> getSourceClass() {
            return Participant.class;
        }

        protected Class<Conversation> getTargetClass() {
            return Conversation.class;
        }

        public boolean isAvailable(IContext context) {
            if (!this.isModelObjectEnabled((EObject)Bpmn2Package.eINSTANCE.getConversationLink())) {
                return false;
            }
            return super.isAvailable(context);
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getConversationLink();
        }
    }

    public static class ReconnectConversationLinkFeature
    extends AbstractReconnectFlowFeature {
        public ReconnectConversationLinkFeature(IFeatureProvider fp) {
            super(fp);
        }

        protected Class<? extends EObject> getTargetClass() {
            return Conversation.class;
        }

        protected Class<? extends EObject> getSourceClass() {
            return Participant.class;
        }
    }
}

