/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.ItemAwareElementPropertiesAdapter;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.Messages;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreEList;

public class PropertyPropertiesAdapter
extends ItemAwareElementPropertiesAdapter<Property> {
    public PropertyPropertiesAdapter(AdapterFactory adapterFactory, Property object) {
        super(adapterFactory, object);
        EAttribute feature = Bpmn2Package.eINSTANCE.getProperty_Name();
        FeatureDescriptor<Property> fd = new FeatureDescriptor<Property>((ExtendedPropertiesAdapter)this, object, (EStructuralFeature)feature){

            public void setTextValue(String text) {
                int i = text.lastIndexOf("/");
                if (i >= 0) {
                    text = text.substring(i + 1);
                }
                text = text.trim();
                ((Property)this.object).setName(text);
            }

            public String getChoiceString(Object context) {
                Property property = (Property)this.adopt(context);
                String text = property.getName();
                if (text == null || text.isEmpty()) {
                    text = property.getId();
                }
                EObject container = property.eContainer();
                while (container != null && !(container instanceof Definitions)) {
                    if (container instanceof Participant) {
                        if ((container = ((Participant)container).getProcessRef()) == null) {
                            break;
                        }
                    } else if (container instanceof Activity || container instanceof Process) {
                        text = String.valueOf(ExtendedPropertiesProvider.getTextValue((EObject)container)) + "/" + text;
                    } else if (container instanceof CatchEvent || container instanceof ThrowEvent) {
                        text = String.valueOf(ExtendedPropertiesProvider.getTextValue((EObject)container)) + "/" + text;
                    }
                    container = container.eContainer();
                }
                return text;
            }
        };
        this.setFeatureDescriptor((EStructuralFeature)feature, (FeatureDescriptor)fd);
        this.setObjectDescriptor((ObjectDescriptor)new ObjectDescriptor<Property>((ExtendedPropertiesAdapter)this, object, (FeatureDescriptor)fd){
            private final /* synthetic */ FeatureDescriptor val$fd;
            {
                this.val$fd = featureDescriptor;
                super($anonymous0, (EObject)$anonymous1);
            }

            public void setTextValue(String text) {
                this.val$fd.setTextValue(text);
                ModelUtil.setID((EObject)this.object);
            }

            public String getTextValue() {
                return this.val$fd.getChoiceString((Object)this.object);
            }

            public String getLabel() {
                return Messages.PropertyPropertiesAdapter_Property_Label;
            }
        });
    }

    public static Property createProperty(List<Property> properties) {
        String base = "localVar";
        Resource resource = null;
        if (properties instanceof EcoreEList) {
            EObject owner = ((EcoreEList)properties).getEObject();
            resource = owner.eResource();
            if (owner instanceof Event) {
                base = "eventVar";
            } else if (owner instanceof Process) {
                base = "processVar";
            } else if (owner instanceof Task) {
                base = "taskVar";
            }
        }
        int suffix = 1;
        String name = String.valueOf(base) + suffix;
        while (true) {
            boolean found = false;
            for (Property p : properties) {
                if (!name.equals(p.getName()) && !name.equals(p.getId())) continue;
                found = true;
                break;
            }
            if (!found) break;
            name = String.valueOf(base) + ++suffix;
        }
        Property prop = Bpmn2Factory.eINSTANCE.createProperty();
        ModelUtil.setID((EObject)prop, (Resource)resource);
        prop.setName(name);
        properties.add(prop);
        return prop;
    }
}

