/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.diagram;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Group;
import org.eclipse.bpmn2.modeler.core.features.CompoundCreateFeature;
import org.eclipse.bpmn2.modeler.core.features.CompoundCreateFeaturePart;
import org.eclipse.bpmn2.modeler.core.features.CustomConnectionFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.CustomElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.CustomShapeFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.IBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.IBpmn2CreateFeature;
import org.eclipse.bpmn2.modeler.core.features.ICustomElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.ShowPropertiesFeature;
import org.eclipse.bpmn2.modeler.core.features.activity.ActivitySelectionBehavior;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.features.command.CustomKeyCommandFeature;
import org.eclipse.bpmn2.modeler.core.features.event.EventSelectionBehavior;
import org.eclipse.bpmn2.modeler.core.features.gateway.GatewaySelectionBehavior;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.ModelEnablementDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.runtime.ToolPaletteDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.bpmn2.modeler.core.validation.ValidationStatusAdapter;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.diagram.BPMN2FeatureProvider;
import org.eclipse.bpmn2.modeler.ui.diagram.Bpmn2FeatureMap;
import org.eclipse.bpmn2.modeler.ui.diagram.Messages;
import org.eclipse.bpmn2.modeler.ui.editor.DefaultBPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ChoreographySelectionBehavior;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.FeatureCheckerAdapter;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureAndContext;
import org.eclipse.graphiti.features.IFeatureChecker;
import org.eclipse.graphiti.features.IFeatureCheckerHolder;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.palette.IPaletteCompartmentEntry;
import org.eclipse.graphiti.palette.IToolEntry;
import org.eclipse.graphiti.palette.impl.ConnectionCreationToolEntry;
import org.eclipse.graphiti.palette.impl.ObjectCreationToolEntry;
import org.eclipse.graphiti.palette.impl.PaletteCompartmentEntry;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IContextMenuEntry;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.ImageDecorator;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.util.ILocationInfo;
import org.eclipse.graphiti.util.LocationInfo;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;

public class Bpmn2ToolBehaviorProvider
extends DefaultToolBehaviorProvider
implements IFeatureCheckerHolder {
    protected DefaultBPMN2Editor editor;
    protected TargetRuntime targetRuntime;
    protected BPMN2FeatureProvider featureProvider;
    protected ModelEnablements modelEnablements;
    protected Hashtable<String, PaletteCompartmentEntry> categories = new Hashtable();
    protected List<IPaletteCompartmentEntry> palette;
    protected CustomKeyCommandFeature commandFeature = null;

    public Bpmn2ToolBehaviorProvider(IDiagramTypeProvider diagramTypeProvider) {
        super(diagramTypeProvider);
    }

    public void createPaletteProfilesGroup(DefaultBPMN2Editor editor, PaletteRoot paletteRoot) {
        TargetRuntime rt = editor.getTargetRuntime();
        PaletteDrawer drawer = new PaletteDrawer(Messages.BPMNToolBehaviorProvider_Profiles_Drawer_Label, null);
        int size = 0;
        String[] stringArray = editor.getPreferences().getAllToolProfiles(rt);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String profileId = stringArray[n2];
            drawer.add((PaletteEntry)new ProfileSelectionToolEntry(editor, profileId));
            ++size;
            ++n2;
        }
        if (size > 1) {
            drawer.setInitialState(1);
            paletteRoot.add(1, (PaletteEntry)drawer);
        }
    }

    public IPaletteCompartmentEntry[] getPalette() {
        DefaultBPMN2Editor editor = (DefaultBPMN2Editor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
        this.targetRuntime = editor.getTargetRuntime();
        this.modelEnablements = editor.getModelEnablements();
        this.featureProvider = (BPMN2FeatureProvider)this.getFeatureProvider();
        this.palette = new ArrayList<IPaletteCompartmentEntry>();
        String profile = editor.getPreferences().getDefaultToolProfile(this.targetRuntime);
        PaletteCompartmentEntry compartmentEntry = null;
        this.categories.clear();
        ToolPaletteDescriptor toolPaletteDescriptor = this.targetRuntime.getToolPalette(profile);
        if (toolPaletteDescriptor != null) {
            boolean needCustomTaskDrawer = true;
            block0: for (ToolPaletteDescriptor.CategoryDescriptor category : toolPaletteDescriptor.getCategories()) {
                IFeature feature;
                if ("org.bpmn2.modeler.toolpalette.default.categories".equals(category.getId())) {
                    this.createDefaultpalette();
                    needCustomTaskDrawer = false;
                    continue;
                }
                ToolPaletteDescriptor.CategoryDescriptor realCategory = this.getRealCategory(this.targetRuntime, category);
                compartmentEntry = this.categories.get(realCategory.getName());
                for (ToolPaletteDescriptor.ToolDescriptor tool : realCategory.getTools()) {
                    feature = this.getCreateFeature(tool = this.getRealTool(this.targetRuntime, tool));
                    if (feature == null) continue;
                    if (compartmentEntry == null) {
                        compartmentEntry = new PaletteCompartmentEntry(realCategory.getName(), realCategory.getIcon());
                        compartmentEntry.setInitiallyOpen(false);
                        this.categories.put(realCategory.getName(), compartmentEntry);
                    }
                    this.createEntry(tool, feature, compartmentEntry);
                }
                if (category != realCategory) {
                    for (ToolPaletteDescriptor.ToolDescriptor tool : category.getTools()) {
                        feature = this.getCreateFeature(tool = this.getRealTool(this.targetRuntime, tool));
                        if (feature == null) continue;
                        if (compartmentEntry == null) {
                            compartmentEntry = new PaletteCompartmentEntry(category.getName(), category.getIcon());
                            compartmentEntry.setInitiallyOpen(false);
                            this.categories.put(category.getName(), compartmentEntry);
                        }
                        this.createEntry(tool, feature, compartmentEntry);
                    }
                }
                if (compartmentEntry == null) {
                    for (CustomTaskDescriptor tc : this.targetRuntime.getCustomTaskDescriptors()) {
                        if (!category.getName().equals(tc.getCategory())) continue;
                        compartmentEntry = new PaletteCompartmentEntry(category.getName(), category.getIcon());
                        compartmentEntry.setInitiallyOpen(false);
                        this.categories.put(category.getName(), compartmentEntry);
                        this.palette.add((IPaletteCompartmentEntry)compartmentEntry);
                        continue block0;
                    }
                    continue;
                }
                if (compartmentEntry.getToolEntries().size() <= 0) continue;
                this.palette.add((IPaletteCompartmentEntry)compartmentEntry);
            }
            if (needCustomTaskDrawer) {
                this.createCustomTasks(this.palette);
            }
        } else {
            this.createDefaultpalette();
        }
        return this.palette.toArray(new IPaletteCompartmentEntry[this.palette.size()]);
    }

    private ToolPaletteDescriptor.CategoryDescriptor getRealCategory(TargetRuntime rt, ToolPaletteDescriptor.CategoryDescriptor category) {
        String fromPalette = category.getFromPalette();
        String id = category.getId();
        if (fromPalette != null && id != null) {
            for (TargetRuntime otherRt : TargetRuntime.createTargetRuntimes()) {
                for (ToolPaletteDescriptor tp : otherRt.getToolPaletteDescriptors()) {
                    if (!fromPalette.equals(tp.getId())) continue;
                    for (ToolPaletteDescriptor.CategoryDescriptor c : tp.getCategories()) {
                        if (!id.equals(c.getId())) continue;
                        return c;
                    }
                }
            }
        }
        return category;
    }

    private ToolPaletteDescriptor.ToolDescriptor getRealTool(TargetRuntime rt, ToolPaletteDescriptor.ToolDescriptor tool) {
        String fromPalette = tool.getFromPalette();
        String id = tool.getId();
        if (fromPalette != null && id != null) {
            for (TargetRuntime otherRt : TargetRuntime.createTargetRuntimes()) {
                for (ToolPaletteDescriptor tp : otherRt.getToolPaletteDescriptors()) {
                    if (!fromPalette.equals(tp.getId())) continue;
                    for (ToolPaletteDescriptor.CategoryDescriptor c : tp.getCategories()) {
                        for (ToolPaletteDescriptor.ToolDescriptor t : c.getTools()) {
                            if (!id.equals(t.getId())) continue;
                            return t;
                        }
                    }
                }
            }
        }
        return tool;
    }

    private void createDefaultpalette() {
        this.createDrawer(Messages.BPMNToolBehaviorProvider_Connectors_Drawer_Label, Bpmn2FeatureMap.CONNECTIONS, this.palette);
        this.createDrawer(Messages.BPMNToolBehaviorProvider_SwimLanes_Drawer_Label, Bpmn2FeatureMap.SWIMLANES, this.palette);
        this.createDrawer(Messages.BPMNToolBehaviorProvider_Tasks_Drawer_Label, Bpmn2FeatureMap.TASKS, this.palette);
        this.createDrawer(Messages.BPMNToolBehaviorProvider_Gateways_Drawer_Label, Bpmn2FeatureMap.GATEWAYS, this.palette);
        this.createDrawer(Messages.BPMNToolBehaviorProvider_Events_Drawer_Label, Bpmn2FeatureMap.EVENTS, this.palette);
        this.createDrawer(Messages.BPMNToolBehaviorProvider_Event_Definitions_Drawer_Label, Bpmn2FeatureMap.EVENT_DEFINITIONS, this.palette);
        this.createDrawer(Messages.BPMNToolBehaviorProvider_Data_Items_Drawer_Label, Bpmn2FeatureMap.DATA, this.palette);
        this.createDrawer(Messages.BPMNToolBehaviorProvider_SubProcess_Drawer_Label, Bpmn2FeatureMap.SUBPROCESS, this.palette);
        this.createDrawer(Messages.BPMNToolBehaviorProvider_GlobalTasks_Drawer_Label, Bpmn2FeatureMap.GLOBAL_TASKS, this.palette);
        this.createDrawer(Messages.BPMNToolBehaviorProvider_Choreography_Drawer_Label, Bpmn2FeatureMap.CHOREOGRAPHY, this.palette);
        this.createDrawer(Messages.BPMNToolBehaviorProvider_Conversation_Drawer_Label, Bpmn2FeatureMap.CONVERSATION, this.palette);
        this.createDrawer(Messages.BPMNToolBehaviorProvider_Artifact_Drawer_Label, Bpmn2FeatureMap.ARTIFACTS, this.palette);
        this.createCustomTasks(this.palette);
    }

    public static List<Tuple<String, List<Class>>> getDefaultPaletteDrawers() {
        ArrayList<Tuple<String, List<Class>>> drawers = new ArrayList<Tuple<String, List<Class>>>();
        drawers.add(new Tuple((Object)Messages.BPMNToolBehaviorProvider_Connectors_Drawer_Label, Bpmn2FeatureMap.CONNECTIONS));
        drawers.add(new Tuple((Object)Messages.BPMNToolBehaviorProvider_SwimLanes_Drawer_Label, Bpmn2FeatureMap.SWIMLANES));
        drawers.add(new Tuple((Object)Messages.BPMNToolBehaviorProvider_Tasks_Drawer_Label, Bpmn2FeatureMap.TASKS));
        drawers.add(new Tuple((Object)Messages.BPMNToolBehaviorProvider_Gateways_Drawer_Label, Bpmn2FeatureMap.GATEWAYS));
        drawers.add(new Tuple((Object)Messages.BPMNToolBehaviorProvider_Events_Drawer_Label, Bpmn2FeatureMap.EVENTS));
        drawers.add(new Tuple((Object)Messages.BPMNToolBehaviorProvider_Event_Definitions_Drawer_Label, Bpmn2FeatureMap.EVENT_DEFINITIONS));
        drawers.add(new Tuple((Object)Messages.BPMNToolBehaviorProvider_Data_Items_Drawer_Label, Bpmn2FeatureMap.DATA));
        drawers.add(new Tuple((Object)Messages.BPMNToolBehaviorProvider_SubProcess_Drawer_Label, Bpmn2FeatureMap.SUBPROCESS));
        drawers.add(new Tuple((Object)Messages.BPMNToolBehaviorProvider_GlobalTasks_Drawer_Label, Bpmn2FeatureMap.GLOBAL_TASKS));
        drawers.add(new Tuple((Object)Messages.BPMNToolBehaviorProvider_Choreography_Drawer_Label, Bpmn2FeatureMap.CHOREOGRAPHY));
        drawers.add(new Tuple((Object)Messages.BPMNToolBehaviorProvider_Conversation_Drawer_Label, Bpmn2FeatureMap.CONVERSATION));
        drawers.add(new Tuple((Object)Messages.BPMNToolBehaviorProvider_Artifact_Drawer_Label, Bpmn2FeatureMap.ARTIFACTS));
        return drawers;
    }

    public List<IToolEntry> getTools() {
        ArrayList<IToolEntry> tools = new ArrayList<IToolEntry>();
        if (this.palette == null) {
            this.getPalette();
        }
        for (IPaletteCompartmentEntry ce : this.palette) {
            for (IToolEntry te : ce.getToolEntries()) {
                tools.add(te);
            }
        }
        return tools;
    }

    public IPaletteCompartmentEntry getCategory(IToolEntry tool) {
        if (this.palette == null) {
            this.getPalette();
        }
        for (IPaletteCompartmentEntry ce : this.palette) {
            for (IToolEntry te : ce.getToolEntries()) {
                if (te != tool) continue;
                return ce;
            }
        }
        return null;
    }

    private IFeature getCreateFeature(ToolPaletteDescriptor.ToolDescriptor tool) {
        if (tool.getToolParts().size() == 1) {
            return this.getCreateFeature(tool, null, null, (ToolPaletteDescriptor.ToolPart)tool.getToolParts().get(0));
        }
        CompoundCreateFeature compoundFeature = null;
        for (ToolPaletteDescriptor.ToolPart tp : tool.getToolParts()) {
            if (compoundFeature == null) {
                compoundFeature = new CompoundCreateFeature((IFeatureProvider)this.featureProvider, tool);
            }
            this.getCreateFeature(tool, compoundFeature, null, tp);
        }
        return compoundFeature;
    }

    private IFeature getCreateFeature(ToolPaletteDescriptor.ToolDescriptor tool, CompoundCreateFeature root, CompoundCreateFeaturePart node, ToolPaletteDescriptor.ToolPart toolPart) {
        IFeature parentFeature = null;
        String name = toolPart.getName();
        EClassifier eClass = Bpmn2Package.eINSTANCE.getEClassifier(name);
        if (eClass != null) {
            parentFeature = this.featureProvider.getCreateFeatureForBusinessObject(eClass.getInstanceClass());
        } else {
            Activator.logError(new IllegalArgumentException("The object type '" + name + "' referenced by the tool '" + root.getName() + "' is undefined"));
        }
        if (root != null) {
            if (node != null) {
                CompoundCreateFeaturePart n = node.addChild(parentFeature);
                if (toolPart.hasProperties()) {
                    n.setProperties(toolPart.getProperties());
                }
                node = n;
            } else {
                node = root.addChild(parentFeature);
                if (toolPart.hasProperties()) {
                    node.setProperties(toolPart.getProperties());
                }
            }
        } else if (toolPart.hasProperties()) {
            root = new CompoundCreateFeature((IFeatureProvider)this.featureProvider, tool);
            node = root.addChild(parentFeature);
            node.setProperties(toolPart.getProperties());
            parentFeature = root;
        }
        for (ToolPaletteDescriptor.ToolPart childToolPart : toolPart.getChildren()) {
            if (root == null) {
                root = new CompoundCreateFeature((IFeatureProvider)this.featureProvider, tool);
                node = root.addChild(parentFeature);
                parentFeature = root;
            }
            this.getCreateFeature(tool, root, node, childToolPart);
        }
        return parentFeature;
    }

    private void createDrawer(String name, List<Class> items, List<IPaletteCompartmentEntry> palette) {
        PaletteCompartmentEntry compartmentEntry = new PaletteCompartmentEntry(name, null);
        compartmentEntry.setInitiallyOpen(false);
        this.createEntries(items, compartmentEntry);
        if (compartmentEntry.getToolEntries().size() > 0) {
            palette.add((IPaletteCompartmentEntry)compartmentEntry);
        }
    }

    private void createEntries(List<Class> neededEntries, PaletteCompartmentEntry compartmentEntry) {
        for (Class o : neededEntries) {
            if (!(o instanceof Class)) continue;
            this.createEntry(o, compartmentEntry);
        }
    }

    private boolean isEnabled(String className) {
        return this.modelEnablements.isEnabled(className);
    }

    private void createEntry(Class c, PaletteCompartmentEntry compartmentEntry) {
        if (this.isEnabled(c.getSimpleName())) {
            IFeature feature = this.featureProvider.getCreateFeatureForBusinessObject(c);
            if (feature instanceof ICreateFeature) {
                ICreateFeature cf = (ICreateFeature)feature;
                ObjectCreationToolEntry objectCreationToolEntry = new ObjectCreationToolEntry(cf.getCreateName(), cf.getDescription(), cf.getCreateImageId(), cf.getCreateLargeImageId(), cf);
                compartmentEntry.addToolEntry((IToolEntry)objectCreationToolEntry);
            } else if (feature instanceof ICreateConnectionFeature) {
                ICreateConnectionFeature cf = (ICreateConnectionFeature)feature;
                ConnectionCreationToolEntry connectionCreationToolEntry = new ConnectionCreationToolEntry(cf.getCreateName(), cf.getDescription(), cf.getCreateImageId(), cf.getCreateLargeImageId());
                connectionCreationToolEntry.addCreateConnectionFeature(cf);
                compartmentEntry.addToolEntry((IToolEntry)connectionCreationToolEntry);
            }
        }
    }

    private void createEntry(ToolPaletteDescriptor.ToolDescriptor tool, IFeature feature, PaletteCompartmentEntry compartmentEntry) {
        if (this.modelEnablements.isEnabled(feature) || feature instanceof CompoundCreateFeature) {
            CompoundCreateFeature cf;
            IFeature targetFeature = feature;
            if (feature instanceof CompoundCreateFeature) {
                cf = (CompoundCreateFeature)feature;
                targetFeature = ((CompoundCreateFeaturePart)cf.getChildren().get(0)).getFeature();
            }
            if (targetFeature instanceof ICreateFeature) {
                String description;
                cf = (ICreateFeature)feature;
                String name = tool.getName();
                if (name == null) {
                    name = cf.getName();
                }
                if ((description = tool.getDescription()) == null) {
                    description = cf.getCreateDescription();
                }
                ObjectCreationToolEntry objectCreationToolEntry = new ObjectCreationToolEntry(name, description, cf.getCreateImageId(), cf.getCreateLargeImageId(), (ICreateFeature)cf);
                compartmentEntry.addToolEntry((IToolEntry)objectCreationToolEntry);
            } else if (targetFeature instanceof ICreateConnectionFeature) {
                String description;
                cf = (ICreateConnectionFeature)feature;
                String name = tool.getName();
                if (name == null) {
                    name = cf.getName();
                }
                if ((description = tool.getDescription()) == null) {
                    description = cf.getCreateDescription();
                }
                ConnectionCreationToolEntry connectionCreationToolEntry = new ConnectionCreationToolEntry(name, description, cf.getCreateImageId(), cf.getCreateLargeImageId());
                connectionCreationToolEntry.addCreateConnectionFeature((ICreateConnectionFeature)cf);
                compartmentEntry.addToolEntry((IToolEntry)connectionCreationToolEntry);
            }
        }
    }

    private void createCustomTasks(List<IPaletteCompartmentEntry> ret) {
        PaletteCompartmentEntry compartmentEntry = null;
        DefaultBPMN2Editor editor = (DefaultBPMN2Editor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
        TargetRuntime rt = editor.getTargetRuntime();
        try {
            for (IPaletteCompartmentEntry e : ret) {
                this.categories.put(e.getLabel(), (PaletteCompartmentEntry)e);
            }
            for (CustomTaskDescriptor ctd : rt.getCustomTaskDescriptors()) {
                ICreateFeature cf;
                CustomElementFeatureContainer container = (CustomElementFeatureContainer)ctd.getFeatureContainer();
                if (!container.isAvailable((IFeatureProvider)this.featureProvider)) continue;
                ObjectCreationToolEntry toolEntry = null;
                String id = ctd.getId();
                container.setId(id);
                this.featureProvider.addFeatureContainer(id, (ICustomElementFeatureContainer)container);
                if (container instanceof CustomShapeFeatureContainer) {
                    ObjectCreationToolEntry objectCreationToolEntry;
                    cf = ((CustomShapeFeatureContainer)container).getCreateFeature((IFeatureProvider)this.featureProvider);
                    toolEntry = objectCreationToolEntry = new ObjectCreationToolEntry(ctd.getName(), ctd.getDescription(), cf.getCreateImageId(), cf.getCreateLargeImageId(), cf);
                } else if (container instanceof CustomConnectionFeatureContainer) {
                    cf = ((CustomConnectionFeatureContainer)container).getCreateConnectionFeature((IFeatureProvider)this.featureProvider);
                    ConnectionCreationToolEntry connectionCreationToolEntry = new ConnectionCreationToolEntry(cf.getCreateName(), ctd.getDescription(), cf.getCreateImageId(), cf.getCreateLargeImageId());
                    connectionCreationToolEntry.addCreateConnectionFeature((ICreateConnectionFeature)cf);
                    toolEntry = connectionCreationToolEntry;
                }
                String category = ctd.getCategory();
                if (category == null || category.isEmpty()) {
                    category = Messages.BPMNToolBehaviorProvider_Custom_Tasks_Drawer_Label;
                }
                if ((compartmentEntry = this.categories.get(category)) == null) {
                    compartmentEntry = new PaletteCompartmentEntry(category, null);
                    compartmentEntry.setInitiallyOpen(false);
                    ret.add((IPaletteCompartmentEntry)compartmentEntry);
                    this.categories.put(category, compartmentEntry);
                }
                compartmentEntry.addToolEntry((IToolEntry)toolEntry);
            }
        }
        catch (Exception ex) {
            Activator.logError(ex);
        }
    }

    public IFeatureChecker getFeatureChecker() {
        return new FeatureCheckerAdapter(false){

            public boolean allowAdd(IContext context) {
                return super.allowAdd(context);
            }

            public boolean allowCreate() {
                return super.allowCreate();
            }
        };
    }

    private boolean isLabelShape(PictogramElement pe) {
        return FeatureSupport.isLabelShape((PictogramElement)pe) && FeatureSupport.getLabelOwner((PictogramElement)pe) != null;
    }

    public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
        if (ActivitySelectionBehavior.canApplyTo((PictogramElement)pe)) {
            return ActivitySelectionBehavior.getClickArea((PictogramElement)pe);
        }
        if (EventSelectionBehavior.canApplyTo((PictogramElement)pe)) {
            return EventSelectionBehavior.getClickArea((PictogramElement)pe);
        }
        if (ChoreographySelectionBehavior.canApplyTo(pe)) {
            return ChoreographySelectionBehavior.getClickArea(pe);
        }
        if (GatewaySelectionBehavior.canApplyTo((PictogramElement)pe)) {
            return GatewaySelectionBehavior.getClickArea((PictogramElement)pe);
        }
        if (this.isLabelShape(pe)) {
            return this.getClickArea(FeatureSupport.getLabelOwner((PictogramElement)pe));
        }
        return super.getClickArea(pe);
    }

    public int getLineSelectionWidth(Polyline polyline) {
        PictogramElement pe = polyline.getPictogramElement();
        if (pe != null && BusinessObjectUtil.getFirstBaseElement((PictogramElement)pe) instanceof Group) {
            return 20;
        }
        return super.getLineSelectionWidth(polyline);
    }

    public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
        if (ActivitySelectionBehavior.canApplyTo((PictogramElement)pe)) {
            return ActivitySelectionBehavior.getSelectionBorder((PictogramElement)pe);
        }
        if (EventSelectionBehavior.canApplyTo((PictogramElement)pe)) {
            return EventSelectionBehavior.getSelectionBorder((PictogramElement)pe);
        }
        if (ChoreographySelectionBehavior.canApplyTo(pe)) {
            return ChoreographySelectionBehavior.getSelectionBorder(pe);
        }
        if (GatewaySelectionBehavior.canApplyTo((PictogramElement)pe)) {
            return GatewaySelectionBehavior.getSelectionBorder((PictogramElement)pe);
        }
        if (this.isLabelShape(pe)) {
            return this.getSelectionBorder(FeatureSupport.getLabelOwner((PictogramElement)pe));
        }
        if (pe instanceof ContainerShape && ((ContainerShape)pe).getChildren().size() > 0) {
            GraphicsAlgorithm ga = ((Shape)((ContainerShape)pe).getChildren().get(0)).getGraphicsAlgorithm();
            if (!(ga instanceof AbstractText) && !(ga instanceof Polyline)) {
                return ga;
            }
            ga = ((ContainerShape)pe).getGraphicsAlgorithm();
            if (ga.getGraphicsAlgorithmChildren().size() > 0) {
                return (GraphicsAlgorithm)ga.getGraphicsAlgorithmChildren().get(0);
            }
            return ga;
        }
        return super.getSelectionBorder(pe);
    }

    public PictogramElement getSelection(PictogramElement originalPe, PictogramElement[] oldSelection) {
        if (this.isLabelShape(originalPe) && FeatureSupport.getLabelPosition((PictogramElement)originalPe) != ShapeStyle.LabelPosition.MOVABLE) {
            return FeatureSupport.getLabelOwner((PictogramElement)originalPe);
        }
        return null;
    }

    public static org.eclipse.graphiti.mm.algorithms.styles.Point getMouseLocation(IFeatureProvider fp) {
        DiagramBehavior db = (DiagramBehavior)fp.getDiagramTypeProvider().getDiagramBehavior();
        Point p = db.getMouseLocation();
        p = db.calculateRealMouseLocation(p);
        org.eclipse.graphiti.mm.algorithms.styles.Point point = GraphicsUtil.createPoint((int)p.x, (int)p.y);
        return point;
    }

    public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
        IContextButtonPadData data = super.getContextButtonPad(context);
        PictogramElement pe = context.getPictogramElement();
        if (this.isLabelShape(pe)) {
            pe = FeatureSupport.getLabelOwner((PictogramElement)pe);
        }
        IFeatureProvider fp = this.getFeatureProvider();
        if (pe.getGraphicsAlgorithm() != null && pe.getGraphicsAlgorithm().getWidth() < 40) {
            ILocation origin = this.getAbsoluteLocation(pe.getGraphicsAlgorithm());
            data.getPadLocation().setRectangle(origin.getX(), origin.getY(), 40, 40);
        }
        int genericButtons = CONTEXT_BUTTON_DELETE;
        if (ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)pe)) {
            genericButtons |= CONTEXT_BUTTON_REMOVE;
        }
        this.setGenericContextButtons(data, pe, genericButtons);
        CustomContext cc = new CustomContext(new PictogramElement[]{pe});
        ICustomFeature[] iCustomFeatureArray = fp.getCustomFeatures((ICustomContext)cc);
        int n = iCustomFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICustomFeature cf = iCustomFeatureArray[n2];
            if (cf.isAvailable((IContext)cc) && cf.canExecute((ICustomContext)cc)) {
                ContextButtonEntry button = new ContextButtonEntry((IFeature)cf, (IContext)cc);
                button.setText(cf.getName());
                button.setIconId(cf.getImageId());
                button.setDescription(cf.getDescription());
                data.getDomainSpecificContextButtons().add(button);
            }
            ++n2;
        }
        CreateConnectionContext ccc = new CreateConnectionContext();
        ccc.setSourcePictogramElement(pe);
        Anchor anchor = null;
        if (pe instanceof Anchor) {
            anchor = (Anchor)pe;
        } else if (pe instanceof AnchorContainer) {
            anchor = Graphiti.getPeService().getChopboxAnchor((AnchorContainer)pe);
        }
        ccc.setSourceAnchor(anchor);
        ContextButtonEntry button = new ContextButtonEntry(null, (IContext)context);
        button.setText(Messages.Bpmn2ToolBehaviorProvider_Create_Connection);
        String description = null;
        ArrayList<String> names = new ArrayList<String>();
        button.setIconId(ImageProvider.IMG_16_SEQUENCE_FLOW);
        for (IToolEntry te : this.getTools()) {
            if (!(te instanceof ConnectionCreationToolEntry)) continue;
            ConnectionCreationToolEntry cte = (ConnectionCreationToolEntry)te;
            for (IFeature f : cte.getCreateConnectionFeatures()) {
                ICreateConnectionFeature ccf = (ICreateConnectionFeature)f;
                if (!ccf.isAvailable((IContext)ccc) || !ccf.canStartConnection((ICreateConnectionContext)ccc)) continue;
                button.addDragAndDropFeature((IFeature)ccf);
                names.add(ccf.getCreateName());
            }
        }
        int i = 0;
        while (i < names.size()) {
            if (description == null) {
                description = Messages.BPMNToolBehaviorProvider_Click_Drag_Prompt;
            }
            description = String.valueOf(description) + (String)names.get(i);
            if (i + 2 == names.size()) {
                description = String.valueOf(description) + Messages.BPMNToolBehaviorProvider_Click_Drag_Prompt_Last_Separator;
            } else if (i + 1 < names.size()) {
                description = String.valueOf(description) + ",";
            }
            ++i;
        }
        button.setDescription(description);
        if (button.getDragAndDropFeatures().size() > 0) {
            data.getDomainSpecificContextButtons().add(button);
        }
        return data;
    }

    public IContextMenuEntry[] getContextMenu(ICustomContext context) {
        IContextMenuEntry[] entries;
        IContextMenuEntry[] iContextMenuEntryArray = entries = super.getContextMenu(context);
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IContextMenuEntry e = iContextMenuEntryArray[n2];
            String key = "context.menu.entry." + e.getFeature().getName();
            context.putProperty((Object)key, (Object)e);
            e.getFeature().canExecute((IContext)context);
            ++n2;
        }
        return entries;
    }

    protected ILocation getAbsoluteLocation(GraphicsAlgorithm ga) {
        if (ga.eContainer() instanceof ConnectionDecorator) {
            return Graphiti.getPeService().getLocationRelativeToDiagram((Shape)((ConnectionDecorator)ga.eContainer()));
        }
        return super.getAbsoluteLocation(ga);
    }

    public void postExecute(IExecutionInfo executionInfo) {
        IFeatureAndContext[] iFeatureAndContextArray = executionInfo.getExecutionList();
        int n = iFeatureAndContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureAndContext fc = iFeatureAndContextArray[n2];
            IContext context = fc.getContext();
            IFeature feature = fc.getFeature();
            if (context instanceof AddContext) {
                if (feature instanceof IBpmn2AddFeature) {
                    ((IBpmn2AddFeature)feature).postExecute(executionInfo);
                }
            } else if (context instanceof CreateContext && feature instanceof IBpmn2CreateFeature) {
                ((IBpmn2CreateFeature)feature).postExecute(executionInfo);
            }
            ++n2;
        }
    }

    public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
        ICustomFeature[] cf = this.getFeatureProvider().getCustomFeatures((ICustomContext)context);
        int i = 0;
        while (i < cf.length) {
            ICustomFeature iCustomFeature = cf[i];
            if (iCustomFeature instanceof ShowPropertiesFeature && iCustomFeature.canExecute((ICustomContext)context)) {
                return iCustomFeature;
            }
            ++i;
        }
        PictogramElement[] pictogramElementArray = context.getPictogramElements();
        int n = pictogramElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement pe = pictogramElementArray[n2];
            String id = FeatureSupport.getPropertyValue((PropertyContainer)pe, (String)"ROUTING_NET_CONNECTION");
            if (pe instanceof FreeFormConnection) {
                System.out.println("id=" + id);
                FreeFormConnection c = (FreeFormConnection)pe;
                int i2 = 0;
                ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram(c.getStart());
                System.out.println("0: " + loc.getX() + "," + loc.getY());
                for (org.eclipse.graphiti.mm.algorithms.styles.Point p : c.getBendpoints()) {
                    System.out.println(String.valueOf(++i2) + ": " + p.getX() + "," + p.getY());
                }
                loc = Graphiti.getPeService().getLocationRelativeToDiagram(c.getEnd());
                System.out.println(String.valueOf(++i2) + ": " + loc.getX() + "," + loc.getY());
            }
            ++n2;
        }
        return null;
    }

    public GraphicsAlgorithm getChopboxAnchorArea(PictogramElement pe) {
        return super.getChopboxAnchorArea(pe);
    }

    public IDecorator[] getDecorators(PictogramElement pe) {
        ValidationStatusAdapter statusAdapter;
        IFeatureProvider featureProvider;
        Object bo;
        ArrayList<ImageDecorator> decorators = new ArrayList<ImageDecorator>();
        if (ShapeDecoratorUtil.isValidationDecorator((PictogramElement)pe) && (bo = (featureProvider = this.getFeatureProvider()).getBusinessObjectForPictogramElement((PictogramElement)pe.eContainer())) != null && (statusAdapter = (ValidationStatusAdapter)EcoreUtil.getRegisteredAdapter((EObject)((EObject)bo), ValidationStatusAdapter.class)) != null) {
            ImageDecorator decorator;
            IStatus status = statusAdapter.getValidationStatus();
            switch (status.getSeverity()) {
                case 1: {
                    decorator = new ImageDecorator("org.eclipse.graphiti.eclipse.information.tsk");
                    break;
                }
                case 2: {
                    decorator = new ImageDecorator("org.eclipse.graphiti.eclipse.warning.tsk");
                    break;
                }
                case 4: {
                    decorator = new ImageDecorator("org.eclipse.graphiti.eclipse.error.tsk");
                    break;
                }
                default: {
                    decorator = null;
                }
            }
            if (decorator != null) {
                decorator.setMessage(status.getMessage());
                decorators.add(decorator);
            }
        }
        return decorators.toArray(new IDecorator[decorators.size()]);
    }

    public ICustomFeature getCommandFeature(CustomContext context, String hint) {
        if (this.commandFeature == null) {
            this.commandFeature = new CustomKeyCommandFeature(this.getFeatureProvider());
        }
        if (this.commandFeature.isAvailable(hint)) {
            context.putProperty((Object)"command.hint", (Object)hint);
            return this.commandFeature;
        }
        return super.getCommandFeature(context, hint);
    }

    public ILocationInfo getLocationInfo(PictogramElement pe, ILocationInfo locationInfo) {
        if (locationInfo == null && pe instanceof ContainerShape) {
            ContainerShape shape = (ContainerShape)pe;
            locationInfo = new LocationInfo((Shape)shape, shape.getGraphicsAlgorithm());
        }
        return locationInfo;
    }

    public Object getToolTip(GraphicsAlgorithm ga) {
        return FeatureSupport.getToolTip((GraphicsAlgorithm)ga);
    }

    protected class ProfileSelectionToolEntry
    extends ToolEntry {
        DefaultBPMN2Editor editor;

        ProfileSelectionToolEntry(DefaultBPMN2Editor editor, String profileId) {
            super("", null, null, null, null);
            TargetRuntime rt = editor.getTargetRuntime();
            ModelEnablementDescriptor med = rt.getModelEnablements(profileId);
            if (med != null) {
                this.setLabel(med.getProfileName());
                this.setId(profileId);
                this.setDescription(med.getDescription());
            }
            this.editor = editor;
        }

        public Tool createTool() {
            TargetRuntime rt = this.editor.getTargetRuntime();
            this.editor.getPreferences().setDefaultToolProfile(rt, this.getId());
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProfileSelectionToolEntry.this.editor.updatePalette();
                }
            });
            return null;
        }

        public ImageDescriptor getLargeIcon() {
            return super.getSmallIcon();
        }

        public ImageDescriptor getSmallIcon() {
            TargetRuntime rt = this.editor.getTargetRuntime();
            String profileId = this.editor.getPreferences().getDefaultToolProfile(rt);
            if (this.getId().equals(profileId)) {
                return Activator.getDefault().getImageDescriptor("obj16/checkbox-checked.png");
            }
            return Activator.getDefault().getImageDescriptor("obj16/checkbox-unchecked.png");
        }
    }
}

