/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.providers;

import java.util.HashMap;
import java.util.Vector;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public abstract class CachedTreeContentProvider
implements ITreeContentProvider {
    protected static final Object[] EMPTY_ARRAY = new Object[0];
    public static final Object UNKNOWN_PARENT = new Object();
    protected HashMap treeNodeToParent = new HashMap();
    protected HashMap treeNodeToChildren = new HashMap();
    Object[] rootChildren;

    protected abstract boolean primHasChildren(Object var1);

    protected abstract Object[] primGetChildren(Object var1);

    protected abstract Object[] primGetElements(Object var1);

    public Object[] getPathToRoot(Object node) {
        Vector<Object> v = new Vector<Object>();
        while (node != null && node != UNKNOWN_PARENT) {
            v.add(node);
            node = this.getParent(node);
        }
        return v.toArray();
    }

    public final Object[] getElements(Object node) {
        if (this.rootChildren == null) {
            this.rootChildren = this.primGetElements(node);
            if (this.rootChildren == null) {
                this.rootChildren = EMPTY_ARRAY;
            }
            int i = 0;
            while (i < this.rootChildren.length) {
                this.treeNodeToParent.put(this.rootChildren[i], null);
                ++i;
            }
        }
        return this.rootChildren;
    }

    public final boolean hasChildren(Object node) {
        Object[] result = (Object[])this.treeNodeToChildren.get(node);
        if (result != null) {
            return result.length > 0;
        }
        if (this.treeNodeToChildren.containsKey(node)) {
            return true;
        }
        if (this.primHasChildren(node)) {
            this.treeNodeToChildren.put(node, null);
            return true;
        }
        this.treeNodeToChildren.put(node, EMPTY_ARRAY);
        return false;
    }

    public final Object[] getChildren(Object node) {
        Object[] result = (Object[])this.treeNodeToChildren.get(node);
        if (result == null) {
            result = this.primGetChildren(node);
            if (result == null) {
                result = EMPTY_ARRAY;
            }
            this.treeNodeToChildren.put(node, result);
            int i = 0;
            while (i < result.length) {
                this.treeNodeToParent.put(result[i], node);
                ++i;
            }
        }
        return result;
    }

    public final Object getParent(Object node) {
        if (node == UNKNOWN_PARENT) {
            return null;
        }
        Object result = this.treeNodeToParent.get(node);
        if (result != null || this.treeNodeToParent.containsKey(node)) {
            return result;
        }
        return UNKNOWN_PARENT;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.rootChildren = null;
        this.treeNodeToParent.clear();
        this.treeNodeToChildren.clear();
    }
}

