/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.Messages;
import org.eclipse.bpmn2.modeler.ui.features.flow.AssociationFeatureContainer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;

public class AssociationPropertiesAdapter
extends ExtendedPropertiesAdapter<Association> {
    public AssociationPropertiesAdapter(AdapterFactory adapterFactory, Association object) {
        super(adapterFactory, (EObject)object);
        EReference ref = Bpmn2Package.eINSTANCE.getAssociation_SourceRef();
        this.setFeatureDescriptor((EStructuralFeature)ref, new SourceTargetFeatureDescriptor(this, object, (EStructuralFeature)ref));
        this.setProperty((EStructuralFeature)ref, "ui.can.edit.inline", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.can.edit", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.can.create.new", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.is.multi.choice", Boolean.TRUE);
        ref = Bpmn2Package.eINSTANCE.getAssociation_TargetRef();
        this.setFeatureDescriptor((EStructuralFeature)ref, new SourceTargetFeatureDescriptor(this, object, (EStructuralFeature)ref));
        this.setProperty((EStructuralFeature)ref, "ui.can.edit.inline", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.can.edit", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.can.create.new", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.is.multi.choice", Boolean.TRUE);
    }

    public class SourceTargetFeatureDescriptor
    extends FeatureDescriptor<Association> {
        public SourceTargetFeatureDescriptor(ExtendedPropertiesAdapter<Association> owner, Association object, EStructuralFeature feature) {
            super(owner, (EObject)object, feature);
        }

        public String getLabel() {
            if (this.feature == Bpmn2Package.eINSTANCE.getAssociation_SourceRef()) {
                return Messages.AssociationPropertiesAdapter_Source;
            }
            return Messages.AssociationPropertiesAdapter_Target;
        }

        protected void internalSet(Association association, EStructuralFeature feature, Object value, int index) {
            BaseElement element = null;
            if (value instanceof BaseElement) {
                element = (BaseElement)value;
            }
            if (feature == Bpmn2Package.eINSTANCE.getAssociation_SourceRef()) {
                association.setSourceRef(element);
            } else {
                association.setTargetRef(element);
            }
            this.updateConnectionIfNeeded(association, element);
        }

        private void updateConnectionIfNeeded(Association association, BaseElement element) {
            DiagramEditor diagramEditor = ModelUtil.getDiagramEditor((EObject)association);
            if (diagramEditor == null) {
                return;
            }
            boolean updateConnection = false;
            IFeatureProvider fp = diagramEditor.getDiagramTypeProvider().getFeatureProvider();
            ContainerShape eventShape = DIUtils.getContainerShape((BaseElement)association.getSourceRef());
            ContainerShape activityShape = DIUtils.getContainerShape((BaseElement)association.getTargetRef());
            Connection connection = DIUtils.getConnection((BaseElement)association);
            if (connection != null) {
                if (eventShape != null && activityShape != null) {
                    ReconnectionContext rc = null;
                    Point p = GraphicsUtil.createPoint((Anchor)connection.getStart());
                    FixPointAnchor a = AnchorUtil.createAnchor((AnchorContainer)activityShape, (Point)p);
                    rc = new ReconnectionContext(connection, connection.getStart(), (Anchor)a, null);
                    rc.setTargetPictogramElement((PictogramElement)activityShape);
                    rc.setTargetLocation(Graphiti.getPeService().getLocationRelativeToDiagram((Anchor)a));
                    rc.setReconnectType(ReconnectionContext.RECONNECT_TARGET);
                    IReconnectionFeature rf = fp.getReconnectionFeature((IReconnectionContext)rc);
                    if (rf.canReconnect((IReconnectionContext)rc)) {
                        rf.reconnect((IReconnectionContext)rc);
                        updateConnection = true;
                    }
                } else {
                    DeleteContext dc = new DeleteContext((PictogramElement)connection);
                    connection.getLink().getBusinessObjects().remove(0);
                    IDeleteFeature df = fp.getDeleteFeature((IDeleteContext)dc);
                    df.delete((IDeleteContext)dc);
                }
            } else if (eventShape != null && activityShape != null) {
                Point p = GraphicsUtil.createPoint((AnchorContainer)activityShape);
                FixPointAnchor eventAnchor = AnchorUtil.createAnchor((AnchorContainer)eventShape, (Point)p);
                p = GraphicsUtil.createPoint((AnchorContainer)eventShape);
                FixPointAnchor activityAnchor = AnchorUtil.createAnchor((AnchorContainer)activityShape, (Point)p);
                CreateConnectionContext ccc = new CreateConnectionContext();
                ccc.setSourcePictogramElement((PictogramElement)eventShape);
                ccc.setSourceAnchor((Anchor)eventAnchor);
                ccc.setTargetPictogramElement((PictogramElement)activityShape);
                ccc.setTargetAnchor((Anchor)activityAnchor);
                ICreateConnectionFeature ccf = new AssociationFeatureContainer().getCreateConnectionFeature(fp);
                connection = ccf.create((ICreateConnectionContext)ccc);
            }
            if (updateConnection) {
                FeatureSupport.updateConnection((IFeatureProvider)diagramEditor.getDiagramTypeProvider().getFeatureProvider(), (Connection)connection);
            }
        }
    }
}

