/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.composite.internal;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.gradle.api.Transformer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.event.ListenerNotificationException;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ListenerFailedException;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.TestExecutionException;
import org.gradle.tooling.composite.ModelResult;
import org.gradle.tooling.composite.internal.CompositeModelProducer;
import org.gradle.tooling.composite.internal.DefaultModelResult;
import org.gradle.tooling.composite.internal.EclipseProjectCompositeModelProducer;
import org.gradle.tooling.exceptions.UnsupportedBuildArgumentException;
import org.gradle.tooling.exceptions.UnsupportedOperationConfigurationException;
import org.gradle.tooling.internal.consumer.AbstractLongRunningOperation;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.async.AsyncConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.ConsumerAction;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.InternalBuildCancelledException;
import org.gradle.tooling.internal.protocol.ResultHandlerVersion1;
import org.gradle.tooling.internal.protocol.exceptions.InternalUnsupportedBuildArgumentException;
import org.gradle.tooling.internal.protocol.test.InternalTestExecutionException;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.util.CollectionUtils;

public class EclipseModelResultSetModelBuilder<T>
extends AbstractLongRunningOperation<EclipseModelResultSetModelBuilder<T>>
implements ModelBuilder<Set<ModelResult<T>>> {
    private final Class<T> modelType;
    private final AsyncConsumerActionExecutor connection;
    private final CompositeModelProducer<EclipseProject> compositeModelProducer;

    public EclipseModelResultSetModelBuilder(Class<T> modelType, AsyncConsumerActionExecutor connection, ConnectionParameters parameters, Set<ProjectConnection> participants) {
        super(parameters);
        this.modelType = modelType;
        this.connection = connection;
        this.compositeModelProducer = new EclipseProjectCompositeModelProducer(participants);
        this.operationParamsBuilder.setEntryPoint("Eclipse ModelBuilder API");
    }

    protected EclipseModelResultSetModelBuilder<T> getThis() {
        return this;
    }

    public ModelBuilder<Set<ModelResult<T>>> forTasks(String ... tasks) {
        throw new UnsupportedMethodException(this.createUnsupportedMethodExceptionMessage("execute tasks"));
    }

    public ModelBuilder<Set<ModelResult<T>>> forTasks(Iterable<String> tasks) {
        throw new UnsupportedMethodException(this.createUnsupportedMethodExceptionMessage("execute tasks"));
    }

    public EclipseModelResultSetModelBuilder<T> withArguments(String ... arguments) {
        throw new UnsupportedMethodException(this.createUnsupportedMethodExceptionMessage("provide arguments"));
    }

    public EclipseModelResultSetModelBuilder<T> withArguments(Iterable<String> arguments) {
        throw new UnsupportedMethodException(this.createUnsupportedMethodExceptionMessage("provide arguments"));
    }

    public EclipseModelResultSetModelBuilder<T> setStandardOutput(OutputStream outputStream) {
        throw new UnsupportedMethodException(this.createUnsupportedMethodExceptionMessage("set standard output"));
    }

    public EclipseModelResultSetModelBuilder<T> setStandardError(OutputStream outputStream) {
        throw new UnsupportedMethodException(this.createUnsupportedMethodExceptionMessage("set standard error"));
    }

    public EclipseModelResultSetModelBuilder<T> setStandardInput(InputStream inputStream) {
        throw new UnsupportedMethodException(this.createUnsupportedMethodExceptionMessage("set standard input"));
    }

    public EclipseModelResultSetModelBuilder<T> setColorOutput(boolean colorOutput) {
        throw new UnsupportedMethodException(this.createUnsupportedMethodExceptionMessage("set color output"));
    }

    public EclipseModelResultSetModelBuilder<T> setJavaHome(File javaHome) {
        throw new UnsupportedMethodException(this.createUnsupportedMethodExceptionMessage("set Java home"));
    }

    public EclipseModelResultSetModelBuilder<T> setJvmArguments(String ... jvmArguments) {
        throw new UnsupportedMethodException(this.createUnsupportedMethodExceptionMessage("provide JVM arguments"));
    }

    public EclipseModelResultSetModelBuilder<T> setJvmArguments(Iterable<String> jvmArguments) {
        throw new UnsupportedMethodException(this.createUnsupportedMethodExceptionMessage("provide JVM arguments"));
    }

    public EclipseModelResultSetModelBuilder<T> withInjectedClassPath(ClassPath classpath) {
        throw new UnsupportedMethodException(this.createUnsupportedMethodExceptionMessage("inject a classpath"));
    }

    private String createUnsupportedMethodExceptionMessage(String functionality) {
        return String.format("ModelBuilder for a composite cannot %s", functionality);
    }

    public Set<ModelResult<T>> get() throws GradleConnectionException, IllegalStateException {
        BlockingResultHandler handler = new BlockingResultHandler();
        this.get(handler);
        return handler.getResult();
    }

    public void get(ResultHandler<? super Set<ModelResult<T>>> handler) throws IllegalStateException {
        final ConsumerOperationParameters operationParameters = this.getConsumerOperationParameters();
        this.connection.run(new ConsumerAction<T>(){

            public ConsumerOperationParameters getParameters() {
                return operationParameters;
            }

            public T run(ConsumerConnection connection) {
                return EclipseModelResultSetModelBuilder.this.toModelResults(EclipseModelResultSetModelBuilder.this.compositeModelProducer.getModel());
            }
        }, new DefaultResultHandler(handler));
    }

    private <S> Set<ModelResult<S>> toModelResults(Set<S> eclipseProjects) {
        return CollectionUtils.collect(eclipseProjects, (Transformer)new Transformer<ModelResult<S>, S>(){

            public ModelResult<S> transform(S eclipseProject) {
                return new DefaultModelResult(eclipseProject);
            }
        });
    }

    private static final class BlockingResultHandler<T>
    implements ResultHandler<Set<ModelResult<T>>> {
        private final BlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);

        private BlockingResultHandler() {
        }

        public Set<ModelResult<T>> getResult() {
            Object result;
            try {
                result = this.queue.take();
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            if (result instanceof Throwable) {
                throw UncheckedException.throwAsUncheckedException((Throwable)this.attachCallerThreadStackTrace((Throwable)result));
            }
            return (Set)result;
        }

        private Throwable attachCallerThreadStackTrace(Throwable failure) {
            ArrayList<StackTraceElement> adjusted = new ArrayList<StackTraceElement>();
            adjusted.addAll(Arrays.asList(failure.getStackTrace()));
            List<StackTraceElement> currentThreadStack = Arrays.asList(Thread.currentThread().getStackTrace());
            if (!currentThreadStack.isEmpty()) {
                adjusted.addAll(currentThreadStack.subList(2, currentThreadStack.size()));
            }
            failure.setStackTrace(adjusted.toArray(new StackTraceElement[adjusted.size()]));
            return failure;
        }

        public void onComplete(Set<ModelResult<T>> result) {
            this.queue.add(result);
        }

        public void onFailure(GradleConnectionException failure) {
            this.queue.add(failure);
        }
    }

    private final class DefaultResultHandler<S>
    implements ResultHandlerVersion1<Set<ModelResult<S>>> {
        private final ResultHandler<? super Set<ModelResult<S>>> handler;

        public DefaultResultHandler(ResultHandler<? super Set<ModelResult<S>>> handler) {
            this.handler = handler;
        }

        public void onComplete(Set<ModelResult<S>> result) {
            this.handler.onComplete(result);
        }

        public void onFailure(Throwable failure) {
            if (failure instanceof InternalUnsupportedBuildArgumentException) {
                this.handler.onFailure((GradleConnectionException)new UnsupportedBuildArgumentException(this.connectionFailureMessage(failure) + "\n" + failure.getMessage(), failure));
            } else if (failure instanceof UnsupportedOperationConfigurationException) {
                this.handler.onFailure((GradleConnectionException)new UnsupportedOperationConfigurationException(this.connectionFailureMessage(failure) + "\n" + failure.getMessage(), failure.getCause()));
            } else if (failure instanceof GradleConnectionException) {
                this.handler.onFailure((GradleConnectionException)failure);
            } else if (failure instanceof InternalBuildCancelledException) {
                this.handler.onFailure((GradleConnectionException)new BuildCancelledException(this.connectionFailureMessage(failure), failure.getCause()));
            } else if (failure instanceof InternalTestExecutionException) {
                this.handler.onFailure((GradleConnectionException)new TestExecutionException(this.connectionFailureMessage(failure), failure.getCause()));
            } else if (failure instanceof BuildExceptionVersion1) {
                this.handler.onFailure((GradleConnectionException)new BuildException(this.connectionFailureMessage(failure), failure.getCause()));
            } else if (failure instanceof ListenerNotificationException) {
                this.handler.onFailure((GradleConnectionException)new ListenerFailedException(this.connectionFailureMessage(failure), ((ListenerNotificationException)failure).getCauses()));
            } else {
                this.handler.onFailure(new GradleConnectionException(this.connectionFailureMessage(failure), failure));
            }
        }

        private String connectionFailureMessage(Throwable failure) {
            String message = String.format("Could not fetch model of type '%s' using %s.", EclipseModelResultSetModelBuilder.this.modelType.getSimpleName(), EclipseModelResultSetModelBuilder.this.connection.getDisplayName());
            if (!(failure instanceof UnsupportedMethodException) && failure instanceof UnsupportedOperationException) {
                message = message + "\nMost likely the model of that type is not supported in the target Gradle version.\nTo resolve the problem you can change/upgrade the Gradle version the tooling api connects to.";
            }
            return message;
        }
    }
}

