/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.composite.internal.deduplication;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.composite.internal.RedirectedProjectLookup;
import org.gradle.tooling.composite.internal.RedirectionAwareEclipseProject;
import org.gradle.tooling.composite.internal.deduplication.HierarchicalElementDeduplicator;
import org.gradle.tooling.composite.internal.deduplication.NameDeduplicationAdapter;
import org.gradle.tooling.composite.internal.deduplication.RenamedEclipseProject;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.HierarchicalEclipseProject;

class EclipseProjectDeduplicator {
    EclipseProjectDeduplicator() {
    }

    public Set<EclipseProject> deduplicate(Set<EclipseProject> eclipseProjects) {
        RenamedEclipseProjectTracker renamedProjectTracker = new RenamedEclipseProjectTracker(eclipseProjects);
        this.deduplicate(eclipseProjects, renamedProjectTracker);
        return renamedProjectTracker.getRenamedProjects();
    }

    private void deduplicate(Set<EclipseProject> eclipseProjects, RenamedEclipseProjectTracker renamedElementTracker) {
        ArrayList projectsSortedByDir = Lists.newArrayList(eclipseProjects);
        Collections.sort(projectsSortedByDir, new Comparator<EclipseProject>(){

            @Override
            public int compare(EclipseProject left, EclipseProject right) {
                return left.getProjectDirectory().compareTo(right.getProjectDirectory());
            }
        });
        Map<EclipseProject, String> newNames = new HierarchicalElementDeduplicator<EclipseProject>(new EclipseProjectNameDeduplicationStrategy()).deduplicate(projectsSortedByDir);
        for (Map.Entry<EclipseProject, String> nameChange : newNames.entrySet()) {
            renamedElementTracker.renameTo(nameChange.getKey(), nameChange.getValue());
        }
    }

    private static class EclipseProjectNameDeduplicationStrategy
    implements NameDeduplicationAdapter<EclipseProject> {
        private EclipseProjectNameDeduplicationStrategy() {
        }

        @Override
        public String getName(EclipseProject element) {
            return element.getName();
        }

        @Override
        public EclipseProject getParent(EclipseProject element) {
            return element.getParent();
        }
    }

    private static class RenamedEclipseProjectTracker
    implements RedirectedProjectLookup {
        private final Map<HierarchicalEclipseProject, EclipseProject> originalToRenamed = Maps.newHashMap();

        public RenamedEclipseProjectTracker(Set<EclipseProject> originals) {
            for (EclipseProject eclipseProject : originals) {
                this.originalToRenamed.put((HierarchicalEclipseProject)eclipseProject, new RedirectionAwareEclipseProject(eclipseProject, this));
            }
        }

        @Override
        public EclipseProject getRedirectedProject(HierarchicalEclipseProject original) {
            return this.originalToRenamed.get(original);
        }

        public void renameTo(EclipseProject original, String newName) {
            if (!this.originalToRenamed.containsKey(original)) {
                throw new IllegalArgumentException("Project " + original.getName() + " was not one of the projects to be renamed.");
            }
            this.originalToRenamed.put((HierarchicalEclipseProject)original, new RenamedEclipseProject(original, newName, this));
        }

        public Set<EclipseProject> getRenamedProjects() {
            return ImmutableSet.copyOf(this.originalToRenamed.values());
        }
    }
}

