/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.util.internal;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import java.util.HashMap;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.tasks.AntBuilderAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternSetAntBuilderDelegate
implements AntBuilderAware {
    private final Set<String> includes;
    private final Set<String> excludes;
    private final boolean caseSensitive;

    public PatternSetAntBuilderDelegate(Set<String> includes, Set<String> excludes, boolean caseSensitive) {
        this.includes = includes;
        this.excludes = excludes;
        this.caseSensitive = caseSensitive;
    }

    private static Object logical(Object node, String op, final Action<Object> withNode) {
        GroovyObject groovyObject = (GroovyObject)node;
        groovyObject.invokeMethod(op, (Object)new Closure(null, null){

            void doCall() {
                withNode.execute(this.getDelegate());
            }
        });
        return node;
    }

    public static Object and(Object node, Action<Object> withNode) {
        return PatternSetAntBuilderDelegate.logical(node, "and", withNode);
    }

    private static Object or(Object node, Action<Object> withNode) {
        return PatternSetAntBuilderDelegate.logical(node, "or", withNode);
    }

    private static Object not(Object node, Action<Object> withNode) {
        return PatternSetAntBuilderDelegate.logical(node, "not", withNode);
    }

    private static Object addFilenames(Object node, Iterable<String> filenames, boolean caseSensitive) {
        GroovyObject groovyObject = (GroovyObject)node;
        HashMap<String, Object> props = new HashMap<String, Object>(2);
        props.put("casesensitive", caseSensitive);
        for (String filename : filenames) {
            props.put("name", filename);
            groovyObject.invokeMethod("filename", props);
        }
        return node;
    }

    @Override
    public Object addToAntBuilder(Object node, String childNodeName) {
        return PatternSetAntBuilderDelegate.and(node, new Action<Object>(){

            @Override
            public void execute(Object node) {
                if (!PatternSetAntBuilderDelegate.this.includes.isEmpty()) {
                    PatternSetAntBuilderDelegate.or(node, new Action<Object>(){

                        @Override
                        public void execute(Object node) {
                            PatternSetAntBuilderDelegate.addFilenames(node, PatternSetAntBuilderDelegate.this.includes, PatternSetAntBuilderDelegate.this.caseSensitive);
                        }
                    });
                }
                if (!PatternSetAntBuilderDelegate.this.excludes.isEmpty()) {
                    PatternSetAntBuilderDelegate.not(node, new Action<Object>(){

                        @Override
                        public void execute(Object node) {
                            PatternSetAntBuilderDelegate.or(node, new Action<Object>(){

                                @Override
                                public void execute(Object node) {
                                    PatternSetAntBuilderDelegate.addFilenames(node, PatternSetAntBuilderDelegate.this.excludes, PatternSetAntBuilderDelegate.this.caseSensitive);
                                }
                            });
                        }
                    });
                }
            }
        });
    }
}

