/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.gradle.tooling.internal.consumer.AbstractConnectionParameters;
import org.gradle.tooling.internal.consumer.ProjectConnectionParameters;

public class DefaultConnectionParameters
extends AbstractConnectionParameters
implements ProjectConnectionParameters {
    private final File projectDir;
    private final Boolean searchUpwards;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProjectConnectionParameters connectionParameters) {
        return (Builder)new Builder().setProjectDir(connectionParameters.getProjectDir()).setSearchUpwards(connectionParameters.isSearchUpwards()).setDaemonMaxIdleTimeUnits(connectionParameters.getDaemonMaxIdleTimeUnits()).setDaemonMaxIdleTimeValue(connectionParameters.getDaemonMaxIdleTimeValue()).setEmbedded(connectionParameters.isEmbedded()).setGradleUserHomeDir(connectionParameters.getGradleUserHomeDir()).setVerboseLogging(connectionParameters.getVerboseLogging());
    }

    private DefaultConnectionParameters(File gradleUserHomeDir, File projectDir, Boolean searchUpwards, Boolean embedded, Integer daemonMaxIdleTimeValue, TimeUnit daemonMaxIdleTimeUnits, File daemonBaseDir, boolean verboseLogging) {
        super(gradleUserHomeDir, embedded, daemonMaxIdleTimeValue, daemonMaxIdleTimeUnits, daemonBaseDir, verboseLogging);
        this.projectDir = projectDir;
        this.searchUpwards = searchUpwards;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public Boolean isSearchUpwards() {
        return this.searchUpwards;
    }

    public static class Builder
    extends AbstractConnectionParameters.Builder {
        private File projectDir;
        private Boolean searchUpwards;

        private Builder() {
        }

        public Builder setProjectDir(File projectDir) {
            this.projectDir = projectDir;
            return this;
        }

        public Builder setSearchUpwards(Boolean searchUpwards) {
            this.searchUpwards = searchUpwards;
            return this;
        }

        public DefaultConnectionParameters build() {
            return new DefaultConnectionParameters(this.gradleUserHomeDir, this.projectDir, this.searchUpwards, this.embedded, this.daemonMaxIdleTimeValue, this.daemonMaxIdleTimeUnits, this.daemonBaseDir, this.verboseLogging);
        }
    }
}

